/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.search.SortField;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.SearchHit;

public final class SearchHits
implements Streamable,
ToXContentFragment,
Iterable<SearchHit> {
    public static final SearchHit[] EMPTY = new SearchHit[0];
    private SearchHit[] hits;
    public long totalHits;
    private float maxScore;
    @Nullable
    private SortField[] sortFields;
    @Nullable
    private String collapseField;
    @Nullable
    private Object[] collapseValues;

    public static SearchHits empty() {
        return new SearchHits(EMPTY, 0L, 0.0f);
    }

    SearchHits() {
    }

    public SearchHits(SearchHit[] hits, long totalHits, float maxScore) {
        this(hits, totalHits, maxScore, null, null, null);
    }

    public SearchHits(SearchHit[] hits, long totalHits, float maxScore, @Nullable SortField[] sortFields, @Nullable String collapseField, @Nullable Object[] collapseValues) {
        this.hits = hits;
        this.totalHits = totalHits;
        this.maxScore = maxScore;
        this.sortFields = sortFields;
        this.collapseField = collapseField;
        this.collapseValues = collapseValues;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public SearchHit[] getHits() {
        return this.hits;
    }

    public SearchHit getAt(int position) {
        return this.hits[position];
    }

    @Nullable
    public SortField[] getSortFields() {
        return this.sortFields;
    }

    @Nullable
    public String getCollapseField() {
        return this.collapseField;
    }

    @Nullable
    public Object[] getCollapseValues() {
        return this.collapseValues;
    }

    @Override
    public Iterator<SearchHit> iterator() {
        return Arrays.stream(this.getHits()).iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("hits");
        builder.field("total", this.totalHits);
        if (Float.isNaN(this.maxScore)) {
            builder.nullField("max_score");
        } else {
            builder.field("max_score", this.maxScore);
        }
        builder.field("hits");
        builder.startArray();
        for (SearchHit hit : this.hits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SearchHits fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
        }
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        long totalHits = 0L;
        float maxScore = 0.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("total".equals(currentFieldName)) {
                    totalHits = parser.longValue();
                    continue;
                }
                if (!"max_score".equals(currentFieldName)) continue;
                maxScore = parser.floatValue();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if (!"max_score".equals(currentFieldName)) continue;
                maxScore = Float.NaN;
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("hits".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        hits.add(SearchHit.fromXContent(parser));
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            parser.skipChildren();
        }
        return new SearchHits(hits.toArray(new SearchHit[0]), totalHits, maxScore);
    }

    public static SearchHits readSearchHits(StreamInput in) throws IOException {
        SearchHits hits = new SearchHits();
        hits.readFrom(in);
        return hits;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        boolean hasTotalHits = in.getVersion().onOrAfter(Version.V_6_0_0_beta1) ? in.readBoolean() : true;
        this.totalHits = hasTotalHits ? in.readVLong() : -1L;
        this.maxScore = in.readFloat();
        int size = in.readVInt();
        if (size == 0) {
            this.hits = EMPTY;
        } else {
            this.hits = new SearchHit[size];
            for (int i = 0; i < this.hits.length; ++i) {
                this.hits[i] = SearchHit.readSearchHit(in);
            }
        }
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.sortFields = in.readOptionalArray(Lucene::readSortField, SortField[]::new);
            this.collapseField = in.readOptionalString();
            this.collapseValues = in.readOptionalArray(Lucene::readSortValue, Object[]::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        boolean hasTotalHits;
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            hasTotalHits = this.totalHits >= 0L;
            out.writeBoolean(hasTotalHits);
        } else {
            assert (this.totalHits >= 0L);
            hasTotalHits = true;
        }
        if (hasTotalHits) {
            out.writeVLong(this.totalHits);
        }
        out.writeFloat(this.maxScore);
        out.writeVInt(this.hits.length);
        if (this.hits.length > 0) {
            for (SearchHit hit : this.hits) {
                hit.writeTo(out);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeOptionalArray(Lucene::writeSortField, this.sortFields);
            out.writeOptionalString(this.collapseField);
            out.writeOptionalArray(Lucene::writeSortValue, this.collapseValues);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHits other = (SearchHits)obj;
        return Objects.equals(this.totalHits, other.totalHits) && Objects.equals(Float.valueOf(this.maxScore), Float.valueOf(other.maxScore)) && Arrays.equals(this.hits, other.hits) && Arrays.equals(this.sortFields, other.sortFields) && Objects.equals(this.collapseField, other.collapseField) && Arrays.equals(this.collapseValues, other.collapseValues);
    }

    public int hashCode() {
        return Objects.hash(this.totalHits, Float.valueOf(this.maxScore), Arrays.hashCode(this.hits), Arrays.hashCode(this.sortFields), this.collapseField, Arrays.hashCode(this.collapseValues));
    }

    public static final class Fields {
        public static final String HITS = "hits";
        public static final String TOTAL = "total";
        public static final String MAX_SCORE = "max_score";
    }
}

