/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregatorFactory;
import org.elasticsearch.search.internal.SearchContext;

public class NestedAggregationBuilder
extends AbstractAggregationBuilder<NestedAggregationBuilder> {
    public static final String NAME = "nested";
    private final String path;

    public NestedAggregationBuilder(String name, String path) {
        super(name);
        if (path == null) {
            throw new IllegalArgumentException("[path] must not be null: [" + name + "]");
        }
        this.path = path;
    }

    protected NestedAggregationBuilder(NestedAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.path = clone.path;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new NestedAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public NestedAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.path = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.path);
    }

    public String path() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AggregatorFactory<?> doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ObjectMapper childObjectMapper = context.getObjectMapper(this.path);
        if (childObjectMapper == null) {
            return new NestedAggregatorFactory(this.name, null, null, context, parent, subFactoriesBuilder, this.metaData);
        }
        if (!childObjectMapper.nested().isNested()) {
            throw new AggregationExecutionException("[nested] nested path [" + this.path + "] is not nested");
        }
        try {
            ObjectMapper parentObjectMapper = context.getQueryShardContext().nestedScope().nextLevel(childObjectMapper);
            NestedAggregatorFactory nestedAggregatorFactory = new NestedAggregatorFactory(this.name, parentObjectMapper, childObjectMapper, context, parent, subFactoriesBuilder, this.metaData);
            return nestedAggregatorFactory;
        }
        finally {
            context.getQueryShardContext().nestedScope().previousLevel();
        }
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NestedAggregator.PATH_FIELD.getPreferredName(), this.path);
        builder.endObject();
        return builder;
    }

    public static NestedAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String path = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (NestedAggregator.PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    path = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + aggregationName + "].", new Object[0]);
        }
        if (path == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [path] field for nested aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new NestedAggregationBuilder(aggregationName, path);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.path);
    }

    @Override
    protected boolean doEquals(Object obj) {
        NestedAggregationBuilder other = (NestedAggregationBuilder)obj;
        return Objects.equals(this.path, other.path);
    }

    @Override
    public String getType() {
        return NAME;
    }
}

