/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BaseProxyHandlerClass
implements InvocationHandler {
    private static final ConcurrentMap<Class, ConcurrentMap<Method, Method>> classMethodCache = new ConcurrentHashMap<Class, ConcurrentMap<Method, Method>>();
    private final ConcurrentMap<Method, Method> methodCache;

    public BaseProxyHandlerClass() {
        ConcurrentMap methodCache = (ConcurrentHashMap)classMethodCache.get(this.getClass());
        if (methodCache == null) {
            methodCache = new ConcurrentHashMap();
            ConcurrentMap previous = classMethodCache.putIfAbsent(this.getClass(), methodCache);
            if (previous != null) {
                methodCache = previous;
            }
        }
        this.methodCache = methodCache;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Method delegatedMethod = this.getDelegatedMethod(method);
            return delegatedMethod.invoke(this.isOurMethod(delegatedMethod) ? this : this.getProxiedDelegate(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private Method getDelegatedMethod(Method method) {
        Method delegated = (Method)this.methodCache.get(method);
        if (delegated != null) {
            return delegated;
        }
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            delegated = this.getClass().getMethod(method.getName(), parameterTypes);
        }
        catch (Exception ex) {
            delegated = method;
        }
        Method previous = this.methodCache.putIfAbsent(method, delegated);
        if (previous != null) {
            delegated = previous;
        }
        return delegated;
    }

    private boolean isOurMethod(Method method) {
        return this.getClass().equals(method.getDeclaringClass());
    }

    public abstract Object getProxiedDelegate() throws Exception;
}

