/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krms.api.engine.ExecutionFlag;

public final class ExecutionOptions {
    private final Map<ExecutionFlag, Boolean> flags = new HashMap<ExecutionFlag, Boolean>();
    private final Map<String, String> options = new HashMap<String, String>();

    public ExecutionOptions() {
    }

    public ExecutionOptions(ExecutionOptions executionOptions) {
        this();
        if (executionOptions != null) {
            this.flags.putAll(executionOptions.getFlags());
            this.options.putAll(executionOptions.getOptions());
        }
    }

    public ExecutionOptions setFlag(ExecutionFlag flag, boolean value) {
        if (flag == null) {
            throw new IllegalArgumentException("flag was null");
        }
        this.flags.put(flag, value);
        return this;
    }

    public ExecutionOptions setOption(String optionName, String value) {
        if (StringUtils.isBlank((String)optionName)) {
            throw new IllegalArgumentException("optionName was blank");
        }
        this.options.put(optionName, value);
        return this;
    }

    public ExecutionOptions removeFlag(ExecutionFlag flag) {
        if (flag == null) {
            throw new IllegalArgumentException("flag was null");
        }
        this.flags.remove((Object)flag);
        return this;
    }

    public ExecutionOptions removeOption(String optionName) {
        if (StringUtils.isBlank((String)optionName)) {
            throw new IllegalArgumentException("optionName was blank");
        }
        this.options.remove(optionName);
        return this;
    }

    public boolean getFlag(ExecutionFlag flag) {
        if (flag == null) {
            throw new IllegalArgumentException("flag is null");
        }
        if (this.isFlagSet(flag)) {
            return this.flags.get((Object)flag);
        }
        return flag.getDefaultValue();
    }

    public String getOption(String optionName) {
        if (StringUtils.isBlank((String)optionName)) {
            throw new IllegalArgumentException("optionName is blank");
        }
        return this.options.get(optionName);
    }

    public boolean isFlagSet(ExecutionFlag flag) {
        if (flag == null) {
            throw new IllegalArgumentException("flag is null");
        }
        return this.flags.containsKey((Object)flag);
    }

    public boolean isOptionSet(String optionName) {
        if (StringUtils.isBlank((String)optionName)) {
            throw new IllegalArgumentException("optionName is blank");
        }
        return this.options.containsKey(optionName);
    }

    public Map<ExecutionFlag, Boolean> getFlags() {
        return Collections.unmodifiableMap(new HashMap<ExecutionFlag, Boolean>(this.flags));
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(new HashMap<String, String>(this.options));
    }
}

