/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

public final class SelectionCriteria {
    private final Long effectiveExecutionTime;
    private final Map<String, String> contextQualifiers;
    private final Map<String, String> agendaQualifiers;

    private SelectionCriteria(DateTime effectiveDate) {
        this.effectiveExecutionTime = effectiveDate != null ? Long.valueOf(effectiveDate.getMillis()) : null;
        this.contextQualifiers = new HashMap<String, String>();
        this.agendaQualifiers = new HashMap<String, String>();
    }

    public static SelectionCriteria createCriteria(DateTime effectiveExecutionTime, Map<String, String> contextQualifiers, Map<String, String> agendaQualifiers) {
        SelectionCriteria criteria = new SelectionCriteria(effectiveExecutionTime);
        if (contextQualifiers != null) {
            criteria.contextQualifiers.putAll(contextQualifiers);
        }
        if (agendaQualifiers != null) {
            criteria.agendaQualifiers.putAll(agendaQualifiers);
        }
        return criteria;
    }

    public Long getEffectiveExecutionTime() {
        return this.effectiveExecutionTime;
    }

    public Map<String, String> getContextQualifiers() {
        return Collections.unmodifiableMap(this.contextQualifiers);
    }

    public Map<String, String> getAgendaQualifiers() {
        return Collections.unmodifiableMap(this.agendaQualifiers);
    }
}

