/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.core.api.util.jaxb.EnumStringAdapter;

public enum LogicalOperator implements Coded
{
    AND("&"),
    OR("|");

    private final String code;
    public static final Collection<String> OP_CODES;
    public static final Collection<String> OP_CODE_NAMES;

    private LogicalOperator(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static LogicalOperator fromCode(String code) {
        if (code == null) {
            return null;
        }
        for (LogicalOperator logicalOperator : LogicalOperator.values()) {
            if (!logicalOperator.code.equals(code)) continue;
            return logicalOperator;
        }
        throw new IllegalArgumentException("Failed to locate the LogicalOperator with the given code: " + code);
    }

    public String toString() {
        return this.code;
    }

    static {
        OP_CODES = Collections.unmodifiableCollection(Arrays.asList(LogicalOperator.AND.code, LogicalOperator.OR.code));
        OP_CODE_NAMES = Collections.unmodifiableCollection(Arrays.asList(AND.name(), OR.name()));
    }

    static final class Adapter
    extends EnumStringAdapter<LogicalOperator> {
        Adapter() {
        }

        protected Class<LogicalOperator> getEnumClass() {
            return LogicalOperator.class;
        }
    }
}

