/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.action;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.krms.api.repository.action.ActionDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="action")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ActionType", propOrder={"id", "name", "namespace", "description", "typeId", "ruleId", "sequenceNumber", "attributes", "versionNumber", "_futureElements"})
public final class ActionDefinition
extends AbstractDataTransferObject
implements ActionDefinitionContract {
    private static final long serialVersionUID = 2783959459503209577L;
    @XmlElement(name="id", required=true)
    private String id;
    @XmlElement(name="name", required=true)
    private String name;
    @XmlElement(name="namespace", required=true)
    private String namespace;
    @XmlElement(name="description", required=true)
    private String description;
    @XmlElement(name="typeId", required=true)
    private String typeId;
    @XmlElement(name="ruleId", required=true)
    private String ruleId;
    @XmlElement(name="sequenceNumber", required=true)
    private Integer sequenceNumber;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ActionDefinition() {
        this.id = null;
        this.name = null;
        this.namespace = null;
        this.description = null;
        this.typeId = null;
        this.ruleId = null;
        this.sequenceNumber = null;
        this.attributes = null;
        this.versionNumber = null;
    }

    private ActionDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.namespace = builder.getNamespace();
        this.description = builder.getDescription();
        this.typeId = builder.getTypeId();
        this.ruleId = builder.getRuleId();
        this.sequenceNumber = builder.getSequenceNumber();
        this.attributes = builder.attributes != null ? Collections.unmodifiableMap(builder.getAttributes()) : null;
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/ActionType";
    }

    public static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String NAMESPACE = "namespace";
        static final String DESC = "description";
        static final String TYPE_ID = "typeId";
        static final String RULE_ID = "ruleId";
        static final String SEQUENCE_NUMBER = "sequenceNumber";
        static final String ATTRIBUTES = "attributes";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "action";
        static final String TYPE_NAME = "ActionType";

        Constants() {
        }
    }

    public static class Builder
    implements ActionDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -6773634512570180267L;
        private String id;
        private String name;
        private String namespace;
        private String description;
        private String typeId;
        private String ruleId;
        private Integer sequenceNumber;
        private Map<String, String> attributes;
        private Long versionNumber;

        private Builder(String actionId, String name, String namespace, String typeId, String ruleId, Integer sequenceNumber) {
            this.setId(actionId);
            this.setName(name);
            this.setNamespace(namespace);
            this.setTypeId(typeId);
            this.setRuleId(ruleId);
            this.setSequenceNumber(sequenceNumber);
            this.setAttributes(new HashMap<String, String>());
        }

        public static Builder create(String actionId, String name, String namespace, String typeId, String ruleId, Integer sequenceNumber) {
            return new Builder(actionId, name, namespace, typeId, ruleId, sequenceNumber);
        }

        public static Builder create(ActionDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getId(), contract.getName(), contract.getNamespace(), contract.getTypeId(), contract.getRuleId(), contract.getSequenceNumber());
            builder.setDescription(contract.getDescription());
            if (contract.getAttributes() != null) {
                builder.setAttributes(new HashMap<String, String>(contract.getAttributes()));
            }
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String actionId) {
            if (actionId != null && StringUtils.isBlank((String)actionId)) {
                throw new IllegalArgumentException("action ID must be null or non-blank");
            }
            this.id = actionId;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace is blank");
            }
            this.namespace = namespace;
        }

        public void setDescription(String desc) {
            this.description = desc;
        }

        public void setTypeId(String typeId) {
            if (StringUtils.isBlank((String)typeId)) {
                throw new IllegalArgumentException("KRMS type id is blank");
            }
            this.typeId = typeId;
        }

        public void setRuleId(String ruleId) {
            if (ruleId != null && StringUtils.isBlank((String)ruleId)) {
                throw new IllegalArgumentException("rule id is blank");
            }
            this.ruleId = ruleId;
        }

        public void setSequenceNumber(Integer sequenceNumber) {
            if (sequenceNumber == null) {
                throw new IllegalArgumentException("sequence number is null");
            }
            this.sequenceNumber = sequenceNumber;
        }

        public void setAttributes(Map<String, String> attributes) {
            if (attributes == null) {
                this.attributes = Collections.emptyMap();
            }
            this.attributes = Collections.unmodifiableMap(attributes);
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public String getRuleId() {
            return this.ruleId;
        }

        @Override
        public Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public ActionDefinition build() {
            return new ActionDefinition(this);
        }
    }
}

