/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.ICIChainMember;
import freemarker.core.NonNumericalException;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.core.StringArraySequence;
import freemarker.core.TokenMgrError;
import freemarker.core._DelayedGetMessage;
import freemarker.core._DelayedGetMessageWithoutStackTop;
import freemarker.core._MiscTemplateException;
import freemarker.core._TemplateModelException;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.Version;
import freemarker.template.utility.StringUtil;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.StringTokenizer;

class StringBuiltins {
    private StringBuiltins() {
    }

    static class index_ofBI
    extends BuiltIn {
        private final boolean findLast;

        public index_ofBI(boolean findLast) {
            this.findLast = findLast;
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            return new BIMethod(this.target.evalAndCoerceToString(env, "For sequences/collections (lists and such) use \"?seq_index_of\" instead."));
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private final String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                int argCnt = args.size();
                index_ofBI.this.checkMethodArgCount(argCnt, 1, 2);
                String subStr = index_ofBI.this.getStringMethodArg(args, 0);
                if (argCnt > 1) {
                    int startIdx = index_ofBI.this.getNumberMethodArg(args, 1).intValue();
                    return new SimpleNumber(index_ofBI.this.findLast ? this.s.lastIndexOf(subStr, startIdx) : this.s.indexOf(subStr, startIdx));
                }
                return new SimpleNumber(index_ofBI.this.findLast ? this.s.lastIndexOf(subStr) : this.s.indexOf(subStr));
            }
        }
    }

    static class containsBI
    extends BuiltIn {
        containsBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            return new BIMethod(this.target.evalAndCoerceToString(env, "For sequences/collections (lists and such) use \"?seq_contains\" instead."));
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private final String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                containsBI.this.checkMethodArgCount(args, 1);
                return this.s.indexOf(containsBI.this.getStringMethodArg(args, 0)) != -1 ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class padBI
    extends StringBuiltIn {
        private final boolean leftPadder;

        public padBI(boolean leftPadder) {
            this.leftPadder = leftPadder;
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            return new BIMethod(s);
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private final String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                int argCnt = args.size();
                padBI.this.checkMethodArgCount(argCnt, 1, 2);
                int width = padBI.this.getNumberMethodArg(args, 0).intValue();
                if (argCnt > 1) {
                    String filling = padBI.this.getStringMethodArg(args, 1);
                    try {
                        return new SimpleScalar(padBI.this.leftPadder ? StringUtil.leftPad(this.s, width, filling) : StringUtil.rightPad(this.s, width, filling));
                    }
                    catch (IllegalArgumentException e) {
                        if (filling.length() == 0) {
                            throw new _TemplateModelException(new Object[]{"?", padBI.this.key, "(...) argument #2 can't be a 0-length string."});
                        }
                        throw new _TemplateModelException((Throwable)e, new Object[]{"?", padBI.this.key, "(...) failed: ", e});
                    }
                }
                return new SimpleScalar(padBI.this.leftPadder ? StringUtil.leftPad(this.s, width) : StringUtil.rightPad(this.s, width));
            }
        }
    }

    static class splitBI
    extends StringBuiltIn {
        splitBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            return new BIMethod(s);
        }

        private class BIMethod
        implements TemplateMethodModel {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                boolean caseInsensitive;
                int argCnt = args.size();
                splitBI.this.checkMethodArgCount(argCnt, 1, 2);
                String splitString = (String)args.get(0);
                String flags = argCnt == 2 ? (String)args.get(1) : "";
                boolean bl = caseInsensitive = flags.indexOf(105) >= 0;
                if (flags.indexOf(114) >= 0) {
                    throw new _TemplateModelException("Regular expression classes not available");
                }
                return new StringArraySequence(StringUtil.split(this.s, splitString, caseInsensitive));
            }
        }
    }

    static class replaceBI
    extends StringBuiltIn {
        replaceBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            return new BIMethod(s);
        }

        private class BIMethod
        implements TemplateMethodModel {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                boolean firstOnly;
                boolean caseInsensitive;
                int argCnt = args.size();
                replaceBI.this.checkMethodArgCount(argCnt, 2, 3);
                String first = (String)args.get(0);
                String second = (String)args.get(1);
                if (argCnt > 2) {
                    String flags = (String)args.get(2);
                    caseInsensitive = flags.indexOf(105) >= 0;
                    boolean bl = firstOnly = flags.indexOf(102) >= 0;
                    if (flags.indexOf(114) >= 0) {
                        throw new _TemplateModelException("The regular expression classes are not available.");
                    }
                } else {
                    caseInsensitive = false;
                    firstOnly = false;
                }
                return new SimpleScalar(StringUtil.replace(this.s, first, second, caseInsensitive, firstOnly));
            }
        }
    }

    static class ends_withBI
    extends StringBuiltIn {
        ends_withBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            return new BIMethod(s);
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                ends_withBI.this.checkMethodArgCount(args, 1);
                return this.s.endsWith(ends_withBI.this.getStringMethodArg(args, 0)) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class starts_withBI
    extends StringBuiltIn {
        starts_withBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            return new BIMethod(s);
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private String s;

            private BIMethod(String s) {
                this.s = s;
            }

            public Object exec(List args) throws TemplateModelException {
                starts_withBI.this.checkMethodArgCount(args, 1);
                return this.s.startsWith(starts_withBI.this.getStringMethodArg(args, 0)) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
    }

    static class urlBI
    extends StringBuiltIn {
        urlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new urlBIResult(s, env);
        }

        static class urlBIResult
        implements TemplateScalarModel,
        TemplateMethodModel {
            private final String target;
            private final Environment env;
            private String cachedResult;

            private urlBIResult(String target, Environment env) {
                this.target = target;
                this.env = env;
            }

            public String getAsString() throws TemplateModelException {
                if (this.cachedResult == null) {
                    String cs = this.env.getEffectiveURLEscapingCharset();
                    if (cs == null) {
                        throw new _TemplateModelException("To do URL encoding, the framework that encloses FreeMarker must specify the output encoding or the URL encoding charset, so ask the programmers to fix it. Or, as a last chance, you can set the url_encoding_charset setting in the template, e.g. <#setting url_escaping_charset='ISO-8859-1'>, or give the charset explicitly to the buit-in, e.g. foo?url('ISO-8859-1').");
                    }
                    try {
                        this.cachedResult = StringUtil.URLEnc(this.target, cs);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new _TemplateModelException((Throwable)e, "Failed to execute URL encoding.");
                    }
                }
                return this.cachedResult;
            }

            public Object exec(List args) throws TemplateModelException {
                if (args.size() != 1) {
                    throw new _TemplateModelException("The \"url\" built-in needs exactly 1 parameter, the charset.");
                }
                try {
                    return new SimpleScalar(StringUtil.URLEnc(this.target, (String)args.get(0)));
                }
                catch (UnsupportedEncodingException e) {
                    throw new _TemplateModelException((Throwable)e, "Failed to execute URL encoding.");
                }
            }
        }
    }

    static class rtfBI
    extends StringBuiltIn {
        rtfBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.RTFEnc(s));
        }
    }

    static class xhtmlBI
    extends StringBuiltIn {
        xhtmlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.XHTMLEnc(s));
        }
    }

    static class xmlBI
    extends StringBuiltIn {
        xmlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.XMLEnc(s));
        }
    }

    static class htmlBI
    extends StringBuiltIn
    implements ICIChainMember {
        private static final int MIN_ICE = Version.intValueFor(2, 3, 20);
        private final BIBeforeICE2d3d20 prevICEObj = new BIBeforeICE2d3d20();

        htmlBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.XHTMLEnc(s));
        }

        public int getMinimumICIVersion() {
            return MIN_ICE;
        }

        public Object getPreviousICIChainMember() {
            return this.prevICEObj;
        }

        static class BIBeforeICE2d3d20
        extends StringBuiltIn {
            BIBeforeICE2d3d20() {
            }

            TemplateModel calculateResult(String s, Environment env) {
                return new SimpleScalar(StringUtil.HTMLEnc(s));
            }
        }
    }

    static class trimBI
    extends StringBuiltIn {
        trimBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.trim());
        }
    }

    static class lengthBI
    extends StringBuiltIn {
        lengthBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            return new SimpleNumber(s.length());
        }
    }

    static class substringBI
    extends StringBuiltIn {
        substringBI() {
        }

        TemplateModel calculateResult(final String s, Environment env) throws TemplateException {
            return new TemplateMethodModelEx(){

                public Object exec(List args) throws TemplateModelException {
                    int argCount = args.size();
                    substringBI.this.checkMethodArgCount(argCount, 1, 2);
                    int left = substringBI.this.getNumberMethodArg(args, 0).intValue();
                    if (argCount > 1) {
                        return new SimpleScalar(s.substring(left, substringBI.this.getNumberMethodArg(args, 1).intValue()));
                    }
                    return new SimpleScalar(s.substring(left));
                }
            };
        }
    }

    static class numberBI
    extends StringBuiltIn {
        numberBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            try {
                return new SimpleNumber(env.getArithmeticEngine().toNumber(s));
            }
            catch (NumberFormatException nfe) {
                throw NonNumericalException.newMalformedNumberException(this, s, env);
            }
        }
    }

    static class evalBI
    extends StringBuiltIn {
        evalBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            SimpleCharStream scs = new SimpleCharStream(new StringReader("(" + s + ")"), -1000000000, 1, s.length() + 2);
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            token_source.incompatibleImprovements = env.getConfiguration().getIncompatibleImprovements().intValue();
            token_source.SwitchTo(2);
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            Expression exp = null;
            try {
                try {
                    exp = parser.Expression();
                }
                catch (TokenMgrError e) {
                    throw e.toParseException(this.getTemplate());
                }
            }
            catch (ParseException e) {
                throw new _MiscTemplateException((Expression)this, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---", "\n\nThe failing expression:"});
            }
            try {
                return exp.eval(env);
            }
            catch (TemplateException e) {
                throw new _MiscTemplateException((Expression)this, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessageWithoutStackTop(e), "\n---end-message---", "\n\nThe failing expression:"});
            }
        }
    }

    static class word_listBI
    extends StringBuiltIn {
        word_listBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            SimpleSequence result = new SimpleSequence();
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
            return result;
        }
    }

    static class lower_caseBI
    extends StringBuiltIn {
        lower_caseBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.toLowerCase(env.getLocale()));
        }
    }

    static class upper_caseBI
    extends StringBuiltIn {
        upper_caseBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.toUpperCase(env.getLocale()));
        }
    }

    static class uncap_firstBI
    extends StringBuiltIn {
        uncap_firstBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            int i;
            int ln = s.length();
            for (i = 0; i < ln && Character.isWhitespace(s.charAt(i)); ++i) {
            }
            if (i < ln) {
                StringBuffer b = new StringBuffer(s);
                b.setCharAt(i, Character.toLowerCase(s.charAt(i)));
                s = b.toString();
            }
            return new SimpleScalar(s);
        }
    }

    static class cap_firstBI
    extends StringBuiltIn {
        cap_firstBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            int i;
            int ln = s.length();
            for (i = 0; i < ln && Character.isWhitespace(s.charAt(i)); ++i) {
            }
            if (i < ln) {
                StringBuffer b = new StringBuffer(s);
                b.setCharAt(i, Character.toUpperCase(s.charAt(i)));
                s = b.toString();
            }
            return new SimpleScalar(s);
        }
    }

    static class json_stringBI
    extends StringBuiltIn {
        json_stringBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.jsonStringEnc(s));
        }
    }

    static class js_stringBI
    extends StringBuiltIn {
        js_stringBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.javaScriptStringEnc(s));
        }
    }

    static class j_stringBI
    extends StringBuiltIn {
        j_stringBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.javaStringEnc(s));
        }
    }

    static class chop_linebreakBI
    extends StringBuiltIn {
        chop_linebreakBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.chomp(s));
        }
    }

    static class capitalizeBI
    extends StringBuiltIn {
        capitalizeBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.capitalize(s));
        }
    }

    static abstract class StringBuiltIn
    extends BuiltIn {
        StringBuiltIn() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            return this.calculateResult(this.target.evalAndCoerceToString(env), env);
        }

        abstract TemplateModel calculateResult(String var1, Environment var2) throws TemplateException;
    }
}

