/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.workflow.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.exception.UnknownDocumentIdException;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class WorkflowDocumentServiceImpl
implements WorkflowDocumentService {
    private static final Logger LOG = LogManager.getLogger(WorkflowDocumentServiceImpl.class);
    protected DataObjectService dataObjectService;

    public boolean workflowDocumentExists(String documentId) {
        boolean exists = false;
        if (StringUtils.isBlank((String)documentId)) {
            throw new IllegalArgumentException("invalid (blank) documentId");
        }
        exists = KewApiServiceLocator.getWorkflowDocumentService().doesDocumentExist(documentId);
        return exists;
    }

    public WorkflowDocument createWorkflowDocument(String documentTypeName, Person person) {
        String watchName = "createWorkflowDocument";
        StopWatch watch = null;
        if (LOG.isDebugEnabled()) {
            watch = new StopWatch();
            watch.start();
            LOG.debug(watchName + ": started");
        }
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        if (person == null) {
            throw new IllegalArgumentException("invalid (null) person");
        }
        if (StringUtils.isBlank((String)person.getPrincipalName())) {
            throw new IllegalArgumentException("invalid (empty) PrincipalName");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating workflowDoc(" + documentTypeName + "," + person.getPrincipalName() + ")");
        }
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)person.getPrincipalId(), (String)documentTypeName);
        if (watch != null) {
            watch.stop();
            LOG.debug(watchName + ": " + watch.toString());
        }
        return document;
    }

    public WorkflowDocument loadWorkflowDocument(String documentId, Person user) {
        if (documentId == null) {
            throw new IllegalArgumentException("invalid (null) documentHeaderId");
        }
        if (user == null) {
            throw new IllegalArgumentException("invalid (null) workflowUser");
        }
        if (StringUtils.isEmpty((String)user.getPrincipalName())) {
            throw new IllegalArgumentException("invalid (empty) workflowUser");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("retrieving document(" + documentId + "," + user.getPrincipalName() + ")");
        }
        try {
            return WorkflowDocumentFactory.loadDocument((String)user.getPrincipalId(), (String)documentId);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownDocumentIdException("unable to locate document with documentHeaderId '" + documentId + "'", (Throwable)e);
        }
    }

    public void acknowledge(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.acknowledge(workflowDocument, annotation, null, adHocRecipients);
    }

    public void acknowledge(WorkflowDocument workflowDocument, String annotation, String nodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("acknowleding document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, nodeName, this.filterAdHocRecipients(adHocRecipients, new String[]{"K", "F"}), null);
        workflowDocument.acknowledge(annotation);
    }

    public void approve(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.approve(workflowDocument, annotation, null, adHocRecipients);
    }

    public void approve(WorkflowDocument workflowDocument, String annotation, String nodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("approving document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, nodeName, this.filterAdHocRecipients(adHocRecipients, new String[]{"K", "F", "A"}), null);
        workflowDocument.approve(annotation);
    }

    public void superUserApprove(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isInfoEnabled()) {
            LOG.info("super user approve document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        workflowDocument.superUserBlanketApprove(annotation);
    }

    public void superUserCancel(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isInfoEnabled()) {
            LOG.info("super user cancel document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        workflowDocument.superUserCancel(annotation);
    }

    public void superUserDisapprove(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isInfoEnabled()) {
            LOG.info("super user disapprove document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        workflowDocument.superUserDisapprove(annotation);
    }

    public void blanketApprove(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.blanketApprove(workflowDocument, annotation, null, adHocRecipients);
    }

    public void blanketApprove(WorkflowDocument workflowDocument, String annotation, String nodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("blanket approving document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, nodeName, this.filterAdHocRecipients(adHocRecipients, new String[]{"K", "F"}), null);
        workflowDocument.blanketApprove(annotation);
    }

    public void cancel(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("canceling document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        workflowDocument.cancel(annotation);
    }

    public void recall(WorkflowDocument workflowDocument, String annotation, boolean cancel) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("recalling document(" + workflowDocument.getDocumentId() + ",'" + annotation + "', '" + cancel + "')");
        }
        workflowDocument.recall(annotation, cancel);
    }

    public void clearFyi(WorkflowDocument workflowDocument, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.clearFyi(workflowDocument, null, adHocRecipients);
    }

    public void clearFyi(WorkflowDocument workflowDocument, String nodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("clearing FYI for document(" + workflowDocument.getDocumentId() + ")");
        }
        this.handleAdHocRouteRequests(workflowDocument, "", nodeName, this.filterAdHocRecipients(adHocRecipients, new String[]{"F"}), null);
        workflowDocument.fyi();
    }

    public void sendWorkflowNotification(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.sendWorkflowNotification(workflowDocument, annotation, adHocRecipients, null);
    }

    public void sendWorkflowNotification(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients, String notificationLabel) throws WorkflowException {
        this.sendWorkflowNotification(workflowDocument, annotation, null, adHocRecipients, notificationLabel);
    }

    public void sendWorkflowNotification(WorkflowDocument workflowDocument, String annotation, String nodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.sendWorkflowNotification(workflowDocument, annotation, nodeName, adHocRecipients, null);
    }

    public void sendWorkflowNotification(WorkflowDocument workflowDocument, String annotation, String nodeName, List<AdHocRouteRecipient> adHocRecipients, String notificationLabel) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sending FYI for document(" + workflowDocument.getDocumentId() + ")");
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, nodeName, adHocRecipients, notificationLabel);
    }

    public void disapprove(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disapproving document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        workflowDocument.disapprove(annotation);
    }

    public void route(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.route(workflowDocument, annotation, null, adHocRecipients);
    }

    public void route(WorkflowDocument workflowDocument, String annotation, String nodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("routing document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, nodeName, this.filterAdHocRecipients(adHocRecipients, new String[]{"K", "F", "A", "C"}), null);
        workflowDocument.route(annotation);
    }

    public void save(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (workflowDocument.isValidAction(ActionType.SAVE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("saving document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
            }
            workflowDocument.saveDocument(annotation);
        } else {
            this.saveRoutingData(workflowDocument);
        }
    }

    public void saveRoutingData(WorkflowDocument workflowDocument) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("saving document(" + workflowDocument.getDocumentId() + ")");
        }
        workflowDocument.saveDocumentData();
    }

    public String getCurrentRouteLevelName(WorkflowDocument workflowDocument) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getting current route level name for document(" + workflowDocument.getDocumentId());
        }
        WorkflowDocument freshCopyWorkflowDoc = this.loadWorkflowDocument(workflowDocument.getDocumentId(), GlobalVariables.getUserSession().getPerson());
        return this.getCurrentRouteNodeNames(freshCopyWorkflowDoc);
    }

    public String getCurrentRouteNodeNames(WorkflowDocument workflowDocument) {
        Set nodeNames = workflowDocument.getNodeNames();
        if (nodeNames.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String nodeName : nodeNames) {
            builder.append(nodeName).append(", ");
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }

    private void handleAdHocRouteRequests(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.handleAdHocRouteRequests(workflowDocument, annotation, null, adHocRecipients, null);
    }

    private void handleAdHocRouteRequests(WorkflowDocument workflowDocument, String annotation, String nodeName, List<AdHocRouteRecipient> adHocRecipients, String notificationLabel) throws WorkflowException {
        if (adHocRecipients != null && adHocRecipients.size() > 0) {
            if (StringUtils.isBlank((String)nodeName)) {
                Set currentNodes = workflowDocument.getSimpleNodeNames();
                if (currentNodes.isEmpty()) {
                    currentNodes = workflowDocument.getCurrentSimpleNodeNames();
                }
                if (!currentNodes.isEmpty()) {
                    nodeName = (String)currentNodes.iterator().next();
                }
            }
            ArrayList<AdHocRoutePerson> adHocRoutePersons = new ArrayList<AdHocRoutePerson>();
            ArrayList<AdHocRouteWorkgroup> adHocRouteWorkgroups = new ArrayList<AdHocRouteWorkgroup>();
            for (AdHocRouteRecipient recipient : adHocRecipients) {
                if (!StringUtils.isNotEmpty((String)recipient.getId())) continue;
                String newAnnotation = annotation;
                if (StringUtils.isBlank((String)annotation)) {
                    try {
                        String message = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("message.adhoc.annotation");
                        newAnnotation = MessageFormat.format(message, GlobalVariables.getUserSession().getPrincipalName());
                    }
                    catch (Exception ex) {
                        LOG.warn("Unable to set annotation", (Throwable)ex);
                    }
                }
                if (AdHocRouteRecipient.PERSON_TYPE.equals(recipient.getType())) {
                    Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(recipient.getId());
                    if (principal == null) {
                        throw new RiceRuntimeException("Could not locate principal with name '" + recipient.getId() + "'");
                    }
                    workflowDocument.adHocToPrincipal(ActionRequestType.fromCode((String)recipient.getActionRequested()), nodeName, newAnnotation, principal.getPrincipalId(), "", true, notificationLabel);
                    AdHocRoutePerson personRecipient = (AdHocRoutePerson)recipient;
                    adHocRoutePersons.add(personRecipient);
                    continue;
                }
                Group group = KimApiServiceLocator.getGroupService().getGroup(recipient.getId());
                if (group == null) {
                    throw new RiceRuntimeException("Could not locate group with id '" + recipient.getId() + "'");
                }
                workflowDocument.adHocToGroup(ActionRequestType.fromCode((String)recipient.getActionRequested()), nodeName, newAnnotation, group.getId(), "", true, notificationLabel);
                AdHocRouteWorkgroup groupRecipient = (AdHocRouteWorkgroup)recipient;
                adHocRouteWorkgroups.add(groupRecipient);
            }
            for (AdHocRoutePerson personRecipient : adHocRoutePersons) {
                this.dataObjectService.delete((Object)personRecipient);
            }
            for (AdHocRouteWorkgroup groupRecipient : adHocRouteWorkgroups) {
                this.dataObjectService.delete((Object)groupRecipient);
            }
        }
    }

    private List<AdHocRouteRecipient> filterAdHocRecipients(List<AdHocRouteRecipient> adHocRecipients, String[] validTypes) {
        ArrayList<AdHocRouteRecipient> realAdHocRecipients = new ArrayList<AdHocRouteRecipient>();
        if (adHocRecipients != null) {
            for (AdHocRouteRecipient proposedRecipient : adHocRecipients) {
                if (!StringUtils.isNotBlank((String)proposedRecipient.getActionRequested())) continue;
                for (int i = 0; i < validTypes.length; ++i) {
                    if (!validTypes[i].equals(proposedRecipient.getActionRequested())) continue;
                    realAdHocRecipients.add(proposedRecipient);
                }
            }
        }
        return realAdHocRecipients;
    }

    public void complete(WorkflowDocument workflowDocument, String annotation, List adHocRecipients) throws WorkflowException {
        this.complete(workflowDocument, annotation, null, adHocRecipients);
    }

    public void complete(WorkflowDocument workflowDocument, String annotation, String nodeName, List adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("routing flexDoc(" + workflowDocument.getDocumentId() + ",'" + annotation + "')");
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, nodeName, this.filterAdHocRecipients(adHocRecipients, new String[]{"C", "K", "F", "A"}), null);
        workflowDocument.complete(annotation);
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

