/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.file;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.transaction.file.ResourceManagerErrorCodes;

public class ResourceManagerException
extends Exception
implements ResourceManagerErrorCodes {
    private static final int[] ERROR_CODES = new int[]{1, 2, 1000, 1001, 1002, 3, 1004, 1005, 1006, 4000, 4001, 4002, 5000, 5001, 1007};
    private static final String[] ERROR_CODE_STRINGS = new String[]{"ERR_SYSTEM", "ERR_SYSTEM_INCONSISTENT", "ERR_NO_TX", "ERR_TXID_INVALID", "ERR_TX_INACTIVE", "ERR_TX_INCONSISTENT", "ERR_DUP_TX", "ERR_THREAD_INVALID", "ERR_ISOLATION_LEVEL_UNSUPPORTED", "ERR_RESOURCEID_INVALID", "ERR_RESOURCE_EXISTS", "ERR_NO_SUCH_RESOURCE", "ERR_LOCK", "ERR_NO_LOCK", "ERR_MARKED_FOR_ROLLBACK"};
    private static final String[] ERROR_CODE_TEXTS = new String[]{"System error", "Inconsistent system data", "Unknown transaction", "Invalid transaction id", "Transaction inactive", "Inconsistent transaction data", "Duplicate transaction id", "Thread of control is the one that not start tx", "Isolation level unsupported", "Specified resource id is invalid", "Resource already exists", "No such resource", "Locking error", "Could not acquire lock", "Transaction already marked for rollback"};
    public static final String ERR_UNKNOWN_TEXT = "Unknown error";
    public static final String ERR_UNKNOWN_CODE = "ERR_UNKNOWN";
    protected final int status;
    protected final Object txId;

    protected static final String composeMessage(String msg, int status, Object txId, Throwable cause) {
        String message = ResourceManagerException.composeMessage(msg, status, txId);
        StringBuffer messageBuffer = new StringBuffer(message);
        messageBuffer.append("\nCaused by: ");
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        messageBuffer.append(sw.getBuffer());
        return messageBuffer.toString();
    }

    protected static final String composeMessage(String msg, int status, Object txId) {
        StringBuffer composed = new StringBuffer();
        if (txId != null) {
            composed.append(txId).append(": ");
        }
        if (msg != null) {
            composed.append(msg);
            if (status != -1) {
                composed.append(" (").append(ResourceManagerException.statusToCode(status)).append(')');
            }
        } else if (status != -1) {
            composed.append(ResourceManagerException.statusToText(status));
        }
        return composed.toString();
    }

    public static final String statusToText(int status) {
        if (status == -1) {
            return ERR_UNKNOWN_TEXT;
        }
        int pos = -1;
        for (int i = 0; i < ERROR_CODES.length; ++i) {
            int code = ERROR_CODES[i];
            if (status != code) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return "Unknown error, code: " + status;
        }
        return ERROR_CODE_TEXTS[pos];
    }

    public static final String statusToCode(int status) {
        if (status == -1) {
            return ERR_UNKNOWN_CODE;
        }
        int pos = -1;
        for (int i = 0; i < ERROR_CODES.length; ++i) {
            int code = ERROR_CODES[i];
            if (status != code) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return "ERR_UNKNOWN: " + status;
        }
        return ERROR_CODE_STRINGS[pos];
    }

    public ResourceManagerException(String message, int status, Object txId) {
        super(ResourceManagerException.composeMessage(message, status, txId));
        this.status = status;
        this.txId = txId;
    }

    public ResourceManagerException(int status, Object txId) {
        this(null, status, txId);
    }

    public ResourceManagerException(String message) {
        super(message);
        this.status = -1;
        this.txId = null;
    }

    public ResourceManagerException(String message, int status, Object txId, Throwable cause) {
        super(ResourceManagerException.composeMessage(message, status, txId, cause));
        this.status = status;
        this.txId = txId;
    }

    public ResourceManagerException(String message, int status, Throwable cause) {
        this(message, status, null, cause);
    }

    public ResourceManagerException(String message, Throwable cause) {
        this(message, -1, cause);
    }

    public ResourceManagerException(int status, Object txId, Throwable cause) {
        this(null, status, txId, cause);
    }

    public String statusToString() {
        return ResourceManagerException.statusToText(this.status);
    }

    public int getStatus() {
        return this.status;
    }
}

