--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

DELIMITER /
insert into INSTITUTE_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER, UPDATE_TIMESTAMP,
UPDATE_USER, VER_NBR, OBJ_ID)
values ('KCCGB0001', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_PROPOSAL_ID VALUES(NULL)
/

insert into PROPOSAL (DOCUMENT_NUMBER, PROPOSAL_ID, PROPOSAL_NUMBER,
CREATE_TIMESTAMP, PROPOSAL_SEQUENCE_STATUS, LEAD_UNIT_NUMBER,
SEQUENCE_NUMBER, PROPOSAL_TYPE_CODE,
TITLE, SPONSOR_CODE, ACTIVITY_TYPE_CODE,
REQUESTED_START_DATE_INITIAL, REQUESTED_END_DATE_INITIAL,
REQUESTED_START_DATE_TOTAL, REQUESTED_END_DATE_TOTAL,
TOTAL_DIRECT_COST_INITIAL, TOTAL_INDIRECT_COST_INITIAL,
TOTAL_DIRECT_COST_TOTAL, TOTAL_INDIRECT_COST_TOTAL,
SUBCONTRACT_FLAG, COST_SHARING_INDICATOR,
IDC_RATE_INDICATOR, STATUS_CODE, SCIENCE_CODE_INDICATOR,
IP_REVIEW_ACTIVITY_INDICATOR, CFDA_NUMBER, SPECIAL_REVIEW_INDICATOR,
UPDATE_TIMESTAMP, UPDATE_USER, AWARD_TYPE_CODE,
VER_NBR, OBJ_ID)
values ('KCCGB0001', (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '80070',
NOW(), 'ACTIVE', '000001',
1, '1',
'LOC - by award', '055075', '3',
STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
200000, 100000,
200000, 100000,
'N', '0',
'0', '2', '0',
'A', '00.000', '0',
NOW(), 'admin', 1,
1, UUID())
/

insert into PROPOSAL_PERSONS (PROPOSAL_PERSON_ID, PROPOSAL_ID,
PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
'80070', 1, '2191506168',
'WILTON K LYKINS', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into PROPOSAL_PERSON_UNITS (PROPOSAL_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, PROPOSAL_PERSON_UNIT_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID(), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID))
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/

insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/

insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/

insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/
insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
4, '5', NOW(), 'admin', 1, UUID())
/

insert into INSTITUTE_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER, UPDATE_TIMESTAMP,
UPDATE_USER, VER_NBR, OBJ_ID)
values ('KCCGB0002', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_PROPOSAL_ID VALUES(NULL)
/

insert into PROPOSAL (DOCUMENT_NUMBER, PROPOSAL_ID, PROPOSAL_NUMBER,
CREATE_TIMESTAMP, PROPOSAL_SEQUENCE_STATUS, LEAD_UNIT_NUMBER,
SEQUENCE_NUMBER, PROPOSAL_TYPE_CODE,
TITLE, SPONSOR_CODE, ACTIVITY_TYPE_CODE,
REQUESTED_START_DATE_INITIAL, REQUESTED_END_DATE_INITIAL,
REQUESTED_START_DATE_TOTAL, REQUESTED_END_DATE_TOTAL,
TOTAL_DIRECT_COST_INITIAL, TOTAL_INDIRECT_COST_INITIAL,
TOTAL_DIRECT_COST_TOTAL, TOTAL_INDIRECT_COST_TOTAL,
SUBCONTRACT_FLAG, COST_SHARING_INDICATOR,
IDC_RATE_INDICATOR, STATUS_CODE, SCIENCE_CODE_INDICATOR,
IP_REVIEW_ACTIVITY_INDICATOR, CFDA_NUMBER, SPECIAL_REVIEW_INDICATOR,
UPDATE_TIMESTAMP, UPDATE_USER, AWARD_TYPE_CODE,
VER_NBR, OBJ_ID)
values ('KCCGB0002', (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '80072',
NOW(), 'ACTIVE', '000001',
1, '1',
'LOC - by acct', '055124', '8',
STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20160630', '%Y%m%d'),
200000, 100000,
200000, 100000,
'N', '0',
'0', '2', '0',
'A', '00.000', '0',
NOW(), 'admin', 1,
1, UUID())
/

insert into PROPOSAL_PERSONS (PROPOSAL_PERSON_ID, PROPOSAL_ID,
PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
'80072', 1, '3428005487',
'WILLARD X JOHNSTONE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into PROPOSAL_PERSON_UNITS (PROPOSAL_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, PROPOSAL_PERSON_UNIT_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID(), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID))
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/

insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/

insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/

insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/
insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
4, '5', NOW(), 'admin', 1, UUID())
/

insert into INSTITUTE_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER, UPDATE_TIMESTAMP,
UPDATE_USER, VER_NBR, OBJ_ID)
values ('KCCGB0003', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_PROPOSAL_ID VALUES(NULL)
/

insert into PROPOSAL (DOCUMENT_NUMBER, PROPOSAL_ID, PROPOSAL_NUMBER,
CREATE_TIMESTAMP, PROPOSAL_SEQUENCE_STATUS, LEAD_UNIT_NUMBER,
SEQUENCE_NUMBER, PROPOSAL_TYPE_CODE,
TITLE, SPONSOR_CODE, ACTIVITY_TYPE_CODE,
REQUESTED_START_DATE_INITIAL, REQUESTED_END_DATE_INITIAL,
REQUESTED_START_DATE_TOTAL, REQUESTED_END_DATE_TOTAL,
TOTAL_DIRECT_COST_INITIAL, TOTAL_INDIRECT_COST_INITIAL,
TOTAL_DIRECT_COST_TOTAL, TOTAL_INDIRECT_COST_TOTAL,
SUBCONTRACT_FLAG, COST_SHARING_INDICATOR,
IDC_RATE_INDICATOR, STATUS_CODE, SCIENCE_CODE_INDICATOR,
IP_REVIEW_ACTIVITY_INDICATOR, CFDA_NUMBER, SPECIAL_REVIEW_INDICATOR,
UPDATE_TIMESTAMP, UPDATE_USER, AWARD_TYPE_CODE,
VER_NBR, OBJ_ID)
values ('KCCGB0003', (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '80073',
NOW(), 'ACTIVE', '000001',
1, '1',
'LOC - by cc acct', '055125', '8',
STR_TO_DATE('20140131', '%Y%m%d'), STR_TO_DATE('20170430', '%Y%m%d'),
STR_TO_DATE('20140131', '%Y%m%d'), STR_TO_DATE('20170430', '%Y%m%d'),
300000, 100000,
300000, 100000,
'N', '0',
'0', '2', '0',
'A', '00.000', '0',
NOW(), 'admin', 1,
1, UUID())
/

insert into PROPOSAL_PERSONS (PROPOSAL_PERSON_ID, PROPOSAL_ID,
PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
'80073', 1, '1821805071',
'ELMER H ARMENDARIZ', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into PROPOSAL_PERSON_UNITS (PROPOSAL_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, PROPOSAL_PERSON_UNIT_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID(), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID))
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/

insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/

insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/

insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/
insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
4, '5', NOW(), 'admin', 1, UUID())
/

insert into INSTITUTE_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER, UPDATE_TIMESTAMP,
UPDATE_USER, VER_NBR, OBJ_ID)
values ('KCCGB0004', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_PROPOSAL_ID VALUES(NULL)
/

insert into PROPOSAL (DOCUMENT_NUMBER, PROPOSAL_ID, PROPOSAL_NUMBER,
CREATE_TIMESTAMP, PROPOSAL_SEQUENCE_STATUS, LEAD_UNIT_NUMBER,
SEQUENCE_NUMBER, PROPOSAL_TYPE_CODE,
TITLE, SPONSOR_CODE, ACTIVITY_TYPE_CODE,
REQUESTED_START_DATE_INITIAL, REQUESTED_END_DATE_INITIAL,
REQUESTED_START_DATE_TOTAL, REQUESTED_END_DATE_TOTAL,
TOTAL_DIRECT_COST_INITIAL, TOTAL_INDIRECT_COST_INITIAL,
TOTAL_DIRECT_COST_TOTAL, TOTAL_INDIRECT_COST_TOTAL,
SUBCONTRACT_FLAG, COST_SHARING_INDICATOR,
IDC_RATE_INDICATOR, STATUS_CODE, SCIENCE_CODE_INDICATOR,
IP_REVIEW_ACTIVITY_INDICATOR, CFDA_NUMBER, SPECIAL_REVIEW_INDICATOR,
UPDATE_TIMESTAMP, UPDATE_USER, AWARD_TYPE_CODE,
VER_NBR, OBJ_ID)
values ('KCCGB0004', (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '80075',
NOW(), 'ACTIVE', '000001',
1, '1',
'MILE - by acct', '055076', '6',
STR_TO_DATE('20140115', '%Y%m%d'), STR_TO_DATE('20170228', '%Y%m%d'),
STR_TO_DATE('20140115', '%Y%m%d'), STR_TO_DATE('20170228', '%Y%m%d'),
100000, 10000,
100000, 10000,
'N', '0',
'0', '2', '0',
'A', '00.000', '0',
NOW(), 'admin', 1,
1, UUID())
/

insert into PROPOSAL_PERSONS (PROPOSAL_PERSON_ID, PROPOSAL_ID,
PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
'80075', 1, '3012703100',
'FRANCIS T SILER', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into PROPOSAL_PERSON_UNITS (PROPOSAL_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, PROPOSAL_PERSON_UNIT_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID(), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID))
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/

insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/

insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/

insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/
insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
4, '5', NOW(), 'admin', 1, UUID())
/

insert into INSTITUTE_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER, UPDATE_TIMESTAMP,
UPDATE_USER, VER_NBR, OBJ_ID)
values ('KCCGB0005', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_PROPOSAL_ID VALUES(NULL)
/

insert into PROPOSAL (DOCUMENT_NUMBER, PROPOSAL_ID, PROPOSAL_NUMBER,
CREATE_TIMESTAMP, PROPOSAL_SEQUENCE_STATUS, LEAD_UNIT_NUMBER,
SEQUENCE_NUMBER, PROPOSAL_TYPE_CODE,
TITLE, SPONSOR_CODE, ACTIVITY_TYPE_CODE,
REQUESTED_START_DATE_INITIAL, REQUESTED_END_DATE_INITIAL,
REQUESTED_START_DATE_TOTAL, REQUESTED_END_DATE_TOTAL,
TOTAL_DIRECT_COST_INITIAL, TOTAL_INDIRECT_COST_INITIAL,
TOTAL_DIRECT_COST_TOTAL, TOTAL_INDIRECT_COST_TOTAL,
SUBCONTRACT_FLAG, COST_SHARING_INDICATOR,
IDC_RATE_INDICATOR, STATUS_CODE, SCIENCE_CODE_INDICATOR,
IP_REVIEW_ACTIVITY_INDICATOR, CFDA_NUMBER, SPECIAL_REVIEW_INDICATOR,
UPDATE_TIMESTAMP, UPDATE_USER, AWARD_TYPE_CODE,
VER_NBR, OBJ_ID)
values ('KCCGB0005', (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '80078',
NOW(), 'ACTIVE', '000001',
1, '1',
'PD - by acct', '055078', '3',
STR_TO_DATE('20140106', '%Y%m%d'), STR_TO_DATE('20180205', '%Y%m%d'),
STR_TO_DATE('20140106', '%Y%m%d'), STR_TO_DATE('20180205', '%Y%m%d'),
200000, 10100,
200000, 10100,
'N', '0',
'0', '2', '0',
'A', '00.000', '0',
NOW(), 'admin', 1,
1, UUID())
/

insert into PROPOSAL_PERSONS (PROPOSAL_PERSON_ID, PROPOSAL_ID,
PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
'80078', 1, '1308508136',
'"HAGOOD', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into PROPOSAL_PERSON_UNITS (PROPOSAL_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, PROPOSAL_PERSON_UNIT_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID(), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID))
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/

insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/

insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/

insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/
insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
4, '5', NOW(), 'admin', 1, UUID())
/

insert into INSTITUTE_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER, UPDATE_TIMESTAMP,
UPDATE_USER, VER_NBR, OBJ_ID)
values ('KCCGB0006', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_PROPOSAL_ID VALUES(NULL)
/

insert into PROPOSAL (DOCUMENT_NUMBER, PROPOSAL_ID, PROPOSAL_NUMBER,
CREATE_TIMESTAMP, PROPOSAL_SEQUENCE_STATUS, LEAD_UNIT_NUMBER,
SEQUENCE_NUMBER, PROPOSAL_TYPE_CODE,
TITLE, SPONSOR_CODE, ACTIVITY_TYPE_CODE,
REQUESTED_START_DATE_INITIAL, REQUESTED_END_DATE_INITIAL,
REQUESTED_START_DATE_TOTAL, REQUESTED_END_DATE_TOTAL,
TOTAL_DIRECT_COST_INITIAL, TOTAL_INDIRECT_COST_INITIAL,
TOTAL_DIRECT_COST_TOTAL, TOTAL_INDIRECT_COST_TOTAL,
SUBCONTRACT_FLAG, COST_SHARING_INDICATOR,
IDC_RATE_INDICATOR, STATUS_CODE, SCIENCE_CODE_INDICATOR,
IP_REVIEW_ACTIVITY_INDICATOR, CFDA_NUMBER, SPECIAL_REVIEW_INDICATOR,
UPDATE_TIMESTAMP, UPDATE_USER, AWARD_TYPE_CODE,
VER_NBR, OBJ_ID)
values ('KCCGB0006', (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '80066',
NOW(), 'ACTIVE', '000001',
1, '1',
'MONTHLY - by award', '055079', '2',
STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
100000, 2000,
100000, 2000,
'N', '0',
'0', '2', '0',
'A', '00.000', '0',
NOW(), 'admin', 1,
1, UUID())
/

insert into PROPOSAL_PERSONS (PROPOSAL_PERSON_ID, PROPOSAL_ID,
PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
'80066', 1, '2552202601',
'"ISOM', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into PROPOSAL_PERSON_UNITS (PROPOSAL_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, PROPOSAL_PERSON_UNIT_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID(), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID))
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/

insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/

insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/

insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/
insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
4, '5', NOW(), 'admin', 1, UUID())
/

insert into INSTITUTE_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER, UPDATE_TIMESTAMP,
UPDATE_USER, VER_NBR, OBJ_ID)
values ('KCCGB0008', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_PROPOSAL_ID VALUES(NULL)
/

insert into PROPOSAL (DOCUMENT_NUMBER, PROPOSAL_ID, PROPOSAL_NUMBER,
CREATE_TIMESTAMP, PROPOSAL_SEQUENCE_STATUS, LEAD_UNIT_NUMBER,
SEQUENCE_NUMBER, PROPOSAL_TYPE_CODE,
TITLE, SPONSOR_CODE, ACTIVITY_TYPE_CODE,
REQUESTED_START_DATE_INITIAL, REQUESTED_END_DATE_INITIAL,
REQUESTED_START_DATE_TOTAL, REQUESTED_END_DATE_TOTAL,
TOTAL_DIRECT_COST_INITIAL, TOTAL_INDIRECT_COST_INITIAL,
TOTAL_DIRECT_COST_TOTAL, TOTAL_INDIRECT_COST_TOTAL,
SUBCONTRACT_FLAG, COST_SHARING_INDICATOR,
IDC_RATE_INDICATOR, STATUS_CODE, SCIENCE_CODE_INDICATOR,
IP_REVIEW_ACTIVITY_INDICATOR, CFDA_NUMBER, SPECIAL_REVIEW_INDICATOR,
UPDATE_TIMESTAMP, UPDATE_USER, AWARD_TYPE_CODE,
VER_NBR, OBJ_ID)
values ('KCCGB0008', (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '80068',
NOW(), 'ACTIVE', '000001',
1, '1',
'MONTHLY - by cc acct', '055127', '5',
STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
STR_TO_DATE('20140217', '%Y%m%d'), STR_TO_DATE('20160229', '%Y%m%d'),
200000, 50000,
200000, 50000,
'N', '0',
'0', '2', '0',
'A', '00.000', '0',
NOW(), 'admin', 1,
1, UUID())
/

insert into PROPOSAL_PERSONS (PROPOSAL_PERSON_ID, PROPOSAL_ID,
PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
'80068', 1, '5175504470',
'"MARBLE', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into PROPOSAL_PERSON_UNITS (PROPOSAL_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, PROPOSAL_PERSON_UNIT_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID(), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID))
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/

insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/

insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/

insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/
insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
4, '5', NOW(), 'admin', 1, UUID())
/

insert into INSTITUTE_PROPOSAL_DOCUMENT (DOCUMENT_NUMBER, UPDATE_TIMESTAMP,
UPDATE_USER, VER_NBR, OBJ_ID)
values ('KCCGB0007', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_PROPOSAL_ID VALUES(NULL)
/

insert into PROPOSAL (DOCUMENT_NUMBER, PROPOSAL_ID, PROPOSAL_NUMBER,
CREATE_TIMESTAMP, PROPOSAL_SEQUENCE_STATUS, LEAD_UNIT_NUMBER,
SEQUENCE_NUMBER, PROPOSAL_TYPE_CODE,
TITLE, SPONSOR_CODE, ACTIVITY_TYPE_CODE,
REQUESTED_START_DATE_INITIAL, REQUESTED_END_DATE_INITIAL,
REQUESTED_START_DATE_TOTAL, REQUESTED_END_DATE_TOTAL,
TOTAL_DIRECT_COST_INITIAL, TOTAL_INDIRECT_COST_INITIAL,
TOTAL_DIRECT_COST_TOTAL, TOTAL_INDIRECT_COST_TOTAL,
SUBCONTRACT_FLAG, COST_SHARING_INDICATOR,
IDC_RATE_INDICATOR, STATUS_CODE, SCIENCE_CODE_INDICATOR,
IP_REVIEW_ACTIVITY_INDICATOR, CFDA_NUMBER, SPECIAL_REVIEW_INDICATOR,
UPDATE_TIMESTAMP, UPDATE_USER, AWARD_TYPE_CODE,
VER_NBR, OBJ_ID)
values ('KCCGB0007', (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '80067',
NOW(), 'ACTIVE', '000001',
1, '1',
'MONTHLY - by acct', '055126', '3',
STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20170201', '%Y%m%d'),
STR_TO_DATE('20140101', '%Y%m%d'), STR_TO_DATE('20170201', '%Y%m%d'),
200000, 100000,
200000, 100000,
'N', '0',
'0', '2', '0',
'A', '00.000', '0',
NOW(), 'admin', 1,
1, UUID())
/

insert into PROPOSAL_PERSONS (PROPOSAL_PERSON_ID, PROPOSAL_ID,
PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID,
FULL_NAME, CONTACT_ROLE_CODE, FACULTY_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
'80067', 1, '1210908400',
'DALE B DISNEY', 'PI', 'N',
NOW(), 'admin', 1, UUID())
/

insert into PROPOSAL_PERSON_UNITS (PROPOSAL_PERSON_ID, UNIT_NUMBER, LEAD_UNIT_FLAG,
UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, PROPOSAL_PERSON_UNIT_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID), '000001', 'Y',
NOW(), 'admin', 1, UUID(), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID))
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/

insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPCS_ID VALUES(NULL)
/
insert into PROPOSAL_PER_CREDIT_SPLIT (PROPOSAL_PER_CREDIT_SPLIT_ID, PROPOSAL_PERSON_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPCS_ID) , (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/

insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
0, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
2, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQUENCE_IPPUCS_ID VALUES(NULL)
/
insert into PROPOSAL_PERS_UNIT_CRED_SPLITS (PPU_CREDIT_SPLIT_ID, PROPOSAL_PERSON_UNIT_ID,
INV_CREDIT_TYPE_CODE, CREDIT, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQUENCE_IPPUCS_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
3, 100.00, NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/

insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
1, '05', NOW(), 'admin', 1, UUID())
/
INSERT INTO SEQ_PROPOSAL_CUSTOM_DATA_ID VALUES(NULL)
/
insert into PROPOSAL_CUSTOM_DATA (PROPOSAL_CUSTOM_DATA_ID, PROPOSAL_ID,
CUSTOM_ATTRIBUTE_ID, VALUE, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
values ((SELECT (MAX(ID)) FROM SEQ_PROPOSAL_CUSTOM_DATA_ID), (SELECT (MAX(ID)) FROM SEQ_PROPOSAL_PROPOSAL_ID),
4, '5', NOW(), 'admin', 1, UUID())
/


DELIMITER ;
