/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceproxies;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

public class MessageSendingTransactionSynchronization
extends TransactionSynchronizationAdapter {
    private static final Logger LOG = LogManager.getLogger(MessageSendingTransactionSynchronization.class);
    private final PersistedMessageBO message;

    public MessageSendingTransactionSynchronization(PersistedMessageBO message) {
        this.message = message;
    }

    public void afterCompletion(int status) {
        if (status == 0) {
            KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(this.message));
        } else {
            LOG.warn("Message " + this.message + " not sent because transaction has a status of " + (status == 1 ? "STATUS_ROLLED_BACK" : (status == 2 ? "STATUS_UNKNOWN" : Integer.valueOf(status).toString())));
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

