/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kcb.bo.Message;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.bo.MessageDeliveryStatus;
import org.kuali.rice.kcb.service.MessageDeliveryService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class MessageDeliveryServiceImpl
implements MessageDeliveryService {
    private static final Logger LOG = LogManager.getLogger(MessageDeliveryServiceImpl.class);
    private DataObjectService dataObjectService;
    private int maxProcessAttempts;

    public void setMaxProcessAttempts(int maxProcessAttempts) {
        this.maxProcessAttempts = maxProcessAttempts;
    }

    @Override
    public MessageDelivery saveMessageDelivery(MessageDelivery delivery) {
        return (MessageDelivery)this.dataObjectService.save((Object)delivery, new PersistenceOption[0]);
    }

    @Override
    public void deleteMessageDelivery(MessageDelivery messageDelivery) {
        this.dataObjectService.delete((Object)messageDelivery);
    }

    @Override
    public Collection<MessageDelivery> getAllMessageDeliveries() {
        return this.dataObjectService.findMatching(MessageDelivery.class, QueryByCriteria.Builder.create().build()).getResults();
    }

    @Override
    public MessageDelivery getMessageDelivery(Long id) {
        return (MessageDelivery)this.dataObjectService.find(MessageDelivery.class, (Object)id);
    }

    @Override
    public MessageDelivery getMessageDeliveryByDelivererSystemId(Long id) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"delivererSystemId", (Object)id)});
        List results = this.dataObjectService.findMatching(MessageDelivery.class, criteria.build()).getResults();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new RuntimeException("More than one message delivery found with the following delivery system id: " + id);
        }
        return (MessageDelivery)results.get(0);
    }

    @Override
    public Collection<MessageDelivery> getMessageDeliveries(Message message) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"message", (Object)message.getId())});
        return this.dataObjectService.findMatching(MessageDelivery.class, criteria.build()).getResults();
    }

    @Override
    public Collection<MessageDelivery> lockAndTakeMessageDeliveries(MessageDeliveryStatus[] statuses) {
        return this.lockAndTakeMessageDeliveries(null, statuses);
    }

    @Override
    public Collection<MessageDelivery> lockAndTakeMessageDeliveries(Long messageId, MessageDeliveryStatus[] statuses) {
        LOG.debug("========>> ENTERING LockAndTakeMessageDeliveries: " + Thread.currentThread());
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.isNull((String)"lockedDate"));
        if (messageId != null) {
            predicates.add(PredicateFactory.equal((String)"message.id", (Object)messageId));
        }
        predicates.add(PredicateFactory.lessThan((String)"processCount", (Object)this.maxProcessAttempts));
        ArrayList<String> statusCollection = new ArrayList<String>(statuses.length);
        for (MessageDeliveryStatus status : statuses) {
            statusCollection.add(status.name());
        }
        predicates.add(PredicateFactory.in((String)"deliveryStatus", statusCollection));
        criteria.setPredicates(predicates.toArray(new Predicate[predicates.size()]));
        List messageDeliveries = this.dataObjectService.findMatching(MessageDelivery.class, criteria.build()).getResults();
        ArrayList<MessageDelivery> lockedMsgDels = new ArrayList<MessageDelivery>();
        for (MessageDelivery delivery : messageDeliveries) {
            LOG.debug("Took: " + delivery);
            delivery.setLockedDate(new Timestamp(System.currentTimeMillis()));
            delivery = (MessageDelivery)this.dataObjectService.save((Object)delivery, new PersistenceOption[0]);
            lockedMsgDels.add(delivery);
        }
        LOG.debug("<<=======  LEAVING LockAndTakeMessageDeliveries: " + Thread.currentThread());
        return lockedMsgDels;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

