/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.impl.services.CoreImplServiceLocator;
import org.kuali.rice.kim.api.common.attribute.KimAttribute;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.bo.ui.KimDocumentAttributeDataBusinessObjectBase;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class AttributeValidationHelper {
    private static final Logger LOG = LogManager.getLogger(AttributeValidationHelper.class);
    private static final String DOCUMENT_PROPERTY_PREFIX = "document.";

    protected KimAttribute getAttributeDefinitionById(String id) {
        String cacheKey;
        CacheManager cm = CoreImplServiceLocator.getCacheManagerRegistry().getCacheManagerByCacheName("http://rice.kuali.org/kim/v2_0/KimAttributeType");
        Cache cache = cm.getCache("http://rice.kuali.org/kim/v2_0/KimAttributeType");
        Cache.ValueWrapper valueWrapper = cache.get((Object)(cacheKey = "id=" + id));
        if (valueWrapper != null) {
            return (KimAttribute)valueWrapper.get();
        }
        KimAttributeBo attributeImpl = (KimAttributeBo)KradDataServiceLocator.getDataObjectService().find(KimAttributeBo.class, (Object)id);
        KimAttribute attribute = KimAttributeBo.to((KimAttributeBo)attributeImpl);
        cache.put((Object)cacheKey, (Object)attribute);
        return attribute;
    }

    protected KimAttribute getAttributeDefinitionByName(String attributeName) {
        String cacheKey;
        CacheManager cm = CoreImplServiceLocator.getCacheManagerRegistry().getCacheManagerByCacheName("http://rice.kuali.org/kim/v2_0/KimAttributeType");
        Cache cache = cm.getCache("http://rice.kuali.org/kim/v2_0/KimAttributeType");
        Cache.ValueWrapper valueWrapper = cache.get((Object)(cacheKey = "name=" + attributeName));
        if (valueWrapper != null) {
            return (KimAttribute)valueWrapper.get();
        }
        List attributeImpls = KradDataServiceLocator.getDataObjectService().findMatching(KimAttributeBo.class, QueryByCriteria.Builder.forAttribute((String)"attributeName", (Object)attributeName).build()).getResults();
        KimAttribute attribute = null;
        if (!attributeImpls.isEmpty()) {
            attribute = KimAttributeBo.to((KimAttributeBo)((KimAttributeBo)attributeImpls.get(0)));
        }
        cache.put((Object)cacheKey, attribute);
        return attribute;
    }

    public Map<String, String> convertAttributesToMap(List<? extends KimAttributeDataBo> attributes) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (KimAttributeDataBo kimAttributeDataBo : attributes) {
            KimAttribute attrib = this.getAttributeDefinitionById(kimAttributeDataBo.getKimAttributeId());
            if (attrib != null) {
                m.put(attrib.getAttributeName(), kimAttributeDataBo.getAttributeValue());
                continue;
            }
            LOG.error("Unable to get attribute name for ID:" + kimAttributeDataBo.getKimAttributeId());
        }
        return m;
    }

    public Map<String, String> convertQualifiersToMap(List<? extends KimDocumentAttributeDataBusinessObjectBase> qualifiers) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (KimDocumentAttributeDataBusinessObjectBase kimDocumentAttributeDataBusinessObjectBase : qualifiers) {
            KimAttribute attrib = this.getAttributeDefinitionById(kimDocumentAttributeDataBusinessObjectBase.getKimAttrDefnId());
            if (attrib != null) {
                m.put(attrib.getAttributeName(), kimDocumentAttributeDataBusinessObjectBase.getAttrVal());
                continue;
            }
            LOG.error("Unable to get attribute name for ID:" + kimDocumentAttributeDataBusinessObjectBase.getKimAttrDefnId());
        }
        return m;
    }

    public Map<String, String> getBlankValueQualifiersMap(List<KimTypeAttribute> attributes) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (KimTypeAttribute attribute : attributes) {
            KimAttribute attrib = this.getAttributeDefinitionById(attribute.getKimAttribute().getId());
            if (attrib != null) {
                m.put(attrib.getAttributeName(), "");
                continue;
            }
            LOG.error("Unable to get attribute name for ID:" + attribute.getId());
        }
        return m;
    }

    public Map<String, String> convertQualifiersToAttrIdxMap(List<? extends KimDocumentAttributeDataBusinessObjectBase> qualifiers) {
        HashMap<String, String> m = new HashMap<String, String>();
        int i = 0;
        for (KimDocumentAttributeDataBusinessObjectBase kimDocumentAttributeDataBusinessObjectBase : qualifiers) {
            KimAttribute attrib = this.getAttributeDefinitionById(kimDocumentAttributeDataBusinessObjectBase.getKimAttrDefnId());
            if (attrib != null) {
                m.put(attrib.getAttributeName(), Integer.toString(i));
            } else {
                LOG.error("Unable to get attribute name for ID:" + kimDocumentAttributeDataBusinessObjectBase.getKimAttrDefnId());
            }
            ++i;
        }
        return m;
    }

    public void moveValidationErrorsToErrorMap(List<RemotableAttributeError> validationErrors) {
        for (RemotableAttributeError error : validationErrors) {
            for (String errMsg : error.getErrors()) {
                String[] splitMsg = StringUtils.split((String)errMsg, (String)":");
                if (error.getAttributeName().startsWith(DOCUMENT_PROPERTY_PREFIX)) {
                    GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(error.getAttributeName(), splitMsg[0], splitMsg.length > 1 ? StringUtils.split((String)splitMsg[1], (String)";") : new String[]{});
                    continue;
                }
                GlobalVariables.getMessageMap().putError(error.getAttributeName(), splitMsg[0], splitMsg.length > 1 ? StringUtils.split((String)splitMsg[1], (String)";") : new String[]{});
            }
        }
    }

    public List<RemotableAttributeError> convertErrorsForMappedFields(String errorPath, List<RemotableAttributeError> localErrors) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (errorPath == null) {
            errorPath = "";
        } else if (StringUtils.isNotEmpty((String)errorPath)) {
            errorPath = (String)errorPath + ".";
        }
        for (RemotableAttributeError error : localErrors) {
            KimAttribute attribute = this.getAttributeDefinitionByName(error.getAttributeName());
            String attributeDefnId = attribute == null ? "" : attribute.getId();
            errors.add(RemotableAttributeError.Builder.create((String)((String)errorPath + "qualifier(" + attributeDefnId + ").attrVal"), (List)error.getErrors()).build());
        }
        return errors;
    }

    public List<RemotableAttributeError> convertErrors(String errorPath, Map<String, String> attrIdxMap, List<RemotableAttributeError> localErrors) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (errorPath == null) {
            errorPath = "";
        } else if (StringUtils.isNotEmpty((String)errorPath)) {
            errorPath = (String)errorPath + ".";
        }
        for (RemotableAttributeError error : localErrors) {
            for (String errMsg : error.getErrors()) {
                errors.add(RemotableAttributeError.Builder.create((String)((String)errorPath + "qualifiers[" + attrIdxMap.get(error.getAttributeName()) + "].attrVal"), (String[])new String[]{errMsg}).build());
            }
        }
        return errors;
    }
}

