/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.config.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.core.framework.config.module.WebModuleConfiguration;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;

public class WebModuleLoaderListener
implements ServletContextListener {
    private static final Logger LOG = LogManager.getLogger(WebModuleLoaderListener.class);
    private static final QName RESOURCE_LOADER_NAME = new QName("org.kuali.rice.web", "WebModuleResourceLoader");

    public void contextInitialized(ServletContextEvent event) {
        List<String> springFileLocations = this.getSpringFileLocations();
        if (CollectionUtils.isNotEmpty(springFileLocations)) {
            LOG.info("Initializing " + this.getClass().getSimpleName() + " with spring files: " + springFileLocations);
            SpringResourceLoader resourceLoader = new SpringResourceLoader(RESOURCE_LOADER_NAME, springFileLocations, event.getServletContext());
            try {
                resourceLoader.start();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to load web module spring configuration", (Throwable)e);
            }
            GlobalResourceLoader.addResourceLoader((ResourceLoader)resourceLoader);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    protected List<String> getSpringFileLocations() {
        ArrayList<String> springFileLocations = new ArrayList<String>();
        Collection<ModuleConfigurer> riceModules = ModuleConfigurer.getCurrentContextConfigurers();
        for (ModuleConfigurer module : riceModules) {
            List<String> additionalWebModuleSpringFiles;
            if (!module.shouldRenderWebInterface()) continue;
            WebModuleConfiguration webModuleConfiguration = module.getWebModuleConfiguration();
            if (webModuleConfiguration == null) {
                throw new ConfigurationException("Attempting to load WebModuleConfiguration for module '" + module.getModuleName() + "' but no configuration was provided!");
            }
            List<String> webModuleSpringFiles = webModuleConfiguration.getWebSpringFiles();
            if (CollectionUtils.isNotEmpty(webModuleSpringFiles)) {
                springFileLocations.addAll(webModuleSpringFiles);
            }
            if (!CollectionUtils.isNotEmpty(additionalWebModuleSpringFiles = webModuleConfiguration.getAdditionalWebSpringFiles())) continue;
            springFileLocations.addAll(additionalWebModuleSpringFiles);
        }
        return springFileLocations;
    }
}

