/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.core.PBPoolConfiguration;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.pooling.PoolConfiguration;

public class PBPoolInfo
extends PoolConfiguration
implements Configurable {
    private static final long serialVersionUID = 3331426619896735439L;

    public PBPoolInfo() {
        this.init();
        OjbConfigurator.getInstance().configure(this);
    }

    public PBPoolInfo(Properties properties) {
        this.init();
        OjbConfigurator.getInstance().configure(this);
        this.putAll((Map<?, ?>)properties);
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration instanceof PBPoolConfiguration) {
            PBPoolConfiguration pBPoolConfiguration = (PBPoolConfiguration)((Object)configuration);
            this.setMaxActive(pBPoolConfiguration.getMaxActive());
            this.setMaxIdle(pBPoolConfiguration.getMaxIdle());
            this.setMaxWait(pBPoolConfiguration.getMaxWaitMillis());
            this.setMinEvictableIdleTimeMillis(pBPoolConfiguration.getMinEvictableIdleTimeMillis());
            this.setTimeBetweenEvictionRunsMillis(pBPoolConfiguration.getTimeBetweenEvictionRunsMilli());
            this.setWhenExhaustedAction(pBPoolConfiguration.getWhenExhaustedAction());
        } else {
            LoggerFactory.getDefaultLogger().error(this.getClass().getName() + " cannot read configuration properties, use default.");
        }
    }

    public void init() {
        this.setTestOnBorrow(false);
        this.setTestOnReturn(false);
        this.setTestWhileIdle(false);
    }
}

