/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectComplete;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;
import org.kuali.rice.kim.api.role.RoleMembershipContract;
import org.w3c.dom.Element;

@XmlRootElement(name="roleMembership")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RoleMembershipType", propOrder={"roleId", "id", "embeddedRoleId", "memberId", "typeCode", "roleSortingCode", "qualifier", "delegates", "activeFromDate", "activeToDate", "_futureElements"})
public class RoleMembership
extends AbstractDataTransferObject
implements RoleMembershipContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="roleId", required=true)
    private final String roleId;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="embeddedRoleId", required=false)
    private final String embeddedRoleId;
    @XmlElement(name="memberId", required=true)
    private final String memberId;
    @XmlElement(name="typeCode", required=true)
    private final String typeCode;
    @XmlElement(name="roleSortingCode", required=false)
    private final String roleSortingCode;
    @XmlElement(name="qualifier", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> qualifier;
    @XmlElementWrapper(name="delegates", required=false)
    @XmlElement(name="delegate", required=false)
    private final List<DelegateType> delegates;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement(name="activeFromDate", required=false)
    private final DateTime activeFromDate;
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement(name="activeToDate", required=false)
    private final DateTime activeToDate;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RoleMembership() {
        this.roleId = null;
        this.id = null;
        this.embeddedRoleId = null;
        this.memberId = null;
        this.typeCode = null;
        this.roleSortingCode = null;
        this.qualifier = null;
        this.delegates = null;
        this.activeFromDate = null;
        this.activeToDate = null;
    }

    private RoleMembership(Builder b) {
        this.roleId = b.getRoleId();
        this.id = b.getId();
        this.embeddedRoleId = b.getEmbeddedRoleId();
        this.memberId = b.getMemberId();
        this.typeCode = b.getType().getCode();
        this.roleSortingCode = b.getRoleSortingCode();
        this.qualifier = b.getQualifier();
        this.delegates = new ArrayList<DelegateType>();
        if (!CollectionUtils.isEmpty(b.getDelegates())) {
            for (DelegateType.Builder delegateBuilder : b.getDelegates()) {
                this.delegates.add(delegateBuilder.build());
            }
        }
        this.activeFromDate = b.getActiveFromDate();
        this.activeToDate = b.getActiveToDate();
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getEmbeddedRoleId() {
        return this.embeddedRoleId;
    }

    @Override
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    public MemberType getType() {
        return MemberType.fromCode((String)this.typeCode);
    }

    @Override
    public String getRoleSortingCode() {
        return this.roleSortingCode;
    }

    @Override
    public Map<String, String> getQualifier() {
        return this.qualifier;
    }

    public List<DelegateType> getDelegates() {
        return Collections.unmodifiableList(this.delegates);
    }

    public DateTime getActiveFromDate() {
        return this.activeFromDate;
    }

    public DateTime getActiveToDate() {
        return this.activeToDate;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/RoleMembershipType";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "roleMembership";
        static final String TYPE_NAME = "RoleMembershipType";

        Constants() {
        }
    }

    static class Elements {
        static final String ROLE_ID = "roleId";
        static final String ID = "id";
        static final String EMBEDDED_ROLE_ID = "embeddedRoleId";
        static final String MEMBER_ID = "memberId";
        static final String TYPE_CODE = "typeCode";
        static final String ROLE_SORTING_CODE = "roleSortingCode";
        static final String QUALIFIER = "qualifier";
        static final String DELEGATES = "delegates";
        static final String DELEGATE = "delegate";

        Elements() {
        }
    }

    public static final class Builder
    implements ModelBuilder,
    RoleMembershipContract,
    ModelObjectComplete {
        private String roleId;
        private String id;
        private String embeddedRoleId;
        private String memberId;
        private MemberType type;
        private String roleSortingCode;
        private Map<String, String> qualifier;
        private List<DelegateType.Builder> delegates;
        private DateTime activeFromDate;
        private DateTime activeToDate;

        private Builder(String roleId, String memberId, MemberType type) {
            this.setRoleId(roleId);
            this.setMemberId(memberId);
            this.setType(type);
        }

        public static Builder create(String roleId, String id, String memberId, MemberType memberType, Map<String, String> qualifier) {
            Builder b = new Builder(roleId, memberId, memberType);
            b.setId(id);
            b.setQualifier(qualifier);
            return b;
        }

        public static Builder create(String roleId, String id, String memberId, MemberType memberType, Map<String, String> qualifier, DateTime activeFromDate, DateTime activeToDate) {
            Builder b = new Builder(roleId, memberId, memberType);
            b.setId(id);
            b.setQualifier(qualifier);
            b.setActiveFromDate(activeFromDate);
            b.setActiveToDate(activeToDate);
            return b;
        }

        public static Builder create(RoleMembershipContract contract) {
            Builder b = new Builder(contract.getRoleId(), contract.getMemberId(), contract.getType());
            b.setId(contract.getId());
            b.setEmbeddedRoleId(contract.getEmbeddedRoleId());
            b.setRoleSortingCode(contract.getRoleSortingCode());
            b.setQualifier(contract.getQualifier());
            ArrayList<DelegateType.Builder> delegateBuilders = new ArrayList<DelegateType.Builder>();
            if (!CollectionUtils.isEmpty(contract.getDelegates())) {
                for (DelegateTypeContract delegateTypeContract : contract.getDelegates()) {
                    delegateBuilders.add(DelegateType.Builder.create(delegateTypeContract));
                }
            }
            b.setDelegates(delegateBuilders);
            return b;
        }

        public RoleMembership build() {
            return new RoleMembership(this);
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        public Map<String, String> getQualifier() {
            return this.qualifier;
        }

        public void setQualifier(Map<String, String> qualifier) {
            this.qualifier = qualifier;
        }

        public List<DelegateType.Builder> getDelegates() {
            return this.delegates;
        }

        public void setDelegates(List<DelegateType.Builder> delegates) {
            this.delegates = delegates;
        }

        public DateTime getActiveFromDate() {
            return this.activeFromDate;
        }

        public void setActiveFromDate(DateTime activeFromDate) {
            this.activeFromDate = activeFromDate;
        }

        public DateTime getActiveToDate() {
            return this.activeToDate;
        }

        public void setActiveToDate(DateTime activeToDate) {
            this.activeToDate = activeToDate;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getMemberId() {
            return this.memberId;
        }

        public void setMemberId(String memberId) {
            if (StringUtils.isEmpty((String)memberId)) {
                throw new IllegalArgumentException("memberId cannot be empty or null");
            }
            this.memberId = memberId;
        }

        @Override
        public MemberType getType() {
            return this.type;
        }

        public void setType(MemberType type) {
            if (type == null) {
                throw new IllegalArgumentException("type cannot be null");
            }
            this.type = type;
        }

        @Override
        public String getEmbeddedRoleId() {
            return this.embeddedRoleId;
        }

        public void setEmbeddedRoleId(String embeddedRoleId) {
            this.embeddedRoleId = embeddedRoleId;
        }

        @Override
        public String getRoleSortingCode() {
            return this.roleSortingCode;
        }

        public void setRoleSortingCode(String roleSortingCode) {
            this.roleSortingCode = roleSortingCode;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

