/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.JoinSyntaxTypes;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.query.LikeCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformDefaultImpl
implements Platform,
JoinSyntaxTypes {
    protected Logger log = LoggerFactory.getLogger(PlatformDefaultImpl.class);
    private static final String INITIALIZATION_CHECK_AUTOCOMMIT = "initializationCheck";
    private static final String FALSE_STR = "false";
    protected boolean m_batchUpdatesChecked = false;
    protected boolean m_supportsBatchUpdates = false;

    @Override
    public boolean supportsBatchOperations() {
        return this.m_supportsBatchUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForBatchSupport(Connection connection) {
        if (!this.m_batchUpdatesChecked) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                this.m_supportsBatchUpdates = databaseMetaData.supportsBatchUpdates();
            }
            catch (Throwable throwable) {
                this.log.info("Batch support check failed", throwable);
                this.m_supportsBatchUpdates = false;
            }
            finally {
                this.m_batchUpdatesChecked = true;
            }
        }
    }

    @Override
    public void afterStatementCreate(Statement statement) throws PlatformException {
    }

    @Override
    public void beforeStatementClose(Statement statement, ResultSet resultSet) throws PlatformException {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                throw new PlatformException("Resultset closing failed", sQLException);
            }
        }
    }

    @Override
    public void afterStatementClose(Statement statement, ResultSet resultSet) throws PlatformException {
    }

    @Override
    public void beforeBatch(PreparedStatement preparedStatement) throws PlatformException {
    }

    @Override
    public void addBatch(PreparedStatement preparedStatement) throws PlatformException {
        try {
            preparedStatement.addBatch();
        }
        catch (SQLException sQLException) {
            throw new PlatformException("Failure while calling 'addBatch' on given Statement object", sQLException);
        }
    }

    @Override
    public int[] executeBatch(PreparedStatement preparedStatement) throws PlatformException {
        try {
            return preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            throw new PlatformException("Failure while calling 'executeBatch' on given Statement object", sQLException);
        }
    }

    @Override
    public void initializeJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws PlatformException {
        if (jdbcConnectionDescriptor.getBatchMode()) {
            this.checkForBatchSupport(connection);
        }
        switch (jdbcConnectionDescriptor.getUseAutoCommit()) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    if (jdbcConnectionDescriptor.getAttribute(INITIALIZATION_CHECK_AUTOCOMMIT, FALSE_STR).equalsIgnoreCase(FALSE_STR) || connection.getAutoCommit()) break;
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    if (!jdbcConnectionDescriptor.isIgnoreAutoCommitExceptions()) {
                        throw new PlatformException("Connection initializing: setAutoCommit(true) failed", sQLException);
                    }
                    this.log.info("Connection initializing: setAutoCommit jdbc-driver problems. " + sQLException.getMessage());
                }
                break;
            }
            case 2: {
                try {
                    if (!connection.getAutoCommit()) break;
                    connection.setAutoCommit(false);
                    break;
                }
                catch (SQLException sQLException) {
                    if (!jdbcConnectionDescriptor.isIgnoreAutoCommitExceptions()) {
                        throw new PlatformException("Connection initializing: setAutoCommit(false) failed", sQLException);
                    }
                    this.log.info("Connection initializing: setAutoCommit jdbc-driver problems. " + sQLException.getMessage());
                }
            }
        }
    }

    @Override
    public void changeAutoCommitState(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection, boolean bl) {
        if (connection == null) {
            this.log.error("Given m_connection was null, cannot prepare autoCommit state");
            return;
        }
        if (1 == jdbcConnectionDescriptor.getUseAutoCommit()) {
            try {
                connection.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                if (jdbcConnectionDescriptor.isIgnoreAutoCommitExceptions()) {
                    this.log.info("Set autoCommit(" + bl + ") failed: " + sQLException.getMessage());
                }
                this.log.error("Set autoCommit(" + bl + ") failed", sQLException);
                throw new PersistenceBrokerException("Set autoCommit(false) failed", sQLException);
            }
        }
    }

    @Override
    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        if (n2 == -1 && object instanceof String) {
            String string = (String)object;
            preparedStatement.setCharacterStream(n, (Reader)new StringReader(string), string.length());
        } else if (n2 == 3 || n2 == 2) {
            preparedStatement.setObject(n, object);
        } else {
            preparedStatement.setObject(n, object, n2);
        }
    }

    @Override
    public void setNullForStatement(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        preparedStatement.setNull(n, n2);
    }

    @Override
    public byte getJoinSyntaxType() {
        return 0;
    }

    @Override
    public boolean useCountForResultsetSize() {
        return false;
    }

    @Override
    public String createSequenceQuery(String string, Properties properties) {
        return this.createSequenceQuery(string);
    }

    @Override
    public String createSequenceQuery(String string) {
        throw new UnsupportedOperationException("This feature is not supported by this implementation");
    }

    @Override
    public String nextSequenceQuery(String string) {
        throw new UnsupportedOperationException("This feature is not supported by this implementation");
    }

    @Override
    public String dropSequenceQuery(String string) {
        throw new UnsupportedOperationException("This feature is not supported by this implementation");
    }

    @Override
    public CallableStatement prepareNextValProcedureStatement(Connection connection, String string, String string2) throws PlatformException {
        throw new UnsupportedOperationException("Not supported by this implementation");
    }

    @Override
    public String getLastInsertIdentityQuery(String string) {
        throw new UnsupportedOperationException("This feature is not supported by this implementation");
    }

    @Override
    public void addPagingSql(StringBuffer stringBuffer) {
    }

    @Override
    public boolean bindPagingParametersFirst() {
        return false;
    }

    @Override
    public boolean supportsPaging() {
        return false;
    }

    @Override
    public int bindPagingParameters(PreparedStatement preparedStatement, int n, int n2, int n3) throws SQLException {
        preparedStatement.setInt(n, n2 - 1);
        preparedStatement.setInt(++n, n3 - (n2 - 1));
        return ++n;
    }

    protected String getConcatenationCharacter() {
        return "||";
    }

    @Override
    public boolean supportsMultiColumnCountDistinct() {
        return true;
    }

    @Override
    public String concatenate(String[] stringArray) {
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getConcatenationCharacter();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ").append(string).append(" ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getEscapeClause(LikeCriteria likeCriteria) {
        char c;
        String string = (String)likeCriteria.getValue();
        if (string.indexOf(c = LikeCriteria.getEscapeCharacter()) >= 0) {
            return " ESCAPE '" + c + "'";
        }
        return "";
    }

    @Override
    public void registerOutResultSet(CallableStatement callableStatement, int n) throws SQLException {
        callableStatement.registerOutParameter(n, 1111);
    }
}

