/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.Image;
import org.apache.ojb.odmg.ObjectEnvelopeTable;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionAware;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.link.LinkEntry;
import org.apache.ojb.odmg.link.LinkEntryOneToN;
import org.apache.ojb.odmg.link.LinkEntryOneToOne;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDirty;
import org.apache.ojb.odmg.states.StateOldClean;
import org.apache.ojb.odmg.states.StateOldDirty;

public class ObjectEnvelope
implements ObjectModification,
Image.ImageListener {
    private Logger log = LoggerFactory.getLogger(ObjectEnvelope.class);
    static final long serialVersionUID = -829177767933340522L;
    static final int IS_MATERIALIZED_OBJECT = 11;
    static final int IS_MATERIALIZED_PROXY = 13;
    static final int IS_UNMATERIALIZED_PROXY = 17;
    private ModificationState modificationState = null;
    private Identity oid;
    private Boolean hasChanged;
    private boolean writeLocked;
    private Object myObj;
    private Map beforeImage;
    private Map currentImage;
    private ObjectEnvelopeTable buffer;
    private List linkEntryList = new ArrayList();

    public ObjectEnvelope(ObjectEnvelopeTable objectEnvelopeTable, Identity identity, Object object, boolean bl) {
        this.buffer = objectEnvelopeTable;
        this.oid = identity;
        this.myObj = ProxyHelper.getRealObject(object);
        this.prepareInitialState(bl);
        this.beforeImage = this.buildObjectImage(this.getBroker());
    }

    @Override
    public PersistenceBrokerInternal getBroker() {
        return this.buffer.getTransaction().getBrokerInternal();
    }

    TransactionImpl getTx() {
        return this.buffer.getTransaction();
    }

    ObjectEnvelopeTable getEnvelopeTable() {
        return this.buffer;
    }

    public Map getBeforeImage() {
        if (this.beforeImage == null) {
            this.beforeImage = this.buildObjectImage(this.getBroker());
        }
        return this.beforeImage;
    }

    public Map getCurrentImage() {
        if (this.currentImage == null) {
            this.currentImage = this.buildObjectImage(this.getBroker());
        }
        return this.currentImage;
    }

    public void cleanup(boolean bl, boolean bl2) {
        if (this.currentImage != null) {
            this.performImageCleanup(this.currentImage, bl);
        }
        if (this.beforeImage != null) {
            this.performImageCleanup(this.beforeImage, false);
        }
        if (bl) {
            this.refreshObjectImage(bl2);
        } else {
            this.myObj = null;
        }
    }

    private void performImageCleanup(Map map, boolean bl) {
        for (Image image : map.values()) {
            if (image == null) continue;
            image.cleanup(bl);
        }
    }

    private void refreshObjectImage(boolean bl) {
        try {
            if (this.getIdentity().isTransient()) {
                this.refreshIdentity();
            }
            if (this.currentImage != null) {
                this.beforeImage = this.currentImage;
            } else if (this.beforeImage == null) {
                this.beforeImage = this.buildObjectImage(this.getBroker());
            }
            this.currentImage = null;
            this.hasChanged = null;
            if (bl) {
                this.refreshPKFields();
            }
            this.refreshLockingFields();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.beforeImage = null;
            this.currentImage = null;
            this.hasChanged = null;
            this.log.error("Can't refresh object image for " + this.getIdentity(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
    }

    private void refreshPKFields() {
        FieldDescriptor[] fieldDescriptorArray = this.getClassDescriptor().getPkFields();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            this.addFieldImage(this.beforeImage, fieldDescriptor);
        }
    }

    private void refreshLockingFields() {
        if (this.getClassDescriptor().isLocking()) {
            FieldDescriptor[] fieldDescriptorArray = this.getClassDescriptor().getLockingFields();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                this.addFieldImage(this.beforeImage, fieldDescriptor);
            }
        }
    }

    public Identity refreshIdentity() {
        Identity identity = this.getIdentity();
        this.oid = this.getBroker().serviceIdentity().buildIdentity(this.myObj);
        return identity;
    }

    public Identity getIdentity() {
        if (this.oid == null) {
            this.oid = this.getBroker().serviceIdentity().buildIdentity(this.getObject());
        }
        return this.oid;
    }

    public Object getObject() {
        return this.myObj;
    }

    public Object getRealObject() {
        return ProxyHelper.getRealObject(this.getObject());
    }

    public void refreshObjectIfNeeded(Object object) {
        if (this.myObj != object) {
            this.myObj = object;
        }
    }

    public void beforeCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.beforeCommit();
        }
    }

    public void afterCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.afterCommit();
        }
    }

    public void beforeAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.beforeAbort();
        }
    }

    public void afterAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.afterAbort();
        }
    }

    private Map buildObjectImage(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        HashMap hashMap = new HashMap();
        ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(this.getObject().getClass());
        this.buildImageForSingleReferences(hashMap, classDescriptor);
        this.buildImageForFields(hashMap, classDescriptor);
        this.buildImageForCollectionReferences(hashMap, classDescriptor);
        return hashMap;
    }

    private void buildImageForSingleReferences(Map map, ClassDescriptor classDescriptor) {
        for (ObjectReferenceDescriptor objectReferenceDescriptor : classDescriptor.getObjectReferenceDescriptors(true)) {
            if (objectReferenceDescriptor.isSuperReferenceDescriptor()) continue;
            Object object = objectReferenceDescriptor.getPersistentField().get(this.myObj);
            IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
            if (indirectionHandler == null && object != null && BrokerHelper.hasAnonymousKeyReference(objectReferenceDescriptor.getClassDescriptor(), objectReferenceDescriptor)) {
                this.getBroker().serviceBrokerHelper().link(this.myObj, objectReferenceDescriptor, false);
            }
            Image.SingleRef singleRef = new Image.SingleRef(this, objectReferenceDescriptor, object);
            map.put(objectReferenceDescriptor, singleRef);
        }
    }

    private void buildImageForFields(Map map, ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptor(true);
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            this.addFieldImage(map, fieldDescriptorArray[i]);
        }
    }

    private void addFieldImage(Map map, FieldDescriptor fieldDescriptor) {
        Object object = fieldDescriptor.getPersistentField().get(this.myObj);
        object = fieldDescriptor.getFieldConversion().javaToSql(object);
        object = fieldDescriptor.getJdbcType().getFieldType().copy(object);
        map.put(fieldDescriptor.getPersistentField().getName(), new Image.Field(fieldDescriptor.getJdbcType().getFieldType(), object));
    }

    private void buildImageForCollectionReferences(Map map, ClassDescriptor classDescriptor) {
        for (CollectionDescriptor collectionDescriptor : classDescriptor.getCollectionDescriptors(true)) {
            Object object = collectionDescriptor.getPersistentField().get(this.myObj);
            Image.MultipleRef multipleRef = new Image.MultipleRef(this, collectionDescriptor, object);
            map.put(collectionDescriptor, multipleRef);
        }
    }

    public ModificationState getModificationState() {
        return this.modificationState;
    }

    @Override
    public boolean needsInsert() {
        return this.getModificationState().needsInsert();
    }

    @Override
    public boolean needsUpdate() {
        return this.getModificationState().needsUpdate();
    }

    public boolean needsDelete() {
        return this.getModificationState().needsDelete();
    }

    private void prepareInitialState(boolean bl) {
        ModificationState modificationState = bl ? StateNewDirty.getInstance() : (this.isDeleted(this.oid) ? StateOldDirty.getInstance() : StateOldClean.getInstance());
        this.modificationState = modificationState;
    }

    public boolean isDeleted(Identity identity) {
        ObjectEnvelope objectEnvelope = this.buffer.getByIdentity(identity);
        return objectEnvelope != null && objectEnvelope.needsDelete();
    }

    public void setModificationState(ModificationState modificationState) {
        if (modificationState != this.modificationState) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("object state transition for object " + this.oid + " (" + this.modificationState + " --> " + modificationState + ")");
            }
            this.modificationState = modificationState;
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("Identity", (Object)this.oid).append("ModificationState", (Object)this.modificationState.toString());
        return toStringBuilder.toString();
    }

    public boolean hasChanged(PersistenceBroker persistenceBroker) {
        if (this.hasChanged == null) {
            Map map = null;
            try {
                map = this.getCurrentImage();
            }
            catch (Exception exception) {
                this.log.warn("Could not verify object changes, mark dirty: " + this.getIdentity(), exception);
            }
            if (this.beforeImage != null && map != null) {
                Iterator iterator = this.beforeImage.entrySet().iterator();
                this.hasChanged = Boolean.FALSE;
                while (iterator.hasNext()) {
                    Image image;
                    Map.Entry entry = iterator.next();
                    Image image2 = (Image)entry.getValue();
                    if (!image2.modified(image = (Image)map.get(entry.getKey()))) continue;
                    this.hasChanged = Boolean.TRUE;
                    break;
                }
            } else {
                this.hasChanged = Boolean.TRUE;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("State detection for " + this.getIdentity() + " --> object " + (this.hasChanged != false ? "has changed" : "unchanged"));
            }
        }
        return this.hasChanged;
    }

    void markReferenceElements(PersistenceBroker persistenceBroker) {
        Map map = this.getBeforeImage();
        Map map2 = this.getCurrentImage();
        for (Map.Entry entry : map2.entrySet()) {
            Object k = entry.getKey();
            if (!(k instanceof ObjectReferenceDescriptor)) continue;
            Image image = (Image)map.get(k);
            Image image2 = (Image)entry.getValue();
            image2.performReferenceDetection(image);
        }
    }

    public void doUpdate() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start UPDATE action for " + this.getIdentity());
        }
        this.performLinkEntries();
        this.getBroker().store(this.getObject(), this.getIdentity(), this.getClassDescriptor(), false, true);
    }

    public void doInsert() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start INSERT action for " + this.getIdentity());
        }
        this.performLinkEntries();
        this.getBroker().store(this.getObject(), this.getIdentity(), this.getClassDescriptor(), true, true);
        Identity identity = this.refreshIdentity();
        this.buffer.replaceRegisteredIdentity(this.getIdentity(), identity);
    }

    public void doDelete() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start DELETE action for " + this.getIdentity());
        }
        this.getBroker().delete(this.getObject(), true);
    }

    public void doEvictFromCache() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove from cache " + this.getIdentity());
        }
        this.getBroker().removeFromCache(this.getIdentity());
    }

    public boolean isWriteLocked() {
        return this.writeLocked;
    }

    public void setWriteLocked(boolean bl) {
        this.writeLocked = bl;
    }

    ClassDescriptor getClassDescriptor() {
        return this.getBroker().getClassDescriptor(ProxyHelper.getRealClass(this.getObject()));
    }

    void addLinkOneToOne(ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl) {
        LinkEntryOneToOne linkEntryOneToOne = new LinkEntryOneToOne(objectReferenceDescriptor, this.getObject(), bl);
        this.linkEntryList.add(linkEntryOneToOne);
    }

    void addLinkOneToN(CollectionDescriptor collectionDescriptor, Object object, boolean bl) {
        if (collectionDescriptor.isMtoNRelation()) {
            throw new OJBRuntimeException("Expected an 1:n relation, but specified a m:n");
        }
        LinkEntryOneToN linkEntryOneToN = new LinkEntryOneToN(object, collectionDescriptor, this.getObject(), bl);
        this.linkEntryList.add(linkEntryOneToN);
    }

    private void performLinkEntries() {
        PersistenceBrokerInternal persistenceBrokerInternal = this.getBroker();
        for (int i = 0; i < this.linkEntryList.size(); ++i) {
            LinkEntry linkEntry = (LinkEntry)this.linkEntryList.get(i);
            linkEntry.execute(persistenceBrokerInternal);
        }
    }

    @Override
    public void addedOneToOne(ObjectReferenceDescriptor objectReferenceDescriptor, Object object, Identity identity) {
        this.setModificationState(this.getModificationState().markDirty());
        ObjectEnvelope objectEnvelope = this.buffer.getByIdentity(identity);
        if (objectEnvelope == null) {
            RuntimeObject runtimeObject = new RuntimeObject(object, this.getTx());
            this.getTx().lockAndRegister(runtimeObject, 1, false, this.getTx().getRegistrationList());
        }
        this.addLinkOneToOne(objectReferenceDescriptor, false);
    }

    @Override
    public void deletedOneToOne(ObjectReferenceDescriptor objectReferenceDescriptor, Object object, Identity identity, boolean bl) {
        this.setModificationState(this.getModificationState().markDirty());
        ObjectEnvelope objectEnvelope = this.buffer.getByIdentity(identity);
        if (!this.buffer.isNewAssociatedObject(identity)) {
            if (this.buffer.getTransaction().cascadeDeleteFor(objectReferenceDescriptor)) {
                objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDelete());
            }
            if (bl) {
                this.addLinkOneToOne(objectReferenceDescriptor, true);
            }
        }
    }

    @Override
    public void addedXToN(CollectionDescriptor collectionDescriptor, Object object, Identity identity) {
        ObjectEnvelope objectEnvelope = this.buffer.getByIdentity(identity);
        if (objectEnvelope == null) {
            boolean bl = this.getTx().isTransient(null, object, identity);
            objectEnvelope = this.buffer.get(identity, object, bl);
        }
        if (objectEnvelope.needsDelete()) {
            objectEnvelope.setModificationState(objectEnvelope.getModificationState().markNew());
        } else if (!collectionDescriptor.isMtoNRelation() || !objectEnvelope.getModificationState().equals(StateOldClean.getInstance())) {
            objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
        }
        this.buffer.addNewAssociatedIdentity(identity);
        if (collectionDescriptor.isMtoNRelation()) {
            this.buffer.addM2NLinkEntry(collectionDescriptor, this.getObject(), object);
        } else {
            objectEnvelope.addLinkOneToN(collectionDescriptor, this.getObject(), false);
        }
        if (objectEnvelope.needsInsert()) {
            this.buffer.addForInsertDependent(objectEnvelope);
        }
    }

    @Override
    public void deletedXToN(CollectionDescriptor collectionDescriptor, Object object, Identity identity) {
        ObjectEnvelope objectEnvelope = this.buffer.getByIdentity(identity);
        if (!this.buffer.isNewAssociatedObject(identity)) {
            if (objectEnvelope != null) {
                boolean bl = this.buffer.getTransaction().cascadeDeleteFor(collectionDescriptor);
                if (bl) {
                    objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDelete());
                    this.buffer.addForDeletionDependent(objectEnvelope);
                }
                if (collectionDescriptor.isMtoNRelation()) {
                    this.buffer.addM2NUnlinkEntry(collectionDescriptor, this.getObject(), object);
                } else if (!bl) {
                    objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
                    objectEnvelope.addLinkOneToN(collectionDescriptor, this.getObject(), true);
                }
            } else {
                throw new Image.ImageException("Unexpected behaviour, unregistered object to delete: " + identity + ", main object is " + this.getIdentity() + ", envelope object is " + this.toString());
            }
        }
    }
}

