/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;

public class ReadCommittedStrategy
extends AbstractLockStrategy {
    @Override
    public boolean readLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry == null) {
            this.addReader(transactionImpl, object);
            if (this.getWriter(object) == null) {
                return true;
            }
            this.removeReader(transactionImpl, object);
            return this.readLock(transactionImpl, object);
        }
        return lockEntry.isOwnedBy(transactionImpl);
    }

    @Override
    public boolean writeLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry == null) {
            if (this.setWriter(transactionImpl, object)) {
                return true;
            }
            return this.writeLock(transactionImpl, object);
        }
        return lockEntry.isOwnedBy(transactionImpl);
    }

    @Override
    public boolean upgradeLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry == null) {
            if (this.setWriter(transactionImpl, object)) {
                return true;
            }
            return this.upgradeLock(transactionImpl, object);
        }
        return lockEntry.isOwnedBy(transactionImpl);
    }

    @Override
    public boolean releaseLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry != null && lockEntry.isOwnedBy(transactionImpl)) {
            this.removeWriter(lockEntry);
            return true;
        }
        if (this.hasReadLock(transactionImpl, object)) {
            this.removeReader(transactionImpl, object);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkRead(TransactionImpl transactionImpl, Object object) {
        if (this.hasReadLock(transactionImpl, object)) {
            return true;
        }
        LockEntry lockEntry = this.getWriter(object);
        return lockEntry.isOwnedBy(transactionImpl);
    }

    @Override
    public boolean checkWrite(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry == null) {
            return false;
        }
        return lockEntry.isOwnedBy(transactionImpl);
    }
}

