/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.uif.lifecycle.ComponentPostMetadata;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.service.AttributeQueryService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.widget.LocationSuggest;
import org.kuali.rice.krad.uif.widget.Suggest;
import org.kuali.rice.krad.util.BeanPropertyComparator;

public class AttributeQueryServiceImpl
implements AttributeQueryService {
    private LookupService lookupService;
    private ConfigurationService configurationService;

    @Override
    public AttributeQueryResult performFieldSuggestQuery(ViewPostMetadata viewPostMetadata, String fieldId, String fieldTerm, Map<String, String> queryParameters) {
        AttributeQueryResult queryResult = new AttributeQueryResult();
        ComponentPostMetadata inputFieldMetaData = viewPostMetadata.getComponentPostMetadata(fieldId);
        if (inputFieldMetaData == null) {
            throw new RuntimeException("Unable to find attribute field instance for id: " + fieldId);
        }
        Suggest.SuggestPostData suggestPostData = (Suggest.SuggestPostData)inputFieldMetaData.getData("suggest");
        AttributeQuery suggestQuery = suggestPostData.getSuggestQuery();
        boolean isUppercaseValue = Boolean.TRUE.equals(inputFieldMetaData.getData("isUppercase"));
        HashMap<String, String> additionalCriteria = new HashMap<String, String>();
        if (isUppercaseValue) {
            additionalCriteria.put(suggestPostData.getValuePropertyName(), fieldTerm.toUpperCase() + "*");
        } else {
            additionalCriteria.put(suggestPostData.getValuePropertyName(), fieldTerm + "*");
        }
        Collection results = null;
        if (suggestQuery.hasConfiguredMethod()) {
            Object queryMethodResult = this.executeAttributeQueryMethod(suggestQuery, queryParameters, true, fieldTerm);
            if (queryMethodResult != null && queryMethodResult instanceof Collection) {
                results = (Collection)queryMethodResult;
            }
        } else {
            results = this.executeAttributeQueryCriteria(suggestQuery, queryParameters, additionalCriteria, new ArrayList<String>());
        }
        if (results != null) {
            if (suggestPostData.isReturnFullQueryObject()) {
                queryResult.setResultData((List)results);
            } else {
                this.retrievePropertiesOnResults(queryResult, results, suggestPostData);
            }
        }
        return queryResult;
    }

    protected void retrievePropertiesOnResults(AttributeQueryResult queryResult, Collection<?> results, Suggest.SuggestPostData suggestPostData) {
        ArrayList<Object> suggestData = new ArrayList<Object>();
        for (Object result : results) {
            if (result == null) continue;
            HashMap<String, String> propMap = new HashMap<String, String>();
            if (result instanceof String) {
                propMap.put("value", (String)result);
                propMap.put("label", (String)result);
            }
            String suggestFieldValue = null;
            if (StringUtils.isNotBlank((String)suggestPostData.getValuePropertyName())) {
                suggestFieldValue = ObjectPropertyUtils.getPropertyValueAsText(result, suggestPostData.getValuePropertyName());
            } else if (ObjectPropertyUtils.isReadableProperty(result, "value")) {
                suggestFieldValue = ObjectPropertyUtils.getPropertyValueAsText(result, "value");
            }
            if (suggestFieldValue != null) {
                propMap.put("value", suggestFieldValue);
            }
            String suggestFieldLabel = null;
            if (StringUtils.isNotBlank((String)suggestPostData.getLabelPropertyName())) {
                suggestFieldLabel = ObjectPropertyUtils.getPropertyValueAsText(result, suggestPostData.getLabelPropertyName());
            } else if (ObjectPropertyUtils.isReadableProperty(result, "label")) {
                suggestFieldLabel = ObjectPropertyUtils.getPropertyValueAsText(result, "label");
            }
            if (suggestFieldLabel != null) {
                propMap.put("label", suggestFieldLabel);
            }
            if (suggestPostData instanceof LocationSuggest.LocationSuggestPostData) {
                this.handleLocationSuggestProperties((LocationSuggest.LocationSuggestPostData)suggestPostData, result, propMap);
            }
            this.handleAdditionalSuggestProperties(suggestPostData, result, propMap);
            if (propMap.isEmpty()) continue;
            suggestData.add(propMap);
        }
        queryResult.setResultData(suggestData);
    }

    private void handleAdditionalSuggestProperties(Suggest.SuggestPostData suggestPostData, Object result, Map<String, String> propMap) {
        if (suggestPostData.getAdditionalPropertiesToReturn() != null) {
            for (String propName : suggestPostData.getAdditionalPropertiesToReturn()) {
                String propValue = null;
                if (StringUtils.isNotBlank((String)propName) && ObjectPropertyUtils.isReadableProperty(result, propName)) {
                    propValue = ObjectPropertyUtils.getPropertyValueAsText(result, propName);
                }
                if (propValue == null) continue;
                propMap.put(propName, propValue);
            }
        }
    }

    private void handleLocationSuggestProperties(LocationSuggest.LocationSuggestPostData suggestPostData, Object result, Map<String, String> propMap) {
        String suggestHrefValue = null;
        if (StringUtils.isNotBlank((String)suggestPostData.getHrefPropertyName()) && ObjectPropertyUtils.isReadableProperty(result, suggestPostData.getHrefPropertyName())) {
            suggestHrefValue = ObjectPropertyUtils.getPropertyValueAsText(result, suggestPostData.getHrefPropertyName());
        }
        if (suggestHrefValue != null) {
            propMap.put(suggestPostData.getHrefPropertyName(), suggestHrefValue);
        }
        String addUrlValue = null;
        if (StringUtils.isNotBlank((String)suggestPostData.getAdditionalUrlPathPropertyName()) && ObjectPropertyUtils.isReadableProperty(result, suggestPostData.getAdditionalUrlPathPropertyName())) {
            addUrlValue = ObjectPropertyUtils.getPropertyValueAsText(result, suggestPostData.getAdditionalUrlPathPropertyName());
        }
        if (addUrlValue != null) {
            propMap.put(suggestPostData.getAdditionalUrlPathPropertyName(), addUrlValue);
        }
        if (suggestPostData.getRequestParameterPropertyNames() == null) {
            return;
        }
        for (String key : suggestPostData.getRequestParameterPropertyNames().keySet()) {
            String prop = suggestPostData.getRequestParameterPropertyNames().get(key);
            String propValue = null;
            if (StringUtils.isNotBlank((String)prop) && ObjectPropertyUtils.isReadableProperty(result, prop)) {
                propValue = ObjectPropertyUtils.getPropertyValueAsText(result, prop);
            }
            if (propValue == null) continue;
            propMap.put(prop, propValue);
        }
    }

    @Override
    public AttributeQueryResult performFieldQuery(ViewPostMetadata viewPostMetadata, String fieldId, Map<String, String> queryParameters) {
        AttributeQueryResult queryResult = new AttributeQueryResult();
        ComponentPostMetadata inputFieldMetaData = viewPostMetadata.getComponentPostMetadata(fieldId);
        if (inputFieldMetaData == null) {
            throw new RuntimeException("Unable to find attribute field instance for id: " + fieldId);
        }
        AttributeQuery fieldQuery = (AttributeQuery)inputFieldMetaData.getData("attributeQuery");
        if (fieldQuery == null) {
            throw new RuntimeException("Field query not defined for field instance with id: " + fieldId);
        }
        Object resultObject = null;
        if (fieldQuery.hasConfiguredMethod()) {
            Object queryMethodResult = this.executeAttributeQueryMethod(fieldQuery, queryParameters, false, null);
            if (queryMethodResult != null) {
                if (queryMethodResult instanceof AttributeQueryResult) {
                    return (AttributeQueryResult)queryMethodResult;
                }
                if (queryMethodResult instanceof Collection) {
                    Collection methodResultCollection = (Collection)queryMethodResult;
                    if (!methodResultCollection.isEmpty()) {
                        resultObject = methodResultCollection.iterator().next();
                    }
                } else {
                    resultObject = queryMethodResult;
                }
            }
        } else {
            Collection<?> results = this.executeAttributeQueryCriteria(fieldQuery, queryParameters, null, new ArrayList<String>(queryParameters.keySet()));
            if (results != null && !results.isEmpty()) {
                resultObject = results.size() > 1 ? null : results.iterator().next();
            }
        }
        if (resultObject != null) {
            HashMap<String, String> resultFieldData = new HashMap<String, String>();
            for (String fromField : fieldQuery.getReturnFieldMapping().keySet()) {
                String returnField = fieldQuery.getReturnFieldMapping().get(fromField);
                String fieldValueStr = "";
                fieldValueStr = ObjectPropertyUtils.getPropertyValueAsText(resultObject, fromField);
                resultFieldData.put(returnField, fieldValueStr);
            }
            queryResult.setResultFieldData(resultFieldData);
            fieldQuery.setReturnMessageText("");
        } else if (fieldQuery.isRenderNotFoundMessage()) {
            String messageTemplate = this.getConfigurationService().getPropertyValueAsString("query.dataNotFound");
            String message = MessageFormat.format(messageTemplate, inputFieldMetaData.getData("label"));
            fieldQuery.setReturnMessageText(message.toLowerCase());
        }
        queryResult.setResultMessage(fieldQuery.getReturnMessageText());
        queryResult.setResultMessageStyleClasses(fieldQuery.getReturnMessageStyleClasses());
        return queryResult;
    }

    protected Object executeAttributeQueryMethod(AttributeQuery attributeQuery, Map<String, String> queryParameters, boolean isSuggestQuery, String queryTerm) {
        String queryMethodToCall = attributeQuery.getQueryMethodToCall();
        MethodInvokerConfig queryMethodInvoker = attributeQuery.getQueryMethodInvokerConfig();
        if (queryMethodInvoker == null) {
            queryMethodInvoker = new MethodInvokerConfig();
        }
        if (StringUtils.isBlank((String)queryMethodInvoker.getTargetMethod())) {
            queryMethodInvoker.setTargetMethod(queryMethodToCall);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (attributeQuery.getQueryMethodArgumentFieldList() != null && !attributeQuery.getQueryMethodArgumentFieldList().isEmpty()) {
            int numQueryMethodArguments = attributeQuery.getQueryMethodArgumentFieldList().size();
            if (isSuggestQuery) {
                ++numQueryMethodArguments;
            }
            queryMethodInvoker.setArguments(new Object[numQueryMethodArguments]);
            Class[] argumentTypes = queryMethodInvoker.getArgumentTypes();
            if (argumentTypes == null || argumentTypes.length != numQueryMethodArguments) {
                throw new RuntimeException("Query method argument field list size does not match found number of method arguments");
            }
            for (int i = 0; i < attributeQuery.getQueryMethodArgumentFieldList().size(); ++i) {
                String methodArgumentFromField = attributeQuery.getQueryMethodArgumentFieldList().get(i);
                if (queryParameters.containsKey(methodArgumentFromField)) {
                    arguments.add(queryParameters.get(methodArgumentFromField));
                    continue;
                }
                arguments.add(null);
            }
        }
        if (isSuggestQuery) {
            arguments.add(queryTerm);
        }
        queryMethodInvoker.setArguments(arguments.toArray());
        try {
            queryMethodInvoker.prepare();
            return queryMethodInvoker.invoke();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke query method: " + queryMethodInvoker.getTargetMethod(), e);
        }
    }

    protected Collection<?> executeAttributeQueryCriteria(AttributeQuery attributeQuery, Map<String, String> queryParameters, Map<String, String> additionalCriteria, List<String> wildcardAsLiteralPropertyNames) {
        Class<?> queryClass;
        boolean allQueryFieldsPresent = true;
        HashMap<String, String> queryCriteria = new HashMap<String, String>();
        for (String fieldName : attributeQuery.getQueryFieldMapping().values()) {
            if (queryParameters.containsKey(fieldName) && StringUtils.isNotBlank((String)queryParameters.get(fieldName))) {
                queryCriteria.put(fieldName, queryParameters.get(fieldName));
                continue;
            }
            allQueryFieldsPresent = false;
            break;
        }
        if (!allQueryFieldsPresent) {
            attributeQuery.setRenderNotFoundMessage(false);
            return null;
        }
        for (String fieldName : attributeQuery.getAdditionalCriteria().keySet()) {
            queryCriteria.put(fieldName, attributeQuery.getAdditionalCriteria().get(fieldName));
        }
        if (additionalCriteria != null) {
            queryCriteria.putAll(additionalCriteria);
        }
        try {
            queryClass = Class.forName(attributeQuery.getDataObjectClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid data object class given for suggest query: " + attributeQuery.getDataObjectClassName(), e);
        }
        Collection<?> results = this.getLookupService().findCollectionBySearchHelper(queryClass, queryCriteria, wildcardAsLiteralPropertyNames, true, null);
        if (!attributeQuery.getSortPropertyNames().isEmpty() && results != null && results.size() > 1) {
            Collections.sort((List)results, new BeanPropertyComparator(attributeQuery.getSortPropertyNames()));
        }
        return results;
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

