/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.policy;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.retry.RetryContext;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.util.Assert;

public class ExpressionRetryPolicy
extends SimpleRetryPolicy
implements BeanFactoryAware {
    private static final TemplateParserContext PARSER_CONTEXT = new TemplateParserContext();
    private final Expression expression;
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();

    public ExpressionRetryPolicy(Expression expression) {
        Assert.notNull((Object)expression, (String)"'expression' cannot be null");
        this.expression = expression;
    }

    public ExpressionRetryPolicy(String expressionString) {
        Assert.notNull((Object)expressionString, (String)"'expressionString' cannot be null");
        this.expression = new SpelExpressionParser().parseExpression(expressionString, (ParserContext)PARSER_CONTEXT);
    }

    public ExpressionRetryPolicy(int maxAttempts, Map<Class<? extends Throwable>, Boolean> retryableExceptions, boolean traverseCauses, Expression expression) {
        super(maxAttempts, retryableExceptions, traverseCauses);
        Assert.notNull((Object)expression, (String)"'expression' cannot be null");
        this.expression = expression;
    }

    public ExpressionRetryPolicy(int maxAttempts, Map<Class<? extends Throwable>, Boolean> retryableExceptions, boolean traverseCauses, String expressionString, boolean defaultValue) {
        super(maxAttempts, retryableExceptions, traverseCauses, defaultValue);
        Assert.notNull((Object)expressionString, (String)"'expressionString' cannot be null");
        this.expression = new SpelExpressionParser().parseExpression(expressionString, (ParserContext)PARSER_CONTEXT);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
    }

    public ExpressionRetryPolicy withBeanFactory(BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
        return this;
    }

    @Override
    public boolean canRetry(RetryContext context) {
        Throwable lastThrowable = context.getLastThrowable();
        if (lastThrowable == null) {
            return super.canRetry(context);
        }
        return super.canRetry(context) && (Boolean)this.expression.getValue((EvaluationContext)this.evaluationContext, (Object)lastThrowable, Boolean.class) != false;
    }
}

