/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kew.api.document.Document;
import org.w3c.dom.Element;

@XmlRootElement(name="documentUpdate")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentUpdateType", propOrder={"title", "applicationDocumentId", "applicationDocumentStatus", "variables", "dirtyFields", "_futureElements"})
public final class DocumentUpdate
extends AbstractDataTransferObject {
    private static final long serialVersionUID = 608839901744771499L;
    @XmlElement(name="title", required=false)
    private final String title;
    @XmlElement(name="applicationDocumentId", required=false)
    private final String applicationDocumentId;
    @XmlElement(name="applicationDocumentStatus", required=false)
    private final String applicationDocumentStatus;
    @XmlElement(name="variables", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> variables;
    @XmlElementWrapper(name="dirtyFields", required=false)
    @XmlElement(name="field", required=false)
    private final List<String> dirtyFields;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentUpdate() {
        this.title = null;
        this.applicationDocumentId = null;
        this.applicationDocumentStatus = null;
        this.variables = null;
        this.dirtyFields = new ArrayList<String>();
    }

    private DocumentUpdate(Builder builder) {
        this.title = builder.getTitle();
        this.applicationDocumentId = builder.getApplicationDocumentId();
        this.applicationDocumentStatus = builder.getApplicationDocumentStatus();
        this.variables = builder.getVariables();
        this.dirtyFields = builder.getDirtyFields();
    }

    public String getTitle() {
        return this.title;
    }

    public String getApplicationDocumentId() {
        return this.applicationDocumentId;
    }

    public String getApplicationDocumentStatus() {
        return this.applicationDocumentStatus;
    }

    public Map<String, String> getVariables() {
        if (this.variables == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.variables);
    }

    public List<String> getDirtyFields() {
        return this.dirtyFields;
    }

    static class Elements {
        static final String TITLE = "title";
        static final String APPLICATION_DOCUMENT_ID = "applicationDocumentId";
        static final String APPLICATION_DOCUMENT_STATUS = "applicationDocumentStatus";
        static final String VARIABLES = "variables";
        static final String DIRTY_FIELDS = "dirtyFields";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentUpdate";
        static final String TYPE_NAME = "DocumentUpdateType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder {
        private static final long serialVersionUID = 2220000561051177421L;
        private String title = "";
        private String applicationDocumentId;
        private String applicationDocumentStatus;
        private Map<String, String> variables = new HashMap<String, String>();
        private List<String> dirtyFields;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(Document document) {
            if (document == null) {
                throw new IllegalArgumentException("document was null");
            }
            Builder builder = Builder.create();
            builder.setTitle(document.getTitle());
            builder.setApplicationDocumentId(document.getApplicationDocumentId());
            builder.setApplicationDocumentStatus(document.getApplicationDocumentStatus());
            builder.setVariables(document.getVariables());
            return builder;
        }

        public DocumentUpdate build() {
            return new DocumentUpdate(this);
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            if (title == null) {
                title = "";
            }
            if (title.length() > 255) {
                title = title.substring(0, 255);
            }
            this.title = title;
        }

        public String getApplicationDocumentId() {
            return this.applicationDocumentId;
        }

        public void setApplicationDocumentId(String applicationDocumentId) {
            this.applicationDocumentId = applicationDocumentId;
        }

        public String getApplicationDocumentStatus() {
            return this.applicationDocumentStatus;
        }

        public void setApplicationDocumentStatus(String applicationDocumentStatus) {
            this.applicationDocumentStatus = applicationDocumentStatus;
        }

        public void setVariables(Map<String, String> variables) {
            this.variables = variables == null ? new HashMap<String, String>() : new HashMap<String, String>(variables);
        }

        public Map<String, String> getVariables() {
            return this.variables;
        }

        public String getVariableValue(String name) {
            return this.variables.get(name);
        }

        public void setVariable(String name, String value) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name was null or blank");
            }
            this.variables.put(name, value);
        }

        public List<String> getDirtyFields() {
            return this.dirtyFields;
        }

        public void setDirtyFields(List<String> dirtyFields) {
            this.dirtyFields = dirtyFields;
        }

        public void addDirtyField(String field) {
            if (this.getDirtyFields() == null) {
                this.setDirtyFields(new ArrayList<String>());
            }
            this.getDirtyFields().add(field);
        }
    }
}

