/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeBoService;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBoService;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationSequenceComparator;

public class KrmsTypeRepositoryServiceImpl
implements KrmsTypeRepositoryService {
    private KrmsTypeBoService krmsTypeBoService = new KrmsTypeBoServiceImpl();
    private TypeTypeRelationBoService typeTypeRelationBoService = new TypeTypeRelationBoServiceImpl();

    public KrmsTypeDefinition createKrmsType(KrmsTypeDefinition krmsType) throws RiceIllegalArgumentException, RiceIllegalStateException {
        return this.krmsTypeBoService.createKrmsType(krmsType);
    }

    public KrmsTypeDefinition updateKrmsType(KrmsTypeDefinition krmsType) throws RiceIllegalArgumentException, RiceIllegalStateException {
        return this.krmsTypeBoService.updateKrmsType(krmsType);
    }

    public KrmsTypeDefinition getTypeById(String id) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.getTypeById(id);
    }

    public KrmsTypeDefinition getTypeByName(String namespaceCode, String name) throws RiceIllegalArgumentException, RiceIllegalStateException {
        return this.krmsTypeBoService.getTypeByName(namespaceCode, name);
    }

    public List<KrmsTypeDefinition> findAllTypesByNamespace(String namespaceCode) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.findAllTypesByNamespace(namespaceCode);
    }

    public List<KrmsTypeDefinition> findAllTypes() {
        return this.krmsTypeBoService.findAllTypes();
    }

    public List<KrmsTypeDefinition> findAllAgendaTypesByContextId(String contextId) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.findAllAgendaTypesByContextId(contextId);
    }

    public KrmsTypeDefinition getAgendaTypeByAgendaTypeIdAndContextId(String agendaTypeId, String contextId) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.getAgendaTypeByAgendaTypeIdAndContextId(agendaTypeId, contextId);
    }

    public List<KrmsTypeDefinition> findAllRuleTypesByContextId(String contextId) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.findAllRuleTypesByContextId(contextId);
    }

    public KrmsTypeDefinition getRuleTypeByRuleTypeIdAndContextId(String ruleTypeId, String contextId) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.getRuleTypeByRuleTypeIdAndContextId(ruleTypeId, contextId);
    }

    public List<KrmsTypeDefinition> findAllActionTypesByContextId(String contextId) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.findAllActionTypesByContextId(contextId);
    }

    public KrmsTypeDefinition getActionTypeByActionTypeIdAndContextId(String actionTypeId, String contextId) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.getActionTypeByActionTypeIdAndContextId(actionTypeId, contextId);
    }

    public KrmsAttributeDefinition getAttributeDefinitionById(String attributeDefinitionId) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.getAttributeDefinitionById(attributeDefinitionId);
    }

    public KrmsAttributeDefinition getAttributeDefinitionByName(String namespaceCode, String name) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.getAttributeDefinitionByName(namespaceCode, name);
    }

    public TypeTypeRelation createTypeTypeRelation(TypeTypeRelation typeTypeRelation) {
        return this.typeTypeRelationBoService.createTypeTypeRelation(typeTypeRelation);
    }

    public TypeTypeRelation getTypeTypeRelation(String typeTypeRelationId) {
        return this.typeTypeRelationBoService.getTypeTypeRelation(typeTypeRelationId);
    }

    public void updateTypeTypeRelation(TypeTypeRelation typeTypeRelation) {
        this.typeTypeRelationBoService.updateTypeTypeRelation(typeTypeRelation);
    }

    public void deleteTypeTypeRelation(String typeTypeRelationId) {
        this.typeTypeRelationBoService.deleteTypeTypeRelation(typeTypeRelationId);
    }

    public List<TypeTypeRelation> findTypeTypeRelationsByFromType(String fromTypeId) {
        return this.typeTypeRelationBoService.findTypeTypeRelationsByFromType(fromTypeId);
    }

    public List<TypeTypeRelation> findTypeTypeRelationsByToType(String toTypeId) {
        return this.typeTypeRelationBoService.findTypeTypeRelationsByToType(toTypeId);
    }

    public List<TypeTypeRelation> findTypeTypeRelationsByRelationshipType(RelationshipType relationshipType) {
        return this.typeTypeRelationBoService.findTypeTypeRelationsByRelationshipType(relationshipType);
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        if (this.krmsTypeBoService instanceof KrmsTypeBoServiceImpl) {
            ((KrmsTypeBoServiceImpl)this.krmsTypeBoService).setDataObjectService(dataObjectService);
        }
        if (this.typeTypeRelationBoService instanceof TypeTypeRelationBoServiceImpl) {
            ((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoService).setDataObjectService(dataObjectService);
        }
    }

    public List<KrmsTypeDefinition> findAllTypesByServiceName(String serviceName) throws RiceIllegalArgumentException {
        return this.krmsTypeBoService.findAllTypesByServiceName(serviceName);
    }

    public List<KrmsTypeDefinition> findAllContextTypes() throws RiceIllegalArgumentException {
        return this.findAllTypesByServiceName("contextTypeService");
    }

    public List<KrmsTypeDefinition> findAllAgendaTypes() throws RiceIllegalArgumentException {
        return this.findAllTypesByServiceName("agendaTypeService");
    }

    public List<KrmsTypeDefinition> findAllRuleTypes() throws RiceIllegalArgumentException {
        return this.findAllTypesByServiceName("ruleTypeService");
    }

    public List<KrmsTypeDefinition> findAllPropositionTypes() throws RiceIllegalArgumentException {
        ArrayList<KrmsTypeDefinition> list = new ArrayList<KrmsTypeDefinition>();
        for (String typeServiceName : PROPOSITION_SERVICE_NAMES) {
            list.addAll(this.findAllTypesByServiceName(typeServiceName));
        }
        return list;
    }

    public List<KrmsTypeDefinition> findAllPropositionParameterTypes() throws RiceIllegalArgumentException {
        ArrayList<KrmsTypeDefinition> list = new ArrayList<KrmsTypeDefinition>();
        for (String typeServiceName : PROPOSITION_PARAMETER_SERVICE_NAMES) {
            list.addAll(this.findAllTypesByServiceName(typeServiceName));
        }
        return list;
    }

    public List<KrmsTypeDefinition> findAgendaTypesForContextType(String contextTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(contextTypeId, Arrays.asList("contextTypeService"), Arrays.asList("agendaTypeService"));
    }

    private List<KrmsTypeDefinition> _findTypesForType(String typeId, List<String> fromServiceNames, List<String> toServiceNames) throws RiceIllegalArgumentException {
        KrmsTypeDefinition fromType = this.getTypeById(typeId);
        if (fromType == null) {
            throw new RiceIllegalArgumentException(typeId + " does not exist");
        }
        if (!fromServiceNames.contains(fromType.getServiceName())) {
            throw new RiceIllegalArgumentException(typeId + "'s serviceTypeName is " + fromType.getServiceName() + " expected " + fromServiceNames);
        }
        List<TypeTypeRelation> rels = this.findTypeTypeRelationsByFromType(typeId);
        rels = new ArrayList<TypeTypeRelation>(rels);
        Collections.sort(rels, new TypeTypeRelationSequenceComparator());
        ArrayList<KrmsTypeDefinition> list = new ArrayList<KrmsTypeDefinition>(rels.size());
        for (TypeTypeRelation rel : rels) {
            KrmsTypeDefinition info = this.getTypeById(rel.getToTypeId());
            if (!toServiceNames.contains(info.getServiceName())) continue;
            list.add(info);
        }
        return list;
    }

    public List<KrmsTypeDefinition> findAgendaTypesForAgendaType(String agendaTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(agendaTypeId, Arrays.asList("agendaTypeService"), Arrays.asList("agendaTypeService"));
    }

    public List<KrmsTypeDefinition> findRuleTypesForAgendaType(String agendaTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(agendaTypeId, Arrays.asList("agendaTypeService"), Arrays.asList("ruleTypeService"));
    }

    public List<KrmsTypeDefinition> findPropositionTypesForRuleType(String ruleTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(ruleTypeId, Arrays.asList("ruleTypeService"), Arrays.asList(PROPOSITION_SERVICE_NAMES));
    }

    public List<KrmsTypeDefinition> findPropositionParameterTypesForPropositionType(String propositionTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(propositionTypeId, Arrays.asList(PROPOSITION_SERVICE_NAMES), Arrays.asList(PROPOSITION_PARAMETER_SERVICE_NAMES));
    }

    public List<KrmsTypeDefinition> findTermParameterTypesForTermPropositionParameterType(String termPropositionParameterTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(termPropositionParameterTypeId, Arrays.asList("termPropositionParameterTypeService"), Arrays.asList("termParameterTypeService"));
    }
}

