/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.coi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.DisclosureProjectStatus;
import org.kuali.coeus.coi.framework.DisclosureStatusRetrievalService;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.UnknownHttpStatusCodeException;

@Component(value="disclosureStatusRetrievalService")
public class DisclosureStatusRetrievalServiceImpl
implements DisclosureStatusRetrievalService {
    private static Logger LOG = LogManager.getLogger(DisclosureStatusRetrievalServiceImpl.class);
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;

    @Override
    public List<DisclosureProjectStatus> getDisclosureStatusesForProject(String sourceId, String projectId) {
        String url = this.getCoiApiUrl() + sourceId + "/" + projectId;
        HttpHeaders headers = new HttpHeaders();
        headers.put("Content-Type", Collections.singletonList("application/json"));
        headers.put("Authorization", Collections.singletonList(this.getAuthToken()));
        HttpEntity entity = new HttpEntity(null, (MultiValueMap)headers);
        return this.getDisclosureProjectStatuses(url, (HttpEntity<String>)entity, HttpMethod.GET);
    }

    protected String getAuthToken() {
        return "Bearer " + this.getJwtService().createToken();
    }

    protected String getCoiApiUrl() {
        return this.getConfigurationService().getPropertyValueAsString("coi.projects.disclosure.status.url");
    }

    protected List<DisclosureProjectStatus> getDisclosureProjectStatuses(String url, HttpEntity<String> entity, HttpMethod method) {
        List<DisclosureProjectStatus> projectStatuses;
        block5: {
            projectStatuses = new ArrayList<DisclosureProjectStatus>();
            try {
                ResponseEntity<List<DisclosureProjectStatus>> response = this.getDisclosureStatusFromCoi(url, entity, method);
                projectStatuses = (List)response.getBody();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(url + "returned status code " + response.getStatusCode());
                }
            }
            catch (UnknownHttpStatusCodeException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn(url + "returned status code " + e.getRawStatusCode(), (Throwable)e);
                }
            }
            catch (RuntimeException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error(url + "returned error " + e.getMessage(), (Throwable)e);
            }
        }
        return projectStatuses;
    }

    protected ResponseEntity<List<DisclosureProjectStatus>> getDisclosureStatusFromCoi(String url, HttpEntity<String> entity, HttpMethod method) {
        return this.restOperations.exchange(url, method, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<DisclosureProjectStatus>>(){}, new Object[0]);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }
}

