/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.AwardBudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.AddBudgetPeriodEvent;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.period.GenerateBudgetPeriodEvent;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.common.budget.impl.struts.BudgetAction;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class BudgetSummaryAction
extends BudgetAction {
    private static final String CONFIRM_RECALCULATE_BUDGET_KEY = "calculateAllPeriods";
    private static final String CONFIRM_SAVE_BUDGET_KEY = "saveAfterQuestion";
    private static final String CONFIRM_HEADER_TAB_KEY = "headerTabAfterQuestion";
    private static final String DO_NOTHING = "doNothing";
    private static final String CONFIRM_SAVE_SUMMARY = "confirmSaveSummary";
    private static final String CONFIRM_DELETE_BUDGET_PERIOD = "confirmDeleteBudgetPeriod";
    private static final String CONFIRM_DEFAULT_BUDGET_PERIODS = "confirmDefaultBudgetPeriods";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        this.updateTotalCost(budget);
        this.getBudgetSummaryService().setupOldStartEndDate(budget, false);
        if (StringUtils.isNotBlank((CharSequence)budgetForm.getSyncBudgetRate()) && budgetForm.getSyncBudgetRate().equals("Y")) {
            this.getBudgetRatesService().syncAllBudgetRates(budget);
            budgetForm.setSyncBudgetRate("");
            this.getBudgetSummaryService().calculateBudget(budget);
        }
        return forward;
    }

    private BudgetRatesService getBudgetRatesService() {
        return KcServiceLocator.getService(BudgetRatesService.class);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new AwardBudgetSaveEvent(budget));
        if (!StringUtils.equalsIgnoreCase((CharSequence)budget.getOhRateClassCode(), (CharSequence)budgetForm.getOhRateClassCodePrevValue()) || !StringUtils.equalsIgnoreCase((CharSequence)budget.getUrRateClassCode(), (CharSequence)budgetForm.getUrRateClassCodePrevValue())) {
            if (this.isBudgetPeriodDateChanged(budget) && this.isLineItemErrorOnly()) {
                GlobalVariables.setMessageMap((MessageMap)new MessageMap());
                return this.confirm(this.buildSaveBudgetSummaryConfirmationQuestion(mapping, form, request, response, "document.question.saveBudgetSummary.forRateAndDateChange.text"), CONFIRM_SAVE_SUMMARY, DO_NOTHING);
            }
            return this.confirm(this.buildRecalculateBudgetConfirmationQuestion(mapping, form, request, response), CONFIRM_SAVE_BUDGET_KEY, DO_NOTHING);
        }
        if (this.isBudgetPeriodDateChanged(budget) && this.isLineItemErrorOnly()) {
            GlobalVariables.setMessageMap((MessageMap)new MessageMap());
            return this.confirm(this.buildSaveBudgetSummaryConfirmationQuestion(mapping, form, request, response, "document.question.saveBudgetSummary.text"), CONFIRM_SAVE_SUMMARY, "");
        }
        if (rulePassed) {
            if (StringUtils.isBlank((CharSequence)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KcServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            this.updateBudgetPeriodDbVersion(budget);
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward saveAfterQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new AwardBudgetSaveEvent(budget));
        if (rulePassed) {
            if (StringUtils.isBlank((CharSequence)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KcServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            this.updateBudgetPeriodDbVersion(budget);
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmSaveSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        budget.getBudgetSummaryService().adjustStartEndDatesForLineItems(budget);
        boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new AwardBudgetSaveEvent(budget));
        if (rulePassed) {
            if (StringUtils.isBlank((CharSequence)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KcServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            this.updateBudgetPeriodDbVersion(budget);
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addBudgetPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        BudgetPeriod newBudgetPeriod = budgetForm.getNewBudgetPeriod();
        if (this.getKcBusinessRulesEngine().applyRules(new AddBudgetPeriodEvent(budget, newBudgetPeriod)).booleanValue()) {
            budget.getBudgetSummaryService().addBudgetPeriod(budget, newBudgetPeriod);
            budgetForm.setNewBudgetPeriod(budget.getNewBudgetPeriod());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteBudgetPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int delPeriod = this.getLineToDelete(request);
        int viewPeriod = 0;
        if (budgetForm.getViewBudgetPeriod() != null) {
            viewPeriod = budgetForm.getViewBudgetPeriod();
        }
        List<BudgetLineItem> budgetLineItems = budget.getBudgetPeriods().get(delPeriod).getBudgetLineItems();
        if (viewPeriod > 0 && (delPeriod + 1 == viewPeriod || budget.getBudgetPeriods().size() == viewPeriod)) {
            budgetForm.setViewBudgetPeriod(new Integer(1));
        }
        if (budgetLineItems != null && budgetLineItems.size() > 0) {
            return this.confirm(this.buildDeleteBudgetPeriodConfirmationQuestion(mapping, form, request, response, delPeriod + 1), CONFIRM_DELETE_BUDGET_PERIOD, "");
        }
        this.getBudgetSummaryService().deleteBudgetPeriod(budget, delPeriod);
        this.getBudgetSummaryService().calculateBudget(budget);
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteBudgetPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int delPeriod = this.getLineToDelete(request);
        budget.getBudgetSummaryService().deleteBudgetPeriod(budget, delPeriod);
        this.getBudgetSummaryService().calculateBudget(budget);
        return mapping.findForward("basic");
    }

    public ActionForward recalculateBudgetPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        this.getBudgetSummaryService().calculateBudget(budget);
        return mapping.findForward("basic");
    }

    public ActionForward generateAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new GenerateBudgetPeriodEvent(budgetForm.getBudget(), null));
        Budget budget = budgetForm.getBudget();
        if (rulePassed) {
            if (StringUtils.isBlank((CharSequence)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KcServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            this.getBudgetSummaryService().generateAllPeriods(budget);
        }
        return mapping.findForward("basic");
    }

    public ActionForward questionCalculateAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        if (!StringUtils.equalsIgnoreCase((CharSequence)budget.getOhRateClassCode(), (CharSequence)budgetForm.getOhRateClassCodePrevValue()) || !StringUtils.equalsIgnoreCase((CharSequence)budget.getUrRateClassCode(), (CharSequence)budgetForm.getUrRateClassCodePrevValue())) {
            return this.confirm(this.buildRecalculateBudgetConfirmationQuestion(mapping, form, request, response), CONFIRM_RECALCULATE_BUDGET_KEY, DO_NOTHING);
        }
        if (StringUtils.isBlank((CharSequence)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
            KcServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
        }
        this.getBudgetSummaryService().calculateBudget(budget);
        return mapping.findForward("basic");
    }

    public ActionForward calculateAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        String question = request.getParameter("questionIndex");
        if (CONFIRM_RECALCULATE_BUDGET_KEY.equals(question)) {
            if (StringUtils.isBlank((CharSequence)budgetForm.getPrevOnOffCampusFlag()) || !budget.getOnOffCampusFlag().equals(budgetForm.getPrevOnOffCampusFlag())) {
                KcServiceLocator.getService(BudgetSummaryService.class).updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
            }
            this.getBudgetSummaryService().calculateBudget(budget);
        }
        return mapping.findForward("basic");
    }

    public ActionForward doNothing(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        budget.setOhRateClassCode(budgetForm.getOhRateClassCodePrevValue());
        budget.setUrRateClassCode(budgetForm.getUrRateClassCodePrevValue());
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildRecalculateBudgetConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_RECALCULATE_BUDGET_KEY, "document.question.recalculateBudget.text", new String[0]);
    }

    protected KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }

    private void updateBudgetPeriodDbVersion(Budget budget) {
        HashMap<String, Long> budgetPeriodMap = new HashMap<String, Long>();
        budgetPeriodMap.put("budgetId", budget.getBudgetId());
        Collection existBudgetPeriods = KcServiceLocator.getService(BusinessObjectService.class).findMatching(BudgetPeriod.class, budgetPeriodMap);
        for (BudgetPeriod budgetPeriod : existBudgetPeriods) {
            for (BudgetPeriod newBudgetPeriod : budget.getBudgetPeriods()) {
                if (!budgetPeriod.getBudgetPeriodId().equals(newBudgetPeriod.getBudgetPeriodId())) continue;
                newBudgetPeriod.setVersionNumber(budgetPeriod.getVersionNumber());
            }
        }
    }

    private void updateTotalCost(Budget budget) {
        ScaleTwoDecimal totalDirectCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalCost = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            budgetPeriod.setTotalCost((ScaleTwoDecimal)budgetPeriod.getTotalDirectCost().add((AbstractDecimal)budgetPeriod.getTotalIndirectCost()));
            totalDirectCost = (ScaleTwoDecimal)totalDirectCost.add((AbstractDecimal)budgetPeriod.getTotalDirectCost());
            totalIndirectCost = (ScaleTwoDecimal)totalIndirectCost.add((AbstractDecimal)budgetPeriod.getTotalIndirectCost());
            totalCost = (ScaleTwoDecimal)totalCost.add((AbstractDecimal)budgetPeriod.getTotalCost());
        }
        budget.setTotalDirectCost(totalDirectCost);
        budget.setTotalIndirectCost(totalIndirectCost);
        budget.setTotalCost(totalCost);
    }

    @Override
    public ActionForward headerTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        if (!StringUtils.equalsIgnoreCase((CharSequence)budget.getOhRateClassCode(), (CharSequence)budgetForm.getOhRateClassCodePrevValue()) || !StringUtils.equalsIgnoreCase((CharSequence)budget.getUrRateClassCode(), (CharSequence)budgetForm.getUrRateClassCodePrevValue())) {
            return this.confirm(this.buildRecalculateBudgetConfirmationQuestion(mapping, form, request, response), CONFIRM_HEADER_TAB_KEY, DO_NOTHING);
        }
        return super.headerTab(mapping, form, request, response);
    }

    public ActionForward headerTabAfterQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.headerTab(mapping, form, request, response);
    }

    private boolean isBudgetPeriodDateChanged(Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getStartDate().compareTo(budgetPeriod.getOldStartDate()) == 0 && budgetPeriod.getEndDate().compareTo(budgetPeriod.getOldEndDate()) == 0) continue;
            return true;
        }
        return false;
    }

    private StrutsConfirmation buildSaveBudgetSummaryConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SAVE_SUMMARY, message, "");
    }

    private StrutsConfirmation buildDeleteBudgetPeriodConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, int deletePeriod) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_HEADER_TAB_KEY, "document.question.deleteBudgetPeriod.text", Integer.toString(deletePeriod));
    }

    private boolean isLineItemErrorOnly() {
        if (!GlobalVariables.getMessageMap().hasNoErrors()) {
            for (Map.Entry e : GlobalVariables.getMessageMap().getErrorMessages().entrySet()) {
                AutoPopulatingList errorList = (AutoPopulatingList)e.getValue();
                for (ErrorMessage em : errorList) {
                    if (em.getErrorKey().equals("error.lineItem.dateDoesNotmatch")) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public ActionForward defaultPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        String warningMessage = budget.getBudgetSummaryService().defaultWarningMessage(budget);
        if (StringUtils.isNotBlank((CharSequence)warningMessage)) {
            return this.confirm(this.buildDefaultBudgetPeriodsConfirmationQuestion(mapping, form, request, response, warningMessage), CONFIRM_DEFAULT_BUDGET_PERIODS, "");
        }
        budget.getBudgetSummaryService().defaultBudgetPeriods(budget);
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDefaultBudgetPeriodsConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_HEADER_TAB_KEY, "document.question.defaultBudgetPeriods.text", message);
    }

    public ActionForward confirmDefaultBudgetPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        budget.getBudgetSummaryService().defaultBudgetPeriods(budget);
        budget.getBudgetSummaryService().adjustStartEndDatesForLineItems(budget);
        return mapping.findForward("basic");
    }
}

