/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;

@Component(value="kcConfigVerifier")
public class KcConfigVerifier
implements InitializingBean {
    private static final Logger LOG = LogManager.getLogger(KcConfigVerifier.class);
    private static final String ORACLE_PLATFORM_NM = "Oracle";
    private static final String ORACLE_CLASS_NAME = "org.eclipse.persistence.platform.database.oracle.Oracle12Platform";
    private static final String KC_CONFIG_VERIFIER_HARD_ERROR_CFG_NM = "kc.config.verifier.hard.error";
    private static final String SERVER_DATASOURCE_PLATFORM_CFG_NM = "server.datasource.platform";
    private static final String DATASOURCE_PLATFORM_CFG_NM = "datasource.platform";
    private static final String MISSING_LIB_MESSAGE_FOR_ORACLE = "Oracle platform detected but org.eclipse.persistence:org.eclipse.persistence.oracle:jar is not found on the classpath";
    private static final String INCLUDED_LIB_MESSAGE_FOR_NON_ORACLE = "Non-Oracle platform detected but org.eclipse.persistence:org.eclipse.persistence.oracle:jar is found on the classpath";
    private static final String TOMCAT_SERVER_CLASS_NAME = "org.apache.catalina.Server";
    private static final String TOMCAT_INSTRUMENTATION_CLASS_LOADER_CLASS_NAME = "org.springframework.instrument.classloading.tomcat.TomcatInstrumentableClassLoader";
    private static final String INSTRUMENTATION_AGENT_CLASS_NAME = "org.springframework.instrument.InstrumentationSavingAgent";
    private static final String GET_INSTRUMENTATION_METHOD = "getInstrumentation";
    private static final String TOMCAT_SERVER_INFO_CLASS_NAME = "org.apache.catalina.util.ServerInfo";
    private static final String TOMCAT_7_VERSION_PREFIX = "7.0";
    private static final String TOMCAT_GET_SERVER_NUMBER_METHOD = "getServerNumber";
    private static final String TOMCAT_8_VERSION_PREFIX = "8.0";
    private static final String TOMCAT_85_VERSION_PREFIX = "8.5";
    private static final String INTEGRATION_TEST_CLASS = "org.kuali.kra.test.infrastructure.ApplicationServer";
    private static final String LOG4J_TOMCAT_HELP = "Tomcat 8.5 detected but log4j 2 is not configured for Tomcat. See https://logging.apache.org/log4j/2.0/log4j-appserver/index.html";
    private static final String LOG4J_JUL_HELP = "JUL logging is not configured with log4j 2. See https://logging.apache.org/log4j/2.0/log4j-jul/index.html.  LogManager class: ";
    private static final String TOMCAT_LOGGER = "org.apache.logging.log4j.appserver.tomcat.TomcatLogger";
    private static final String JULI_LOG_FACTORY = "org.apache.juli.logging.LogFactory";
    private static final String GET_LOG = "getLog";
    private static final String JUL_LOG_MANAGER = "org.apache.logging.log4j.jul.LogManager";
    private static final String CLASS_PERSISTENCE_OBJECT = "org.eclipse.persistence.internal.descriptors.PersistenceObject";
    private static final String CLASS_PERSISTENCE_ENTITY = "org.eclipse.persistence.internal.descriptors.PersistenceEntity";
    private static final String WEAVED_METHOD_PREFIX = "_persistence_";
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Value(value="#{{'org.kuali', 'co.kuali'}}")
    private Set<String> weavedPackages;

    public void afterPropertiesSet() {
        this.verifyOracleConfiguration();
        this.verifyInstrumentationConfiguration();
        this.verifyTomcatLogging();
        this.verifyJulLogging();
        this.verifyWeaving();
    }

    protected void verifyWeaving() {
        Class<?> persistenceEntity;
        Class<?> persistenceObject;
        if (this.runningOnTomcat85FromJunit()) {
            return;
        }
        AllClassPathScanningCandidateComponentProvider entityScanner = new AllClassPathScanningCandidateComponentProvider(false);
        entityScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        AllClassPathScanningCandidateComponentProvider mscScanner = new AllClassPathScanningCandidateComponentProvider(false);
        mscScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MappedSuperclass.class));
        AllClassPathScanningCandidateComponentProvider embeddableScanner = new AllClassPathScanningCandidateComponentProvider(false);
        embeddableScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Embeddable.class));
        try {
            persistenceObject = Class.forName(CLASS_PERSISTENCE_OBJECT);
            persistenceEntity = Class.forName(CLASS_PERSISTENCE_ENTITY);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Set notWeaved = Stream.concat(this.findNotWeaved(Stream.of(persistenceObject, persistenceEntity).collect(Collectors.toSet()), Stream.concat(this.weavedPackages.stream().map(arg_0 -> ((ClassPathScanningCandidateComponentProvider)entityScanner).findCandidateComponents(arg_0)).flatMap(Collection::stream), this.weavedPackages.stream().map(arg_0 -> ((ClassPathScanningCandidateComponentProvider)mscScanner).findCandidateComponents(arg_0)).flatMap(Collection::stream))), this.findNotWeaved(Collections.singleton(persistenceObject), this.weavedPackages.stream().map(arg_0 -> ((ClassPathScanningCandidateComponentProvider)embeddableScanner).findCandidateComponents(arg_0)).flatMap(Collection::stream))).collect(Collectors.toSet());
        if (!notWeaved.isEmpty()) {
            String message = "Found a class(es) which are not bytecode weaved: " + notWeaved + ". This indicates a misconfiguration.";
            if (this.hardError()) {
                throw new RuntimeException(message);
            }
            LOG.fatal(message);
        }
    }

    private Stream<Class<?>> findNotWeaved(Set<Class<?>> isAssignableFrom, Stream<BeanDefinition> types) {
        Set classes = types.map(BeanDefinition::getBeanClassName).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
        return classes.stream().filter(type -> {
            boolean weavedMethod = Stream.of(type.getDeclaredMethods()).map(Method::getName).anyMatch(methodName -> methodName.startsWith(WEAVED_METHOD_PREFIX));
            return !isAssignableFrom.stream().allMatch(intr -> intr.isAssignableFrom((Class<?>)type)) || !weavedMethod;
        });
    }

    protected void verifyTomcatLogging() {
        if (this.runningOnTomcat85() && !this.usingLog4jTomcatLogger()) {
            if (this.hardError()) {
                throw new RuntimeException(LOG4J_TOMCAT_HELP);
            }
            LOG.fatal(LOG4J_TOMCAT_HELP);
        }
    }

    protected void verifyJulLogging() {
        if (this.runningOnTomcat85FromJunit()) {
            return;
        }
        java.util.logging.LogManager logManager = java.util.logging.LogManager.getLogManager();
        if (this.runningOnTomcat85() && logManager != null && !JUL_LOG_MANAGER.equals(logManager.getClass().getName())) {
            String message = LOG4J_JUL_HELP + logManager.getClass().getName();
            if (this.hardError()) {
                throw new RuntimeException(message);
            }
            LOG.fatal(message);
        }
    }

    protected void verifyOracleConfiguration() {
        if (this.oraclePlatform() && !this.oracleJpaLibraryAvailable()) {
            if (this.hardError()) {
                throw new RuntimeException(MISSING_LIB_MESSAGE_FOR_ORACLE);
            }
            LOG.fatal(MISSING_LIB_MESSAGE_FOR_ORACLE);
        } else if (!this.oraclePlatform() && this.oracleJpaLibraryAvailable()) {
            LOG.warn(INCLUDED_LIB_MESSAGE_FOR_NON_ORACLE);
        }
    }

    protected void verifyInstrumentationConfiguration() {
        if (this.tomcatInstrumentingClassLoaderAvailable() && this.genericInstrumentationAgentAvailable()) {
            LOG.warn("Both the Spring Tomcat Instrumenting ClassLoader and the Spring Instrumentation Agent are on the classpath but only one is needed.");
        }
        if (this.runningOnTomcat8Or85() && !this.runningOnTomcat85FromJunit()) {
            if (this.tomcatInstrumentingClassLoaderAvailable() && this.hardError()) {
                throw new RuntimeException("The Spring Tomcat Instrumenting ClassLoader is on the classpath but the Tomcat Application Server 8.x is detected.");
            }
            if (this.genericInstrumentationAgentAvailable() && this.hardError()) {
                throw new RuntimeException("The Spring Instrumentation Agent is on the but the Tomcat Application Server 8.x is detected.");
            }
        } else if (this.runningOnTomcat85FromJunit()) {
            if (this.tomcatInstrumentingClassLoaderAvailable() && this.hardError()) {
                throw new RuntimeException("The Spring Tomcat Instrumenting ClassLoader is on the classpath but the Tomcat Application Server 8.5.x Embedded is detected.");
            }
            if (!this.genericInstrumentationAgentAvailable()) {
                if (this.hardError()) {
                    throw new RuntimeException("The Spring Instrumentation Agent is not on the classpath but is needed.");
                }
            } else if (this.genericInstrumentationAgentAvailable() && !this.genericInstrumentationAgentConfigured() && this.hardError()) {
                throw new RuntimeException("The Spring Instrumentation Agent is on the classpath but is not properly configured as a jvm javaagent.");
            }
        } else if (this.runningOnTomcat7()) {
            if (!this.tomcatInstrumentingClassLoaderAvailable() && !this.genericInstrumentationAgentAvailable()) {
                if (this.hardError()) {
                    throw new RuntimeException("Neither the Spring Tomcat Instrumenting ClassLoader or the Spring Instrumentation Agent are on the classpath and one is needed.");
                }
            } else if (this.tomcatInstrumentingClassLoaderAvailable() && !this.tomcatInstrumentingClassLoaderConfigured()) {
                if (this.hardError()) {
                    throw new RuntimeException("The Spring Tomcat Instrumenting ClassLoader is on the classpath but is not properly configured in the context.xml file.");
                }
            } else if (this.genericInstrumentationAgentAvailable() && !this.genericInstrumentationAgentConfigured() && this.hardError()) {
                throw new RuntimeException("The Spring Instrumentation Agent is on the classpath but is not properly configured as a jvm javaagent.");
            }
        } else {
            if (this.tomcatInstrumentingClassLoaderAvailable()) {
                LOG.warn("The Spring Tomcat Instrumenting ClassLoader is on the classpath but the Tomcat Application Server is not detected.");
            }
            if (!this.genericInstrumentationAgentAvailable()) {
                if (this.hardError()) {
                    throw new RuntimeException("The Spring Instrumentation Agent is not on the classpath but is needed.");
                }
            } else if (this.genericInstrumentationAgentAvailable() && !this.genericInstrumentationAgentConfigured() && this.hardError()) {
                throw new RuntimeException("The Spring Instrumentation Agent is on the classpath but is not properly configured as a jvm javaagent.");
            }
        }
    }

    private boolean usingLog4jTomcatLogger() {
        try {
            Class<?> logFactoryClass = Class.forName(JULI_LOG_FACTORY);
            Method getLog = logFactoryClass.getDeclaredMethod(GET_LOG, Class.class);
            return TOMCAT_LOGGER.equals(getLog.invoke(logFactoryClass, KcConfigVerifier.class).getClass().getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private String getTomcatServerNumber() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> serverInfo = Class.forName(TOMCAT_SERVER_INFO_CLASS_NAME);
        Method getServerNumber = serverInfo.getDeclaredMethod(TOMCAT_GET_SERVER_NUMBER_METHOD, new Class[0]);
        return (String)getServerNumber.invoke(null, new Object[0]);
    }

    protected boolean runningOnTomcat7() {
        try {
            Class.forName(TOMCAT_SERVER_CLASS_NAME);
            return this.getTomcatServerNumber().startsWith(TOMCAT_7_VERSION_PREFIX);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    protected boolean runningOnTomcat8Or85() {
        return this.runningOnTomcat80() || this.runningOnTomcat85();
    }

    protected boolean runningOnTomcat80() {
        return this.runningOnTomcatVersion(TOMCAT_8_VERSION_PREFIX);
    }

    protected boolean runningOnTomcat85() {
        return this.runningOnTomcatVersion(TOMCAT_85_VERSION_PREFIX);
    }

    protected boolean runningOnTomcatVersion(String prefix) {
        try {
            Class.forName(TOMCAT_SERVER_CLASS_NAME);
            String serverNumber = this.getTomcatServerNumber();
            return serverNumber.startsWith(prefix);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    protected boolean runningOnTomcat85FromJunit() {
        try {
            Class.forName(TOMCAT_SERVER_CLASS_NAME);
            Class.forName(INTEGRATION_TEST_CLASS);
            String serverNumber = this.getTomcatServerNumber();
            return serverNumber.startsWith(TOMCAT_85_VERSION_PREFIX);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    protected boolean tomcatInstrumentingClassLoaderAvailable() {
        try {
            Class.forName(TOMCAT_INSTRUMENTATION_CLASS_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected boolean tomcatInstrumentingClassLoaderConfigured() {
        for (ClassLoader cl = this.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
            if (!TOMCAT_INSTRUMENTATION_CLASS_LOADER_CLASS_NAME.equals(cl.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean genericInstrumentationAgentAvailable() {
        try {
            Class.forName(INSTRUMENTATION_AGENT_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected boolean genericInstrumentationAgentConfigured() {
        try {
            Class<?> instrumentationSavingAgentClass = Class.forName(INSTRUMENTATION_AGENT_CLASS_NAME);
            Method getInstrumentation = instrumentationSavingAgentClass.getMethod(GET_INSTRUMENTATION_METHOD, new Class[0]);
            return getInstrumentation.invoke(instrumentationSavingAgentClass, new Object[0]) != null;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    protected boolean oracleJpaLibraryAvailable() {
        try {
            Class.forName(ORACLE_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return true;
        }
    }

    protected boolean oraclePlatform() {
        String serverPlatform = this.configurationService.getPropertyValueAsString(SERVER_DATASOURCE_PLATFORM_CFG_NM);
        String clientPlatform = this.configurationService.getPropertyValueAsString(DATASOURCE_PLATFORM_CFG_NM);
        return serverPlatform != null && serverPlatform.contains(ORACLE_PLATFORM_NM) || clientPlatform != null && clientPlatform.contains(ORACLE_PLATFORM_NM);
    }

    protected boolean hardError() {
        return this.configurationService.getPropertyValueAsBoolean(KC_CONFIG_VERIFIER_HARD_ERROR_CFG_NM);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public Set<String> getWeavedPackages() {
        return this.weavedPackages;
    }

    public void setWeavedPackages(Set<String> weavedPackages) {
        this.weavedPackages = weavedPackages;
    }

    private static final class AllClassPathScanningCandidateComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        public AllClassPathScanningCandidateComponentProvider(boolean useDefaultFilters) {
            super(useDefaultFilters);
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return true;
        }
    }
}

