/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.actionlist.ActionListService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="kcWorkflowService")
public class KcWorkflowServiceImpl
implements KcWorkflowService {
    private static final Logger LOG = LogManager.getLogger(KcWorkflowService.class);
    @Autowired
    @Qualifier(value="workflowDocumentActionsService")
    protected WorkflowDocumentActionsService workflowDocumentActionsService;
    @Autowired
    @Qualifier(value="kewWorkflowDocumentService")
    protected WorkflowDocumentService workflowDocumentService;
    @Autowired
    @Qualifier(value="actionListService")
    protected ActionListService actionListService;
    private static final List<String> approvalCodes = new ArrayList<String>();

    @Override
    public boolean hasWorkflowPermission(String userId, Document doc) {
        boolean hasPermission = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null && !this.isInitiated(doc)) {
            String routeHeaderId = workflowDoc.getDocumentId();
            hasPermission = this.workflowDocumentActionsService.isUserInRouteLog(routeHeaderId, userId, true);
        }
        return hasPermission;
    }

    @Override
    public boolean isClosed(Document doc) {
        boolean isClosed = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null) {
            isClosed = workflowDoc.isApproved() || workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isException();
        }
        return isClosed;
    }

    @Override
    public boolean isEnRoute(Document doc) {
        boolean isEnRoute = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null) {
            isEnRoute = workflowDoc.isEnroute();
        }
        return isEnRoute;
    }

    @Override
    public boolean isInWorkflow(Document doc) {
        boolean isInWorkflow = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null) {
            isInWorkflow = !workflowDoc.isInitiated() && !workflowDoc.isSaved();
        }
        return isInWorkflow;
    }

    public boolean isInitiated(Document doc) {
        boolean isInitiated = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null) {
            isInitiated = workflowDoc.isInitiated();
        }
        return isInitiated;
    }

    protected WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    protected WorkflowDocument getWorkflowDocument(Document doc, String principalId) {
        return WorkflowDocumentFactory.loadDocument((String)principalId, (String)doc.getDocumentHeader().getWorkflowDocument().getDocumentId());
    }

    @Override
    public boolean isUserApprovalRequested(Document doc, String principalId) {
        boolean hasApprovalRequest = false;
        WorkflowDocument workDoc = this.getWorkflowDocument(doc, principalId);
        if (workDoc != null) {
            hasApprovalRequest = workDoc.isApprovalRequested();
        }
        return hasApprovalRequest;
    }

    @Override
    public boolean isUserActionRequested(Document doc, String principalId) {
        boolean hasActionRequest = false;
        WorkflowDocument workDoc = this.getWorkflowDocument(doc, principalId);
        if (workDoc != null) {
            hasActionRequest = workDoc.isApprovalRequested() || workDoc.isAcknowledgeRequested() || workDoc.isFYIRequested();
        }
        return hasActionRequest;
    }

    @Override
    public boolean isDocumentOnNode(Document document, String nodeName) {
        try {
            boolean result = document != null && document.getDocumentHeader().getWorkflowDocument().getNodeNames().contains(nodeName);
            return result;
        }
        catch (Exception we) {
            LOG.error(String.format("Exception generated when trying to determine if document %s is on active %s node.  Reason:%s", nodeName, document.getDocumentNumber(), we.getMessage()), (Throwable)we);
            throw new RuntimeException(String.format("Exception generated when trying determine if document %s is on active %s route node.  Reason:%s", nodeName, document.getDocumentNumber(), we.getMessage()), we);
        }
    }

    @Override
    public boolean isCurrentNode(Document document, String nodeName) {
        try {
            boolean result = document != null && document.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames().contains(nodeName);
            return result;
        }
        catch (Exception we) {
            LOG.error(String.format("Exception generated when trying to determine if document %s is on active or terminal %s node.  Reason:%s", nodeName, document.getDocumentNumber(), we.getMessage()), (Throwable)we);
            throw new RuntimeException(String.format("Exception generated when trying determine if document %s is on active or terminal %s route node.  Reason:%s", nodeName, document.getDocumentNumber(), we.getMessage()), we);
        }
    }

    @Override
    public boolean isUserAdHocRequestRecipient(Document document, String principalId, String nodeName) {
        try {
            List actionRequestsForCurrentUser = this.workflowDocumentService.getActionRequestsForPrincipalAtNode(document.getDocumentNumber(), nodeName, principalId);
            for (ActionRequest actionRequest : actionRequestsForCurrentUser) {
                if (!actionRequest.isAdHocRequest() || !actionRequest.isPending()) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return false;
    }

    @Override
    public boolean isUserRouteRespRequestRecipient(Document document, String principalId, String nodeName) {
        try {
            List actionRequestsForCurrentUser = this.workflowDocumentService.getActionRequestsForPrincipalAtNode(document.getDocumentNumber(), nodeName, principalId);
            for (ActionRequest actionRequest : actionRequestsForCurrentUser) {
                if (!actionRequest.isPending() || !actionRequest.isRouteModuleRequest()) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return false;
    }

    @Override
    public boolean isFinalApproval(WorkflowDocument workflowDoc) {
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)workflowDoc.getDocumentId());
        HashSet<String> approvalNodes = new HashSet<String>();
        Object currentRequest = null;
        DocumentDetail results1 = this.workflowDocumentActionsService.executeSimulation(reportCriteriaBuilder.build());
        for (ActionRequest actionRequest : results1.getActionRequests()) {
            if (!actionRequest.isPending() || !actionRequest.isApprovalRequest()) continue;
            if (actionRequest.isUserRequest() && this.willReceiveFutureRequests(workflowDoc, actionRequest.getPrincipalId())) {
                approvalNodes.add(actionRequest.getNodeName());
                continue;
            }
            if (actionRequest.isGroupRequest()) {
                approvalNodes.add(actionRequest.getNodeName());
                continue;
            }
            if (!actionRequest.isRoleRequest() || this.requestAlreadyApproved(workflowDoc, actionRequest)) continue;
            approvalNodes.add(actionRequest.getNodeName());
        }
        if (currentRequest != null) {
            approvalNodes.remove(currentRequest);
        }
        return approvalNodes.size() == 0;
    }

    @Override
    public boolean requestAlreadyApproved(WorkflowDocument workflowDoc, ActionRequest actionRequest) {
        boolean result = false;
        for (ActionRequest childRequest : actionRequest.getChildRequests()) {
            if (childRequest.isUserRequest()) {
                boolean futureRequests = this.willReceiveFutureRequests(workflowDoc, childRequest.getPrincipalId());
                if (actionRequest.getRequestPolicy() == ActionRequestPolicy.ALL && futureRequests) {
                    result = false;
                    continue;
                }
                if (actionRequest.getRequestPolicy() != ActionRequestPolicy.FIRST || futureRequests) continue;
                result = true;
                continue;
            }
            if (childRequest.isGroupRequest()) {
                if (actionRequest.getRequestPolicy() != ActionRequestPolicy.ALL) continue;
                result = false;
                continue;
            }
            if (!childRequest.isRoleRequest()) continue;
            if (this.requestAlreadyApproved(workflowDoc, childRequest)) {
                if (actionRequest.getRequestPolicy() != ActionRequestPolicy.FIRST) continue;
                result = true;
                continue;
            }
            if (actionRequest.getRequestPolicy() != ActionRequestPolicy.ALL) continue;
            result = false;
        }
        return result;
    }

    private boolean willReceiveFutureRequests(WorkflowDocument workflowDoc, String principalId) {
        boolean doNotReceiveFutureRequests = false;
        Map variables = workflowDoc.getVariables();
        if (variables != null && CollectionUtils.isNotEmpty(variables.keySet())) {
            for (String variableKey : variables.keySet()) {
                String variableValue = (String)variables.get(variableKey);
                if (!variableKey.startsWith("_receive_future_requests") || !variableValue.toUpperCase().equals("NO") || !variableKey.contains(principalId)) continue;
                doNotReceiveFutureRequests = true;
                break;
            }
        }
        return !doNotReceiveFutureRequests;
    }

    @Override
    public boolean hasPendingApprovalRequests(WorkflowDocument workflowDoc) {
        return !this.actionListService.getActionItems(workflowDoc.getDocumentId(), approvalCodes).isEmpty();
    }

    protected ActionListService getActionListService() {
        return this.actionListService;
    }

    public void setActionListService(ActionListService actionListService) {
        this.actionListService = actionListService;
    }

    public void setWorkflowDocumentActionsService(WorkflowDocumentActionsService workflowDocumentActionsService) {
        this.workflowDocumentActionsService = workflowDocumentActionsService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    static {
        approvalCodes.add(ActionRequestType.COMPLETE.getCode());
        approvalCodes.add(ActionRequestType.APPROVE.getCode());
    }
}

