/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.web.struts.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityAttachment;
import org.kuali.kra.negotiations.rules.NegotiationActivityAddRuleEvent;
import org.kuali.kra.negotiations.rules.NegotiationActivityAttachmentAddRuleEvent;
import org.kuali.kra.negotiations.rules.NegotiationActivityAttachmentRuleImpl;
import org.kuali.kra.negotiations.rules.NegotiationActivityRuleImpl;
import org.kuali.kra.negotiations.sorting.ActivitySortingType;
import org.kuali.kra.negotiations.sorting.AttachmentSortingType;
import org.kuali.kra.negotiations.web.struts.form.NegotiationForm;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class NegotiationActivityHelper
implements Serializable {
    private static final long serialVersionUID = 8707454680500119142L;
    private NegotiationForm form;
    private NegotiationActivity newActivity;
    private ActivitySortingType activitySortingType;
    private AttachmentSortingType attachmentSortingType;
    private List<NegotiationActivityAttachment> allAttachments;
    private static final String ACTIVITY_RESTRICTED_FLAG_DEFAULT = "ActivityRestrictedFlagDefault";

    public NegotiationActivityHelper(NegotiationForm form) {
        this.form = form;
    }

    public void addActivity() {
        NegotiationActivityAddRuleEvent event = new NegotiationActivityAddRuleEvent("NegotiationActivityAddRuleEvent", "negotiationActivityHelper.newActivity", this.getForm().getDocument(), this.getNewActivity());
        if (new NegotiationActivityRuleImpl().processAddNegotiationActivityRule(event)) {
            this.newActivity.setCreateDate(new java.sql.Date(new Date().getTime()));
            this.newActivity.setUpdated(true);
            this.form.getNegotiationDocument().getNegotiation().getActivities().add(this.newActivity);
            this.newActivity = null;
        }
    }

    public void setRestrictedActivity(Boolean restricted, int activityIndex) {
        this.getActivity(activityIndex).setRestricted(restricted);
    }

    public NegotiationActivity getActivity(int activityIndex) {
        if (activityIndex == -1) {
            return this.getNewActivity();
        }
        return this.form.getNegotiationDocument().getNegotiation().getActivities().get(activityIndex);
    }

    protected String getActivityPrefix(int activityIndex) {
        if (activityIndex == -1) {
            return "negotiationActivityHelper.newActivity";
        }
        return "document.negotiationList[0].activities[" + activityIndex + "]";
    }

    public void addAttachment(int activityIndex) {
        NegotiationActivity activity = this.getActivity(activityIndex);
        String activityPrefix = this.getActivityPrefix(activityIndex);
        NegotiationActivityAttachment attachment = activity.getNewAttachment();
        NegotiationActivityAttachmentAddRuleEvent event = new NegotiationActivityAttachmentAddRuleEvent("NegotiationActivityAddRuleEvent", activityPrefix + ".newAttachment", this.getForm().getDocument(), activity, attachment);
        if (new NegotiationActivityAttachmentRuleImpl().processAddAttachmentRule(event)) {
            attachment.setFile(AttachmentFile.createFromFormFile(attachment.getNewFile()));
            attachment.setActivity(activity);
            activity.add(attachment);
            NegotiationActivityAttachment newAttachment = new NegotiationActivityAttachment();
            newAttachment.setRestricted(this.newActivity.getRestricted());
            activity.setNewAttachment(newAttachment);
        }
    }

    public void deleteActivity(int activityIndex) {
        NegotiationActivity activity = this.getActivity(activityIndex);
        this.getForm().getNegotiationDocument().getNegotiation().getActivities().remove(activity);
    }

    public void deleteAttachment(int activityIndex, int attachmentIndex) {
        NegotiationActivity activity = this.getActivity(activityIndex);
        activity.getAttachments().remove(attachmentIndex);
    }

    public void setRestrictedAttachment(Boolean restricted, int activityIndex, int attachmentIndex) {
        NegotiationActivity activity = this.getActivity(activityIndex);
        NegotiationActivityAttachment attachment = activity.getAttachments().get(attachmentIndex);
        attachment.setRestricted(restricted);
    }

    public boolean hasPendingActivities() {
        boolean result = false;
        for (NegotiationActivity activity : this.getForm().getNegotiationDocument().getNegotiation().getActivities()) {
            if (activity.getEndDate() != null) continue;
            result = true;
        }
        return result;
    }

    public void closeAllPendingActivities() {
        Negotiation negotiation = this.getForm().getNegotiationDocument().getNegotiation();
        for (NegotiationActivity activity : this.getForm().getNegotiationDocument().getNegotiation().getActivities()) {
            if (activity.getEndDate() != null) continue;
            activity.setEndDate(negotiation.getNegotiationEndDate());
        }
    }

    public NegotiationForm getForm() {
        return this.form;
    }

    public void setForm(NegotiationForm form) {
        this.form = form;
    }

    public NegotiationActivity getNewActivity() {
        if (this.newActivity == null) {
            this.newActivity = new NegotiationActivity();
            boolean defaultRestricted = this.getDefaultRestrictedValue();
            this.newActivity.setRestricted(defaultRestricted);
            this.newActivity.getNewAttachment().setRestricted(defaultRestricted);
        }
        return this.newActivity;
    }

    public void setNewActivity(NegotiationActivity newActivity) {
        this.newActivity = newActivity;
    }

    public ActivitySortingType getActivitySortingType() {
        return this.activitySortingType;
    }

    public void setActivitySortingType(ActivitySortingType activitySortingType) {
        this.activitySortingType = activitySortingType;
    }

    public void setActivitySortingTypeName(String activitySortingTypeName) {
        this.activitySortingType = activitySortingTypeName == null ? null : ActivitySortingType.valueOf(activitySortingTypeName);
    }

    public String getActivitySortingTypeName() {
        return this.activitySortingType.name();
    }

    public AttachmentSortingType getAttachmentSortingType() {
        return this.attachmentSortingType;
    }

    public void setAttachmentSortingType(AttachmentSortingType attachmentSortingType) {
        this.attachmentSortingType = attachmentSortingType;
    }

    public void setAttachmentSortingTypeName(String attachmentSortingTypeName) {
        this.attachmentSortingType = attachmentSortingTypeName == null ? null : AttachmentSortingType.valueOf(attachmentSortingTypeName);
    }

    public String getAttachmentSortingTypeName() {
        return this.attachmentSortingType.name();
    }

    public List<NegotiationActivityAttachment> getAllAttachments() {
        if (this.allAttachments == null) {
            this.generateAllAttachments();
        }
        return this.allAttachments;
    }

    public void generateAllAttachments() {
        this.allAttachments = new ArrayList<NegotiationActivityAttachment>();
        for (NegotiationActivity activity : this.getForm().getNegotiationDocument().getNegotiation().getActivities()) {
            this.allAttachments.addAll(activity.getAttachments());
        }
        if (this.attachmentSortingType != null) {
            Collections.sort(this.allAttachments, this.attachmentSortingType.getComparator());
        }
    }

    public void sortActivities() {
        if (this.getActivitySortingType() != null) {
            Collections.sort(this.getForm().getNegotiationDocument().getNegotiation().getActivities(), this.getActivitySortingType().getComparator());
        }
    }

    private boolean getDefaultRestrictedValue() {
        return KcServiceLocator.getService(ParameterService.class).getParameterValueAsBoolean("KC-NEGOTIATION", "Document", ACTIVITY_RESTRICTED_FLAG_DEFAULT, Boolean.TRUE);
    }
}

