/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.persistence.OptimisticLockException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ken.service.ProcessingResult;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class ConcurrentJob<T> {
    private static final int ORACLE_00054 = 54;
    private static final int ORACLE_00060 = 60;
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    protected ExecutorService executor;
    protected PlatformTransactionManager txManager;

    public ConcurrentJob(PlatformTransactionManager txManager, ExecutorService executor) {
        this.txManager = txManager;
        this.executor = executor;
    }

    protected TransactionTemplate createNewTransaction() {
        TransactionTemplate tt = new TransactionTemplate(this.txManager);
        tt.setPropagationBehavior(3);
        return tt;
    }

    protected abstract Collection<T> takeAvailableWorkItems();

    protected Collection<Collection<T>> groupWorkItems(Collection<T> workItems, ProcessingResult result) {
        ArrayList<Collection<T>> groupedWorkItems = new ArrayList<Collection<T>>();
        if (workItems != null) {
            for (T workItem : workItems) {
                ArrayList<T> c = new ArrayList<T>(1);
                c.add(workItem);
                groupedWorkItems.add(c);
            }
        }
        return groupedWorkItems;
    }

    protected abstract Collection<?> processWorkItems(Collection<T> var1);

    protected abstract void unlockWorkItem(T var1);

    public ProcessingResult run() {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("[" + new Timestamp(System.currentTimeMillis()).toString() + "] STARTING RUN");
        }
        ProcessingResult result = new ProcessingResult();
        Collection items = null;
        try {
            items = (Collection)this.createNewTransaction().execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus txStatus) {
                    return ConcurrentJob.this.takeAvailableWorkItems();
                }
            });
        }
        catch (DataAccessException dae) {
            if (dae instanceof OptimisticLockingFailureException || dae.contains(OptimisticLockingFailureException.class) || dae.contains(OptimisticLockException.class)) {
                this.LOG.info("Contention while taking work items: " + dae.getMessage());
            } else {
                this.LOG.error("Error taking work items", (Throwable)dae);
                Throwable t = dae.getMostSpecificCause();
                if (t != null && t instanceof SQLException) {
                    SQLException sqle = (SQLException)t;
                    if (sqle.getErrorCode() == 54 && StringUtils.contains((String)sqle.getMessage(), (String)"resource busy")) {
                        this.LOG.warn("Select for update lock contention encountered: " + sqle.getMessage());
                    } else if (sqle.getErrorCode() == 60 && StringUtils.contains((String)sqle.getMessage(), (String)"deadlock detected")) {
                        this.LOG.error("Select for update deadlock encountered! " + sqle.getMessage());
                    }
                }
            }
            return result;
        }
        catch (UnexpectedRollbackException ure) {
            this.LOG.error("UnexpectedRollbackException", (Throwable)ure);
            return result;
        }
        catch (TransactionException te) {
            this.LOG.error("Error occurred obtaining available work items", (Throwable)te);
            result.addFailure("Error occurred obtaining available work items: " + te);
            return result;
        }
        Collection<Collection<T>> groupedWorkItems = this.groupWorkItems(items, result);
        Iterator<Collection<T>> i = groupedWorkItems.iterator();
        ArrayList futures = new ArrayList();
        while (i.hasNext()) {
            final Collection<T> workUnit = i.next();
            this.LOG.info("Processing work unit: " + workUnit);
            futures.add(this.executor.submit(new Callable(){

                public Object call() throws Exception {
                    ProcessingResult result = new ProcessingResult();
                    try {
                        Collection successes = (Collection)ConcurrentJob.this.createNewTransaction().execute(new TransactionCallback(){

                            public Object doInTransaction(TransactionStatus txStatus) {
                                return ConcurrentJob.this.processWorkItems(workUnit);
                            }
                        });
                        result.addAllSuccesses(successes);
                    }
                    catch (Exception e) {
                        ConcurrentJob.this.LOG.error("Error occurred processing work unit " + workUnit, (Throwable)e);
                        for (Object workItem : workUnit) {
                            ConcurrentJob.this.LOG.error("Error occurred processing work item " + workItem, (Throwable)e);
                            result.addFailure("Error occurred processing work item " + workItem + ": " + e);
                            ConcurrentJob.this.unlockWorkItemAtomically(workItem);
                        }
                    }
                    return result;
                }
            }));
        }
        for (Future future : futures) {
            try {
                ProcessingResult workResult = (ProcessingResult)future.get();
                result.add(workResult);
            }
            catch (Exception e) {
                String message = "Error obtaining work result: " + e;
                this.LOG.error(message, (Throwable)e);
                result.addFailure(message);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("[" + new Timestamp(System.currentTimeMillis()).toString() + "] FINISHED RUN - " + result);
        }
        return result;
    }

    protected void unlockWorkItemAtomically(final T workItem) {
        try {
            this.createNewTransaction().execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus txStatus) {
                    ConcurrentJob.this.LOG.info("Unlocking failed work item: " + workItem);
                    ConcurrentJob.this.unlockWorkItem(workItem);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            this.LOG.error("Error unlocking failed work item " + workItem, (Throwable)e2);
        }
    }
}

