/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class CancelAction
extends ActionTakenEvent {
    private static final Logger LOG = LogManager.getLogger(CancelAction.class);

    public CancelAction(DocumentRouteHeaderValue rh, PrincipalContract principal) {
        this(ActionType.CANCEL, rh, principal, null);
    }

    public CancelAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation) {
        this(ActionType.CANCEL, rh, principal, annotation);
    }

    CancelAction(ActionType type, DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation) {
        super(type.getCode(), rh, principal, annotation);
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be cancelled";
        }
        List<ActionRequestValue> filteredActionRequests = this.filterActionRequestsByCode(actionRequests, "C");
        if (!this.isActionCompatibleRequest(filteredActionRequests)) {
            return "No request for the user is compatible with the Cancel Action";
        }
        if (!KEWServiceLocator.getDocumentTypePermissionService().canCancel(this.getPrincipal().getPrincipalId(), this.getRouteHeader())) {
            return "User is not authorized to Cancel document";
        }
        return "";
    }

    @Override
    public boolean isActionCompatibleRequest(List<ActionRequestValue> requests) {
        if (this.routeHeader.isStateInitiated() || this.routeHeader.isStateSaved()) {
            return true;
        }
        boolean actionCompatible = false;
        Iterator<ActionRequestValue> ars = requests.iterator();
        ActionRequestValue actionRequest = null;
        while (ars.hasNext()) {
            actionRequest = ars.next();
            String request = actionRequest.getActionRequested();
            if (!"A".equals(request) && !"C".equals(request)) continue;
            actionCompatible = true;
            break;
        }
        return actionCompatible;
    }

    protected void markDocumentStatus() throws InvalidActionTakenException {
        this.getRouteHeader().markDocumentCanceled();
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        LOG.debug("Canceling document : " + this.annotation);
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.getDocumentId(), "C");
        LOG.debug("Checking to see if the action is legal");
        String errorMessage = this.validateActionRules(actionRequests);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        LOG.debug("Record the cancel action");
        ActionTakenValue actionTaken = this.saveActionTaken(this.findDelegatorForActionRequests(actionRequests));
        LOG.debug("Deactivate all pending action requests");
        actionRequests = this.getActionRequestService().findPendingByDoc(this.getDocumentId());
        this.getActionRequestService().deactivateRequests(actionTaken, actionRequests);
        this.notifyActionTaken(actionTaken);
        LOG.debug("Canceling document");
        try {
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            this.markDocumentStatus();
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
            this.setRouteHeader(routeHeaderValue);
            this.notifyStatusChange(newStatus, oldStatus);
        }
        catch (WorkflowException ex) {
            LOG.warn((Object)ex, (Throwable)ex);
            throw new InvalidActionTakenException(ex.getMessage(), (Throwable)ex);
        }
    }
}

