/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property.source;

import com.codiform.moo.MissingSourcePropertyValueException;
import com.codiform.moo.property.source.SourceProperty;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class ReflectionSourceProperty
implements SourceProperty {
    private String propertyName;
    private String isGetterName;
    private String getGetterName;

    public ReflectionSourceProperty(String propertyName) {
        this.propertyName = propertyName;
        String capped = this.cap(propertyName);
        this.isGetterName = "is" + capped;
        this.getGetterName = "get" + capped;
    }

    private String cap(String propertyName) {
        char firstChar = propertyName.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return "" + Character.toUpperCase(firstChar) + propertyName.substring(1);
        }
        return propertyName;
    }

    @Override
    public Object getValue(Object source) {
        for (Class<?> currentClass = source.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method getter = this.getGetter(source, currentClass);
            if (getter != null) {
                return this.getValue(getter, source);
            }
            Field field = this.getField(source, currentClass);
            if (field == null) continue;
            return this.getValue(field, source);
        }
        throw new MissingSourcePropertyValueException(this.propertyName, source.getClass());
    }

    private Object getValue(Field field, Object source) {
        field.setAccessible(true);
        try {
            return field.get(source);
        }
        catch (IllegalArgumentException cause) {
            throw new MissingSourcePropertyValueException(this.propertyName, source.getClass(), cause);
        }
        catch (IllegalAccessException cause) {
            throw new MissingSourcePropertyValueException(this.propertyName, source.getClass(), cause);
        }
    }

    private Field getField(Object source, Class<?> currentClass) {
        for (Field item : currentClass.getDeclaredFields()) {
            if (!item.getName().equals(this.propertyName)) continue;
            return item;
        }
        return null;
    }

    private Object getValue(Method getter, Object source) {
        getter.setAccessible(true);
        try {
            return getter.invoke(source, new Object[0]);
        }
        catch (IllegalArgumentException cause) {
            throw new MissingSourcePropertyValueException(this.propertyName, source.getClass(), cause);
        }
        catch (IllegalAccessException cause) {
            throw new MissingSourcePropertyValueException(this.propertyName, source.getClass(), cause);
        }
        catch (InvocationTargetException cause) {
            throw new MissingSourcePropertyValueException(this.propertyName, source.getClass(), cause);
        }
    }

    private Method getGetter(Object source, Class<?> currentClass) {
        for (Method item : currentClass.getDeclaredMethods()) {
            String methodName;
            if (item.getParameterTypes().length != 0 || !(methodName = item.getName()).equals(this.isGetterName) && !methodName.equals(this.getGetterName)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Object getValue(Object source, Map<String, Object> variables) {
        return this.getValue(source);
    }

    @Override
    public String getExpression() {
        return this.propertyName;
    }

    public String toString() {
        return "ReflectionSourceProperty [propertyName=" + this.propertyName + "]";
    }
}

