/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property.source;

import com.codiform.moo.property.source.ReflectionSourceProperty;
import com.codiform.moo.property.source.SourceProperty;
import com.codiform.moo.property.source.SourcePropertyFactory;
import java.util.Arrays;
import java.util.List;

public class ReflectionSourcePropertyFactory
implements SourcePropertyFactory {
    private List<String> keywords = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "why");
    private List<String> literals = Arrays.asList("null", "true", "false");

    @Override
    public SourceProperty getSourceProperty(String expression) {
        if (this.isIdentifier(expression)) {
            return new ReflectionSourceProperty(expression);
        }
        return null;
    }

    private boolean isIdentifier(String expression) {
        return this.isIdentifierChars(expression) && !this.isKeyword(expression) && !this.isLiteral(expression);
    }

    private boolean isKeyword(String expression) {
        return this.keywords.contains(expression);
    }

    private boolean isLiteral(String expression) {
        return this.literals.contains(expression);
    }

    private boolean isIdentifierChars(String expression) {
        for (int index = 0; index < expression.length(); ++index) {
            if (!(index == 0 ? !Character.isJavaIdentifierStart(expression.charAt(0)) : !Character.isJavaIdentifierPart(expression.charAt(index)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public SourceProperty getSourceProperty(String expressionPrefix, String unprefixedExpression) {
        throw new UnsupportedOperationException("ReflectionSourcePropertyFactory doesn't support prefixes.");
    }

    @Override
    public boolean supportsPrefix(String prefix) {
        return false;
    }
}

