/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.LogicalRemoteTable;
import net.sourceforge.schemaspy.model.LogicalTable;
import net.sourceforge.schemaspy.model.ProgressListener;
import net.sourceforge.schemaspy.model.RemoteTable;
import net.sourceforge.schemaspy.model.Routine;
import net.sourceforge.schemaspy.model.RoutineParameter;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.model.View;
import net.sourceforge.schemaspy.model.xml.SchemaMeta;
import net.sourceforge.schemaspy.model.xml.TableMeta;
import net.sourceforge.schemaspy.util.CaseInsensitiveMap;

public class Database {
    private final Config config;
    private final String databaseName;
    private final String catalog;
    private final String schema;
    private final Map<String, Table> tables = new CaseInsensitiveMap<Table>();
    private final Map<String, View> views = new CaseInsensitiveMap<View>();
    private final Map<String, Table> remoteTables = new CaseInsensitiveMap<Table>();
    private final Map<String, Table> locals = new CombinedMap(this.tables, this.views);
    private final Map<String, Routine> routines = new CaseInsensitiveMap<Routine>();
    private final DatabaseMetaData meta;
    private final Connection connection;
    private final String connectTime = new SimpleDateFormat("EEE MMM dd HH:mm z yyyy").format(new Date());
    private Set<String> sqlKeywords;
    private Pattern invalidIdentifierPattern;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final boolean fineEnabled = this.logger.isLoggable(Level.FINE);
    private final ProgressListener listener;

    public Database(Config config, Connection connection, DatabaseMetaData databaseMetaData, String string, String string2, String string3, SchemaMeta schemaMeta, ProgressListener progressListener) throws SQLException, MissingResourceException {
        this.config = config;
        this.connection = connection;
        this.meta = databaseMetaData;
        this.databaseName = string;
        this.catalog = string2;
        this.schema = string3;
        this.listener = progressListener;
        this.logger.info("Gathering schema details");
        progressListener.startedGatheringDetails();
        this.initTables(databaseMetaData);
        if (config.isViewsEnabled()) {
            this.initViews(databaseMetaData);
        }
        this.initCheckConstraints();
        this.initTableIds();
        this.initIndexIds();
        this.initTableComments();
        this.initTableColumnComments();
        this.initViewComments();
        this.initViewColumnComments();
        this.initColumnTypes();
        this.initRoutines();
        progressListener.startedConnectingTables();
        this.connectTables();
        this.updateFromXmlMetadata(schemaMeta);
    }

    public String getName() {
        return this.databaseName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDescription() {
        return this.config.getDescription();
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public Map<String, Table> getTablesByName() {
        return this.tables;
    }

    public Collection<View> getViews() {
        return this.views.values();
    }

    public Collection<Table> getRemoteTables() {
        return this.remoteTables.values();
    }

    public Collection<Routine> getRoutines() {
        return this.routines.values();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DatabaseMetaData getMetaData() {
        return this.meta;
    }

    public String getConnectTime() {
        return this.connectTime;
    }

    public String getDatabaseProduct() {
        try {
            return this.meta.getDatabaseProductName() + " - " + this.meta.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    private void initTables(DatabaseMetaData databaseMetaData) throws SQLException {
        TableCreator tableCreator;
        Pattern pattern = this.config.getTableInclusions();
        Pattern pattern2 = this.config.getTableExclusions();
        int n = this.config.getMaxDbThreads();
        String[] stringArray = this.getTypes("tableTypes", "TABLE");
        NameValidator nameValidator = new NameValidator("table", pattern, pattern2, stringArray);
        List<BasicTableMeta> list = this.getBasicTableMeta(databaseMetaData, true, stringArray);
        if (n == 1) {
            tableCreator = new TableCreator();
        } else {
            tableCreator = new ThreadedTableCreator(n);
            while (!list.isEmpty()) {
                BasicTableMeta basicTableMeta = list.remove(0);
                if (!nameValidator.isValid(basicTableMeta.name, basicTableMeta.type)) continue;
                new TableCreator().create(basicTableMeta);
                break;
            }
        }
        for (BasicTableMeta basicTableMeta : list) {
            if (!nameValidator.isValid(basicTableMeta.name, basicTableMeta.type)) continue;
            tableCreator.create(basicTableMeta);
        }
        tableCreator.join();
    }

    private void initViews(DatabaseMetaData databaseMetaData) throws SQLException {
        Pattern pattern = this.config.getTableInclusions();
        Pattern pattern2 = this.config.getTableExclusions();
        String[] stringArray = this.getTypes("viewTypes", "VIEW");
        NameValidator nameValidator = new NameValidator("view", pattern, pattern2, stringArray);
        for (BasicTableMeta basicTableMeta : this.getBasicTableMeta(databaseMetaData, false, stringArray)) {
            if (!nameValidator.isValid(basicTableMeta.name, basicTableMeta.type)) continue;
            View view = new View(this, basicTableMeta.catalog, basicTableMeta.schema, basicTableMeta.name, basicTableMeta.remarks, basicTableMeta.viewSql);
            this.views.put(view.getName(), view);
            this.listener.gatheringDetailsProgressed(view);
            if (!this.fineEnabled) continue;
            this.logger.fine("Found details of view " + view.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BasicTableMeta> getBasicTableMeta(DatabaseMetaData databaseMetaData, boolean bl, String ... stringArray) throws SQLException {
        String string;
        String string2;
        String string3;
        Object object;
        String string4;
        String string5 = bl ? "selectTablesSql" : "selectViewsSql";
        String string6 = Config.getInstance().getDbProperties().getProperty(string5);
        ArrayList<BasicTableMeta> arrayList = new ArrayList<BasicTableMeta>();
        ResultSet resultSet = null;
        if (string6 != null) {
            string4 = bl ? "table" : "view";
            object = null;
            try {
                object = this.prepareStatement(string6, null);
                resultSet = object.executeQuery();
                while (resultSet.next()) {
                    string3 = resultSet.getString(string4 + "_name");
                    string2 = this.getOptionalString(resultSet, string4 + "_catalog");
                    string = this.getOptionalString(resultSet, string4 + "_schema");
                    if (string2 == null && string == null) {
                        string = this.schema;
                    }
                    String string7 = this.getOptionalString(resultSet, string4 + "_comment");
                    String string8 = bl ? null : this.getOptionalString(resultSet, "view_definition");
                    String string9 = bl ? this.getOptionalString(resultSet, "table_rows") : null;
                    int n = string9 == null ? -1 : Integer.parseInt(string9);
                    arrayList.add(new BasicTableMeta(string2, string, string3, string4, string7, string8, n));
                }
            }
            catch (SQLException sQLException) {
                string2 = this.listener.recoverableExceptionEncountered("Failed to retrieve " + string4 + " names with custom SQL", sQLException, string6);
                if (string2 != null) {
                    this.logger.warning(string2);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (object != null) {
                    object.close();
                }
            }
        }
        if (arrayList.isEmpty()) {
            resultSet = databaseMetaData.getTables(null, this.schema, "%", stringArray);
            try {
                while (resultSet.next()) {
                    string4 = resultSet.getString("TABLE_NAME");
                    object = resultSet.getString("TABLE_TYPE");
                    string3 = resultSet.getString("TABLE_CAT");
                    string2 = resultSet.getString("TABLE_SCHEM");
                    string = this.getOptionalString(resultSet, "REMARKS");
                    arrayList.add(new BasicTableMeta(string3, string2, string4, (String)object, string, null, -1));
                }
            }
            catch (SQLException sQLException) {
                if (bl) {
                    throw sQLException;
                }
                System.out.flush();
                System.err.println();
                System.err.println("Ignoring view " + resultSet.getString("TABLE_NAME") + " due to exception:");
                sQLException.printStackTrace();
                System.err.println("Continuing analysis.");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        return arrayList;
    }

    private String[] getTypes(String string, String string2) {
        String string3 = this.config.getDbProperties().getProperty(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : string3.split(",")) {
            if ((string4 = string4.trim()).length() <= 0) continue;
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getOptionalString(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCheckConstraints() throws SQLException {
        String string = this.config.getDbProperties().getProperty("selectCheckConstraintsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("table_name");
                    Table table = this.locals.get(string2);
                    if (table == null) continue;
                    table.addCheckConstraint(resultSet.getString("constraint_name"), resultSet.getString("text"));
                }
            }
            catch (SQLException sQLException) {
                String string3 = this.listener.recoverableExceptionEncountered("Failed to retrieve check constraints", sQLException, string);
                if (string3 != null) {
                    this.logger.warning(string3);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumnTypes() throws SQLException {
        String string = this.config.getDbProperties().getProperty("selectColumnTypesSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2;
                    TableColumn tableColumn;
                    String string3 = resultSet.getString("table_name");
                    Table table = this.locals.get(string3);
                    if (table == null || (tableColumn = table.getColumn(string2 = resultSet.getString("column_name"))) == null) continue;
                    tableColumn.setTypeName(resultSet.getString("column_type"));
                    tableColumn.setShortType(this.getOptionalString(resultSet, "short_column_type"));
                }
            }
            catch (SQLException sQLException) {
                String string4 = this.listener.recoverableExceptionEncountered("Failed to retrieve column type details", sQLException, string);
                if (string4 != null) {
                    this.logger.warning(string4);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    private void initTableIds() throws SQLException {
        String string = this.config.getDbProperties().getProperty("selectTableIdsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("table_name");
                    Table table = this.locals.get(string2);
                    if (table == null) continue;
                    table.setId(resultSet.getObject("table_id"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println(string);
                throw sQLException;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    private void initIndexIds() throws SQLException {
        String string = this.config.getDbProperties().getProperty("selectIndexIdsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    TableIndex tableIndex;
                    String string2 = resultSet.getString("table_name");
                    Table table = this.locals.get(string2);
                    if (table == null || (tableIndex = table.getIndex(resultSet.getString("index_name"))) == null) continue;
                    tableIndex.setId(resultSet.getObject("index_id"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println(string);
                throw sQLException;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableComments() throws SQLException {
        String string = this.config.getDbProperties().getProperty("selectTableCommentsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("table_name");
                    Table table = this.locals.get(string2);
                    if (table == null) continue;
                    table.setComments(resultSet.getString("comments"));
                }
            }
            catch (SQLException sQLException) {
                String string3 = this.listener.recoverableExceptionEncountered("Failed to retrieve table/view comments", sQLException, string);
                if (string3 != null) {
                    this.logger.warning(string3);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewComments() throws SQLException {
        String string = this.config.getDbProperties().getProperty("selectViewCommentsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    Table table;
                    String string2 = resultSet.getString("view_name");
                    if (string2 == null) {
                        string2 = resultSet.getString("table_name");
                    }
                    if ((table = (Table)this.views.get(string2)) == null) continue;
                    table.setComments(resultSet.getString("comments"));
                }
            }
            catch (SQLException sQLException) {
                String string3 = this.listener.recoverableExceptionEncountered("Failed to retrieve table/view comments", sQLException, string);
                if (string3 != null) {
                    this.logger.warning(string3);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableColumnComments() throws SQLException {
        String string = this.config.getDbProperties().getProperty("selectColumnCommentsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    TableColumn tableColumn;
                    String string2 = resultSet.getString("table_name");
                    Table table = this.locals.get(string2);
                    if (table == null || (tableColumn = table.getColumn(resultSet.getString("column_name"))) == null) continue;
                    tableColumn.setComments(resultSet.getString("comments"));
                }
            }
            catch (SQLException sQLException) {
                String string3 = this.listener.recoverableExceptionEncountered("Failed to retrieve column comments", sQLException, string);
                if (string3 != null) {
                    this.logger.warning(string3);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewColumnComments() throws SQLException {
        String string = this.config.getDbProperties().getProperty("selectViewColumnCommentsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    TableColumn tableColumn;
                    Table table;
                    String string2 = resultSet.getString("view_name");
                    if (string2 == null) {
                        string2 = resultSet.getString("table_name");
                    }
                    if ((table = (Table)this.views.get(string2)) == null || (tableColumn = table.getColumn(resultSet.getString("column_name"))) == null) continue;
                    tableColumn.setComments(resultSet.getString("comments"));
                }
            }
            catch (SQLException sQLException) {
                String string3 = this.listener.recoverableExceptionEncountered("Failed to retrieve view column comments", sQLException, string);
                if (string3 != null) {
                    this.logger.warning(string3);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRoutines() throws SQLException {
        Object object;
        String string;
        String string2;
        String string3;
        Object object2;
        String string4;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        String string5 = this.config.getDbProperties().getProperty("selectRoutinesSql");
        if (string5 != null) {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string5, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    string4 = resultSet.getString("routine_name");
                    object2 = resultSet.getString("routine_type");
                    string3 = resultSet.getString("dtd_identifier");
                    string2 = resultSet.getString("routine_body");
                    string = resultSet.getString("routine_definition");
                    object = resultSet.getString("sql_data_access");
                    String string6 = resultSet.getString("security_type");
                    boolean bl = resultSet.getBoolean("is_deterministic");
                    String string7 = this.getOptionalString(resultSet, "routine_comment");
                    Routine routine = new Routine(string4, (String)object2, string3, string2, string, bl, (String)object, string6, string7);
                    this.routines.put(string4, routine);
                }
            }
            catch (SQLException sQLException) {
                object2 = this.listener.recoverableExceptionEncountered("Failed to retrieve stored procedure/function details", sQLException, string5);
                if (object2 != null) {
                    this.logger.warning((String)object2);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                resultSet = null;
                preparedStatement = null;
            }
        }
        if ((string5 = this.config.getDbProperties().getProperty("selectRoutineParametersSql")) != null) {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string5, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    string4 = resultSet.getString("specific_name");
                    object2 = this.routines.get(string4);
                    if (object2 == null) continue;
                    string3 = resultSet.getString("parameter_name");
                    string2 = resultSet.getString("dtd_identifier");
                    string = resultSet.getString("parameter_mode");
                    object = new RoutineParameter(string3, string2, string);
                    ((Routine)object2).addParameter((RoutineParameter)object);
                }
            }
            catch (SQLException sQLException) {
                object2 = this.listener.recoverableExceptionEncountered("Failed to retrieve stored procedure/function details", sQLException, string5);
                if (object2 != null) {
                    this.logger.warning((String)object2);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    public PreparedStatement prepareStatement(String string, String string2) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(string);
        List<String> list = this.getSqlParams(stringBuilder, string2);
        if (this.fineEnabled) {
            this.logger.fine(stringBuilder + " " + list);
        }
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(stringBuilder.toString());
        try {
            for (int i = 0; i < list.size(); ++i) {
                preparedStatement.setString(i + 1, list.get(i).toString());
            }
        }
        catch (SQLException sQLException) {
            preparedStatement.close();
            throw sQLException;
        }
        return preparedStatement;
    }

    public Table addRemoteTable(String string, String string2, String string3, String string4, boolean bl) throws SQLException {
        String string5 = this.getRemoteTableKey(string, string2, string3);
        Table table = this.remoteTables.get(string5);
        if (table == null) {
            if (this.fineEnabled) {
                this.logger.fine("Creating remote table " + string5);
            }
            table = bl ? new LogicalRemoteTable(this, string, string2, string3, string4) : new RemoteTable(this, string, string2, string3, string4);
            if (this.fineEnabled) {
                this.logger.fine("Adding remote table " + string5);
            }
            this.remoteTables.put(string5, table);
            table.connectForeignKeys(this.locals);
        }
        return table;
    }

    public Set<String> getSqlKeywords() throws SQLException {
        if (this.sqlKeywords == null) {
            String[] stringArray = "ADA| C | CATALOG_NAME | CHARACTER_SET_CATALOG | CHARACTER_SET_NAME| CHARACTER_SET_SCHEMA | CLASS_ORIGIN | COBOL | COLLATION_CATALOG| COLLATION_NAME | COLLATION_SCHEMA | COLUMN_NAME | COMMAND_FUNCTION | COMMITTED| CONDITION_NUMBER | CONNECTION_NAME | CONSTRAINT_CATALOG | CONSTRAINT_NAME| CONSTRAINT_SCHEMA | CURSOR_NAME| DATA | DATETIME_INTERVAL_CODE | DATETIME_INTERVAL_PRECISION | DYNAMIC_FUNCTION| FORTRAN| LENGTH| MESSAGE_LENGTH | MESSAGE_OCTET_LENGTH | MESSAGE_TEXT | MORE | MUMPS| NAME | NULLABLE | NUMBER| PASCAL | PLI| REPEATABLE | RETURNED_LENGTH | RETURNED_OCTET_LENGTH | RETURNED_SQLSTATE| ROW_COUNT| SCALE | SCHEMA_NAME | SERIALIZABLE | SERVER_NAME | SUBCLASS_ORIGIN| TABLE_NAME | TYPE| UNCOMMITTED | UNNAMED| ABSOLUTE | ACTION | ADD | ALL | ALLOCATE | ALTER | AND| ANY | ARE | AS | ASC| ASSERTION | AT | AUTHORIZATION | AVG| BEGIN | BETWEEN | BIT | BIT_LENGTH | BOTH | BY| CASCADE | CASCADED | CASE | CAST | CATALOG | CHAR | CHARACTER | CHAR_LENGTH| CHARACTER_LENGTH | CHECK | CLOSE | COALESCE | COLLATE | COLLATION| COLUMN | COMMIT | CONNECT | CONNECTION | CONSTRAINT| CONSTRAINTS | CONTINUE| CONVERT | CORRESPONDING | COUNT | CREATE | CROSS | CURRENT| CURRENT_DATE | CURRENT_TIME | CURRENT_TIMESTAMP | CURRENT_USER | CURSOR| DATE | DAY | DEALLOCATE | DEC | DECIMAL | DECLARE | DEFAULT | DEFERRABLE| DEFERRED | DELETE | DESC | DESCRIBE | DESCRIPTOR | DIAGNOSTICS| DISCONNECT | DISTINCT | DOMAIN | DOUBLE | DROP| ELSE | END | END-EXEC | ESCAPE | EXCEPT | EXCEPTION| EXEC | EXECUTE | EXISTS| EXTERNAL | EXTRACT| FALSE | FETCH | FIRST | FLOAT | FOR | FOREIGN | FOUND | FROM | FULL| GET | GLOBAL | GO | GOTO | GRANT | GROUP| HAVING | HOUR| IDENTITY | IMMEDIATE | IN | INDICATOR | INITIALLY | INNER | INPUT| INSENSITIVE | INSERT | INT | INTEGER | INTERSECT | INTERVAL | INTO | IS| ISOLATION| JOIN| KEY| LANGUAGE | LAST | LEADING | LEFT | LEVEL | LIKE | LOCAL | LOWER| MATCH | MAX | MIN | MINUTE | MODULE | MONTH| NAMES | NATIONAL | NATURAL | NCHAR | NEXT | NO | NOT | NULL| NULLIF | NUMERIC| OCTET_LENGTH | OF | ON | ONLY | OPEN | OPTION | OR| ORDER | OUTER| OUTPUT | OVERLAPS| PAD | PARTIAL | POSITION | PRECISION | PREPARE | PRESERVE | PRIMARY| PRIOR | PRIVILEGES | PROCEDURE | PUBLIC| READ | REAL | REFERENCES | RELATIVE | RESTRICT | REVOKE | RIGHT| ROLLBACK | ROWS| SCHEMA | SCROLL | SECOND | SECTION | SELECT | SESSION | SESSION_USER | SET| SIZE | SMALLINT | SOME | SPACE | SQL | SQLCODE | SQLERROR | SQLSTATE| SUBSTRING | SUM | SYSTEM_USER| TABLE | TEMPORARY | THEN | TIME | TIMESTAMP | TIMEZONE_HOUR | TIMEZONE_MINUTE| TO | TRAILING | TRANSACTION | TRANSLATE | TRANSLATION | TRIM | TRUE| UNION | UNIQUE | UNKNOWN | UPDATE | UPPER | USAGE | USER | USING| VALUE | VALUES | VARCHAR | VARYING | VIEW| WHEN | WHENEVER | WHERE | WITH | WORK | WRITE| YEAR| ZONE".split("[| ]+");
            String[] stringArray2 = this.getMetaData().getSQLKeywords().toUpperCase().split(",\\s*");
            this.sqlKeywords = new HashSet<String>(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean contains(Object object) {
                    return super.contains(((String)object).toUpperCase());
                }
            };
            this.sqlKeywords.addAll(Arrays.asList(stringArray));
            this.sqlKeywords.addAll(Arrays.asList(stringArray2));
        }
        return this.sqlKeywords;
    }

    public String getQuotedIdentifier(String string) throws SQLException {
        boolean bl;
        Matcher matcher = this.getInvalidIdentifierPattern().matcher(string);
        boolean bl2 = bl = matcher.find() || this.getSqlKeywords().contains(string);
        if (bl) {
            String string2 = this.getMetaData().getIdentifierQuoteString().trim();
            return string2 + string + string2;
        }
        return string;
    }

    private Pattern getInvalidIdentifierPattern() throws SQLException {
        if (this.invalidIdentifierPattern == null) {
            Object object = "a-zA-Z0-9_";
            String string = "-&^";
            String string2 = this.getMetaData().getExtraNameCharacters();
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (string.indexOf(c) >= 0) {
                    object = (String)object + "\\";
                }
                object = (String)object + c;
            }
            this.invalidIdentifierPattern = Pattern.compile("[^" + (String)object + "]");
        }
        return this.invalidIdentifierPattern;
    }

    private List<String> getSqlParams(StringBuilder stringBuilder, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getSchema();
        if (string2 == null) {
            string2 = this.getName();
        }
        hashMap.put(":schema", string2);
        hashMap.put(":owner", string2);
        if (string != null) {
            hashMap.put(":table", string);
            hashMap.put(":view", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = stringBuilder.indexOf(":");
        while (n != -1) {
            String string3 = new StringTokenizer(stringBuilder.substring(n), " ,\"')").nextToken();
            String string4 = (String)hashMap.get(string3);
            if (string4 == null) {
                throw new InvalidConfigurationException("Unexpected named parameter '" + string3 + "' found in SQL '" + stringBuilder + "'");
            }
            arrayList.add(string4);
            stringBuilder.replace(n, n + string3.length(), "?");
            n = stringBuilder.indexOf(":", n);
        }
        return arrayList;
    }

    private void updateFromXmlMetadata(SchemaMeta schemaMeta) throws SQLException {
        if (schemaMeta != null) {
            Table table;
            this.config.setDescription(schemaMeta.getComments());
            for (TableMeta tableMeta : schemaMeta.getTables()) {
                if (tableMeta.getRemoteSchema() != null || tableMeta.getRemoteCatalog() != null) {
                    table = this.addRemoteTable(tableMeta.getRemoteCatalog(), tableMeta.getRemoteSchema(), tableMeta.getName(), this.getSchema(), true);
                } else {
                    table = this.locals.get(tableMeta.getName());
                    if (table == null) {
                        table = new LogicalTable(this, this.getCatalog(), this.getSchema(), tableMeta.getName(), tableMeta.getComments());
                        this.tables.put(table.getName(), table);
                    }
                }
                table.update(tableMeta);
            }
            for (TableMeta tableMeta : schemaMeta.getTables()) {
                table = tableMeta.getRemoteCatalog() != null || tableMeta.getRemoteSchema() != null ? this.remoteTables.get(this.getRemoteTableKey(tableMeta.getRemoteCatalog(), tableMeta.getRemoteSchema(), tableMeta.getName())) : this.locals.get(tableMeta.getName());
                table.connect(tableMeta, this.locals);
            }
        }
    }

    private void connectTables() throws SQLException {
        for (Table table : this.tables.values()) {
            this.listener.connectingTablesProgressed(table);
            table.connectForeignKeys(this.locals);
        }
        for (Table table : this.views.values()) {
            this.listener.connectingTablesProgressed(table);
            table.connectForeignKeys(this.locals);
        }
    }

    public String getRemoteTableKey(String string, String string2, String string3) {
        return Table.getFullName(this.getName(), string, string2, string3);
    }

    private class CombinedMap
    implements Map<String, Table> {
        private final Map<String, ? extends Table> map1;
        private final Map<String, ? extends Table> map2;

        public CombinedMap(Map<String, ? extends Table> map, Map<String, ? extends Table> map2) {
            this.map1 = map;
            this.map2 = map2;
        }

        @Override
        public Table get(Object object) {
            Table table = this.map1.get(object);
            if (table == null) {
                table = this.map2.get(object);
            }
            return table;
        }

        @Override
        public int size() {
            return this.map1.size() + this.map2.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map1.isEmpty() && this.map2.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.map1.containsKey(object) || this.map2.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.map1.containsValue(object) || this.map2.containsValue(object);
        }

        @Override
        public Table put(String string, Table table) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            return this.getCombined().keySet();
        }

        @Override
        public Set<Map.Entry<String, Table>> entrySet() {
            return this.getCombined().entrySet();
        }

        @Override
        public Collection<Table> values() {
            return this.getCombined().values();
        }

        private Map<String, Table> getCombined() {
            CaseInsensitiveMap<Table> caseInsensitiveMap = new CaseInsensitiveMap<Table>(this.size());
            caseInsensitiveMap.putAll(this.map1);
            caseInsensitiveMap.putAll(this.map2);
            return caseInsensitiveMap;
        }

        @Override
        public Table remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Table> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class ThreadedTableCreator
    extends TableCreator {
        private final Set<Thread> threads;
        private final int maxThreads;

        ThreadedTableCreator(int n) {
            this.threads = new HashSet<Thread>();
            this.maxThreads = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void create(final BasicTableMeta basicTableMeta) throws SQLException {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ThreadedTableCreator.this.createImpl(basicTableMeta);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    finally {
                        Set<Thread> set = ThreadedTableCreator.this.threads;
                        synchronized (set) {
                            ThreadedTableCreator.this.threads.remove(this);
                            ThreadedTableCreator.this.threads.notify();
                        }
                    }
                }
            };
            Set<Thread> set = this.threads;
            synchronized (set) {
                while (this.threads.size() >= this.maxThreads) {
                    try {
                        this.threads.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.threads.add(thread);
            }
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void join() {
            while (true) {
                Thread thread;
                Set<Thread> set = this.threads;
                synchronized (set) {
                    Iterator<Thread> iterator = this.threads.iterator();
                    if (!iterator.hasNext()) {
                        break;
                    }
                    thread = iterator.next();
                }
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class TableCreator {
        private TableCreator() {
        }

        void create(BasicTableMeta basicTableMeta) throws SQLException {
            this.createImpl(basicTableMeta);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void createImpl(BasicTableMeta basicTableMeta) throws SQLException {
            Table table = new Table(Database.this, basicTableMeta.catalog, basicTableMeta.schema, basicTableMeta.name, basicTableMeta.remarks);
            if (basicTableMeta.numRows != -1) {
                table.setNumRows(basicTableMeta.numRows);
            }
            Map<String, Table> map = Database.this.tables;
            synchronized (map) {
                Database.this.tables.put(table.getName(), table);
            }
            Database.this.listener.gatheringDetailsProgressed(table);
            if (Database.this.logger.isLoggable(Level.FINE)) {
                Database.this.logger.fine("Retrieved details of " + table.getFullName());
            }
        }

        void join() {
        }
    }

    private class BasicTableMeta {
        final String catalog;
        final String schema;
        final String name;
        final String type;
        final String remarks;
        final String viewSql;
        final int numRows;

        BasicTableMeta(String string, String string2, String string3, String string4, String string5, String string6, int n) {
            this.catalog = string;
            this.schema = string2;
            this.name = string3;
            this.type = string4;
            this.remarks = string5;
            this.viewSql = string6;
            this.numRows = n;
        }
    }

    class NameValidator {
        private final String clazz;
        private final Pattern include;
        private final Pattern exclude;
        private final Set<String> validTypes;

        NameValidator(String string, Pattern pattern, Pattern pattern2, String[] stringArray) {
            this.clazz = string;
            this.include = pattern;
            this.exclude = pattern2;
            this.validTypes = new HashSet<String>();
            for (String string2 : stringArray) {
                this.validTypes.add(string2.toUpperCase());
            }
        }

        boolean isValid(String string, String string2) {
            if (!this.validTypes.contains(string2.toUpperCase())) {
                return false;
            }
            if (string.indexOf("$") != -1) {
                if (Database.this.fineEnabled) {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + string + ": embedded $ implies illegal name");
                }
                return false;
            }
            if (this.exclude.matcher(string).matches()) {
                if (Database.this.fineEnabled) {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + string + ": matches exclusion pattern \"" + this.exclude + "\"");
                }
                return false;
            }
            boolean bl = this.include.matcher(string).matches();
            if (Database.this.fineEnabled) {
                if (bl) {
                    Database.this.logger.fine("Including " + this.clazz + " " + string + ": matches inclusion pattern \"" + this.include + "\"");
                } else {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + string + ": doesn't match inclusion pattern \"" + this.include + "\"");
                }
            }
            return bl;
        }
    }
}

