/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.util.LineWriter;

public class StyleSheet {
    private static StyleSheet instance;
    private final String css;
    private String bodyBackgroundColor;
    private String tableHeadBackgroundColor;
    private String tableBackgroundColor;
    private String linkColor;
    private String linkVisitedColor;
    private String primaryKeyBackgroundColor;
    private String indexedColumnBackgroundColor;
    private String selectedTableBackgroundColor;
    private String excludedColumnBackgroundColor;
    private final List<String> ids = new ArrayList<String>();

    private StyleSheet(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append(string2);
        }
        this.css = stringBuilder.toString();
        int n = stringBuilder.indexOf("/*");
        while (n != -1) {
            int n2 = stringBuilder.indexOf("*/");
            stringBuilder.replace(n, n2 + 2, "");
            n = stringBuilder.indexOf("/*");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuilder.toString(), "{}");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            if (string3 == null) {
                string3 = string4.toLowerCase();
                this.ids.add(string3);
                continue;
            }
            Map<String, String> map = this.parseAttributes(string4);
            if (string3.equals(".content")) {
                this.bodyBackgroundColor = map.get("background");
            } else if (string3.equals("th")) {
                this.tableHeadBackgroundColor = map.get("background-color");
            } else if (string3.equals("td")) {
                this.tableBackgroundColor = map.get("background-color");
            } else if (string3.equals(".primarykey")) {
                this.primaryKeyBackgroundColor = map.get("background");
            } else if (string3.equals(".indexedcolumn")) {
                this.indexedColumnBackgroundColor = map.get("background");
            } else if (string3.equals(".selectedtable")) {
                this.selectedTableBackgroundColor = map.get("background");
            } else if (string3.equals(".excludedcolumn")) {
                this.excludedColumnBackgroundColor = map.get("background");
            } else if (string3.equals("a:link")) {
                this.linkColor = map.get("color");
            } else if (string3.equals("a:visited")) {
                this.linkVisitedColor = map.get("color");
            }
            string3 = null;
        }
    }

    public static StyleSheet getInstance() throws ParseException {
        if (instance == null) {
            try {
                instance = new StyleSheet(new BufferedReader(StyleSheet.getReader(Config.getInstance().getCss())));
            }
            catch (IOException iOException) {
                throw new ParseException(iOException);
            }
        }
        return instance;
    }

    private static Reader getReader(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            return new FileReader(file);
        }
        file = new File(System.getProperty("user.dir"), string);
        if (file.exists()) {
            return new FileReader(file);
        }
        InputStream inputStream = StyleSheet.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new ParseException("Unable to find requested style sheet: " + string);
        }
        return new InputStreamReader(inputStream);
    }

    private Map<String, String> parseAttributes(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                String string2 = stringTokenizer2.nextToken().trim().toLowerCase();
                String string3 = stringTokenizer2.nextToken().trim().toLowerCase();
                hashMap.put(string2, string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println("Failed to extract attributes from '" + string + "'");
            throw noSuchElementException;
        }
        return hashMap;
    }

    public void write(LineWriter lineWriter) throws IOException {
        lineWriter.write(this.css);
    }

    public String getBodyBackground() {
        if (this.bodyBackgroundColor == null) {
            throw new MissingCssPropertyException(".content", "background");
        }
        return this.bodyBackgroundColor;
    }

    public String getTableBackground() {
        if (this.tableBackgroundColor == null) {
            throw new MissingCssPropertyException("td", "background-color");
        }
        return this.tableBackgroundColor;
    }

    public String getTableHeadBackground() {
        if (this.tableHeadBackgroundColor == null) {
            throw new MissingCssPropertyException("th", "background-color");
        }
        return this.tableHeadBackgroundColor;
    }

    public String getPrimaryKeyBackground() {
        if (this.primaryKeyBackgroundColor == null) {
            throw new MissingCssPropertyException(".primaryKey", "background");
        }
        return this.primaryKeyBackgroundColor;
    }

    public String getIndexedColumnBackground() {
        if (this.indexedColumnBackgroundColor == null) {
            throw new MissingCssPropertyException(".indexedColumn", "background");
        }
        return this.indexedColumnBackgroundColor;
    }

    public String getSelectedTableBackground() {
        if (this.selectedTableBackgroundColor == null) {
            throw new MissingCssPropertyException(".selectedTable", "background");
        }
        return this.selectedTableBackgroundColor;
    }

    public String getExcludedColumnBackgroundColor() {
        if (this.excludedColumnBackgroundColor == null) {
            throw new MissingCssPropertyException(".excludedColumn", "background");
        }
        return this.excludedColumnBackgroundColor;
    }

    public String getLinkColor() {
        if (this.linkColor == null) {
            throw new MissingCssPropertyException("a:link", "color");
        }
        return this.linkColor;
    }

    public String getLinkVisitedColor() {
        if (this.linkVisitedColor == null) {
            throw new MissingCssPropertyException("a:visited", "color");
        }
        return this.linkVisitedColor;
    }

    public static class ParseException
    extends InvalidConfigurationException {
        private static final long serialVersionUID = 1L;

        public ParseException(Exception exception) {
            super(exception);
        }

        public ParseException(String string) {
            super(string);
        }
    }

    public static class MissingCssPropertyException
    extends InvalidConfigurationException {
        private static final long serialVersionUID = 1L;

        public MissingCssPropertyException(String string, String string2) {
            super("Required property '" + string2 + "' was not found for the definition of '" + string + "' in " + Config.getInstance().getCss());
        }
    }
}

