/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.simulation;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.action.RoutingReportActionToTake;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class SimulationActionToTake
implements Serializable {
    private static final long serialVersionUID = 5212455086079117671L;
    private String actionToPerform;
    private Person user;
    private String nodeName;

    public String getActionToPerform() {
        return this.actionToPerform;
    }

    public void setActionToPerform(String actionToPerform) {
        this.actionToPerform = actionToPerform;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Person getUser() {
        return this.user;
    }

    public void setUser(Person user) {
        this.user = user;
    }

    public static SimulationActionToTake from(RoutingReportActionToTake actionToTake) {
        if (actionToTake == null) {
            return null;
        }
        SimulationActionToTake simActionToTake = new SimulationActionToTake();
        simActionToTake.setNodeName(actionToTake.getNodeName());
        if (StringUtils.isBlank((String)actionToTake.getActionToPerform())) {
            throw new IllegalArgumentException("ReportActionToTakeVO must contain an action taken code and does not");
        }
        simActionToTake.setActionToPerform(actionToTake.getActionToPerform());
        if (actionToTake.getPrincipalId() == null) {
            throw new IllegalArgumentException("ReportActionToTakeVO must contain a principalId and does not");
        }
        Principal kPrinc = KEWServiceLocator.getIdentityHelperService().getPrincipal(actionToTake.getPrincipalId());
        Person user = KimApiServiceLocator.getPersonService().getPerson(kPrinc.getPrincipalId());
        if (user == null) {
            throw new IllegalStateException("Could not locate Person for the given id: " + actionToTake.getPrincipalId());
        }
        simActionToTake.setUser(user);
        return simActionToTake;
    }
}

