/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.inquiry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.util.UrlFactory;

public class GroupInquirableImpl
extends KualiInquirableImpl {
    protected final String GROUP_NAME = "name";
    protected final String GROUP_ID = "id";
    protected final String NAMESPACE_CODE = "namespaceCode";

    public void buildInquirableLink(Object dataObject, String propertyName, Inquiry inquiry) {
        if ("name".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("id", "id");
            inquiry.buildInquiryLink(dataObject, propertyName, GroupBo.class, primaryKeys);
        } else if ("namespaceCode".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put(propertyName, "code");
            inquiry.buildInquiryLink(dataObject, propertyName, NamespaceBo.class, primaryKeys);
        } else if ("kimTypeInfo.name".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("kimTypeInfo.id", "id");
            inquiry.buildInquiryLink(dataObject, propertyName, KimTypeBo.class, primaryKeys);
        }
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if ("name".equals(attributeName)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            primaryKeys.add("id");
            String href = this.getInquiryUrlForPrimaryKeys(GroupBo.class, businessObject, primaryKeys, null).getHref();
            HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
            htmlData.setHref(this.getCustomGroupInquiryHref(href));
            return htmlData;
        }
        if ("namespaceCode".equals(attributeName)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            primaryKeys.add("code");
            String code = (String)KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject).getPropertyValueNullSafe(attributeName);
            NamespaceBo parameterNamespace = new NamespaceBo();
            parameterNamespace.setCode(code);
            return this.getInquiryUrlForPrimaryKeys(NamespaceBo.class, parameterNamespace, primaryKeys, null);
        }
        if ("kimTypeInfo.name".equals(attributeName)) {
            KimTypeBo kimType = new KimTypeBo();
            kimType.setId(((GroupBo)businessObject).getKimTypeId());
            return this.getInquiryUrlForPrimaryKeys(KimTypeBo.class, kimType, Collections.singletonList("id"), null);
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

    public String getCustomGroupInquiryHref(String href) {
        Properties parameters = new Properties();
        String hrefPart = "";
        if (StringUtils.isNotBlank((String)href) && href.contains("&id=")) {
            int idx1 = href.indexOf("&id=");
            int idx2 = href.indexOf("&", idx1 + 1);
            if (idx2 < 0) {
                idx2 = href.length();
            }
            parameters.put("methodToCall", "inquiry");
            hrefPart = href.substring(idx1, idx2);
        }
        return UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + "identityManagementGroupInquiry.do"), (Properties)parameters) + hrefPart;
    }

    public BusinessObject getBusinessObject(Map fieldValues) {
        BusinessObject bo = super.getBusinessObject(fieldValues);
        return bo;
    }
}

