/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class NamingLocator {
    private static Logger log = LoggerFactory.getLogger(NamingLocator.class);
    private static Context ctx = null;
    private static Properties prop;

    public static Context getContext() {
        if (ctx == null) {
            try {
                NamingLocator.setContext(null);
            }
            catch (Exception exception) {
                log.error("Cannot instantiate the InitialContext", exception);
                throw new OJBRuntimeException(exception);
            }
        }
        return ctx;
    }

    public static Object lookup(String string) {
        if (log.isDebugEnabled()) {
            log.debug("lookup(" + string + ") was called");
        }
        try {
            return NamingLocator.getContext().lookup(string);
        }
        catch (NamingException namingException) {
            throw new OJBRuntimeException("Lookup failed for: " + string, namingException);
        }
        catch (OJBRuntimeException oJBRuntimeException) {
            throw oJBRuntimeException;
        }
    }

    public static void refresh() {
        try {
            NamingLocator.setContext(prop);
        }
        catch (NamingException namingException) {
            log.error("Unable to refresh the naming context");
            throw new OJBRuntimeException("Refresh of context failed, used properties: " + (prop != null ? prop.toString() : "none"), namingException);
        }
    }

    public static synchronized void setContext(Properties properties) throws NamingException {
        log.info("Instantiate naming context, properties: " + properties);
        ctx = properties != null ? new InitialContext(properties) : new InitialContext();
        prop = properties;
    }
}

