/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.io.Serializable;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldBase;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldDirectImpl;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldDynaBeanImpl;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldIntrospectorImpl;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldPrivilegedImpl;
import org.apache.ojb.broker.util.ClassHelper;

public class PersistentFieldAutoProxyImpl
extends PersistentFieldBase {
    static final long serialVersionUID = 6286229945422476325L;
    protected Class[] persistentFieldClasses = new Class[]{PersistentFieldDirectImpl.class, PersistentFieldIntrospectorImpl.class, PersistentFieldPrivilegedImpl.class, PersistentFieldDynaBeanImpl.class};
    private PersistentField currentPF;
    private ExceptionWrapper latestException;
    int index = 0;

    public PersistentFieldAutoProxyImpl() {
    }

    public PersistentFieldAutoProxyImpl(Class clazz, String string) {
        super(clazz, string);
    }

    private PersistentField getCurrent() {
        if (this.currentPF == null) {
            if (this.index >= this.persistentFieldClasses.length) {
                this.index = 0;
                this.currentPF = null;
                throw new AutoDetectException("Can't autodetect valid PersistentField implementation: " + this.latestException.message, this.latestException.exception);
            }
            try {
                this.currentPF = this.createPersistentFieldForIndex();
            }
            catch (Exception exception) {
                throw new AutoDetectException("Can't create instance for " + this.persistentFieldClasses[this.index], exception);
            }
        }
        return this.currentPF;
    }

    private void handleException(String string, Exception exception) {
        this.latestException = new ExceptionWrapper(string, exception);
        this.currentPF = null;
        ++this.index;
    }

    @Override
    public Object get(Object object) throws MetadataException {
        try {
            return this.getCurrent().get(object);
        }
        catch (Exception exception) {
            if (exception instanceof AutoDetectException) {
                throw (MetadataException)((Object)exception);
            }
            this.handleException("Can't extract field value for field " + this.getName() + " from object " + (object != null ? object.getClass() : null), exception);
            return this.get(object);
        }
    }

    @Override
    public void set(Object object, Object object2) throws MetadataException {
        try {
            this.getCurrent().set(object, object2);
        }
        catch (Exception exception) {
            if (exception instanceof AutoDetectException) {
                throw (MetadataException)((Object)exception);
            }
            this.handleException("Can't set value for field " + this.getName() + " to object " + (object != null ? object.getClass() : null), exception);
            this.set(object, object2);
        }
    }

    @Override
    public Class getType() {
        try {
            return this.getCurrent().getType();
        }
        catch (Exception exception) {
            if (exception instanceof AutoDetectException) {
                throw (MetadataException)((Object)exception);
            }
            this.handleException("Can't identify field type for field " + this.getName(), null);
            return this.getType();
        }
    }

    @Override
    protected boolean makeAccessible() {
        return false;
    }

    @Override
    public boolean usesAccessorsAndMutators() {
        return false;
    }

    private PersistentField createPersistentFieldForIndex() throws Exception {
        return this.newInstance(this.persistentFieldClasses[this.index]);
    }

    private PersistentField newInstance(Class clazz) throws Exception {
        Class[] classArray = new Class[]{Class.class, String.class};
        Object[] objectArray = new Object[]{this.getDeclaringClass(), this.getName()};
        return (PersistentField)ClassHelper.newInstance(clazz, classArray, objectArray);
    }

    static class AutoDetectException
    extends MetadataException {
        private static final long serialVersionUID = 3257290223049585970L;

        public AutoDetectException() {
        }

        public AutoDetectException(Throwable throwable) {
            super(throwable);
        }

        public AutoDetectException(String string) {
            super(string);
        }

        public AutoDetectException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    static class ExceptionWrapper
    implements Serializable {
        private static final long serialVersionUID = 3691042088451912249L;
        Exception exception;
        String message;

        public ExceptionWrapper(String string, Exception exception) {
            this.message = string;
            this.exception = exception;
        }
    }
}

