/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.model.View;
import net.sourceforge.schemaspy.util.CaseInsensitiveMap;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.HtmlEncoder;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.DotFormatter;
import net.sourceforge.schemaspy.view.HtmlColumnsPage;
import net.sourceforge.schemaspy.view.HtmlFormatter;
import net.sourceforge.schemaspy.view.HtmlTableDiagrammer;
import net.sourceforge.schemaspy.view.WriteStats;

public class HtmlTablePage
extends HtmlFormatter {
    private static final HtmlTablePage instance = new HtmlTablePage();
    private int columnCounter = 0;
    private final Map<String, String> defaultValueAliases = new HashMap<String, String>();

    private HtmlTablePage() {
        this.defaultValueAliases.put("CURRENT TIMESTAMP", "now");
        this.defaultValueAliases.put("CURRENT TIME", "now");
        this.defaultValueAliases.put("CURRENT DATE", "now");
        this.defaultValueAliases.put("SYSDATE", "now");
        this.defaultValueAliases.put("CURRENT_DATE", "now");
    }

    public static HtmlTablePage getInstance() {
        return instance;
    }

    public WriteStats write(Database database, Table table, File file, WriteStats writeStats, LineWriter lineWriter) throws IOException {
        File file2 = new File(file, "diagrams");
        boolean bl = this.generateDots(table, file2, writeStats);
        this.writeHeader(database, table, null, lineWriter);
        lineWriter.writeln("<table width='100%' border='0'>");
        lineWriter.writeln("<tr valign='top'><td class='container' align='left' valign='top'>");
        this.writeHeader(table, bl, lineWriter);
        lineWriter.writeln("</td><td class='container' rowspan='2' align='right' valign='top'>");
        this.writeLegend(true, lineWriter);
        lineWriter.writeln("</td><tr valign='top'><td class='container' align='left' valign='top'>");
        this.writeMainTable(table, lineWriter);
        this.writeNumRows(database, table, lineWriter);
        lineWriter.writeln("</td></tr></table>");
        this.writeCheckConstraints(table, lineWriter);
        this.writeIndexes(table, lineWriter);
        this.writeView(table, database, lineWriter);
        this.writeDiagram(table, writeStats, file2, lineWriter);
        this.writeFooter(lineWriter);
        return writeStats;
    }

    private void writeHeader(Table table, boolean bl, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<form name='options' action=''>");
        if (bl) {
            lineWriter.write(" <label for='implied'><input type=checkbox id='implied'");
            if (table.isOrphan(false)) {
                lineWriter.write(" checked");
            }
            lineWriter.writeln(">Implied relationships</label>");
        }
        boolean bl2 = false;
        for (TableColumn tableColumn : table.getColumns()) {
            if (tableColumn.getComments() == null) continue;
            bl2 = true;
            break;
        }
        lineWriter.writeln(" <label for='showRelatedCols'><input type=checkbox id='showRelatedCols'>Related columns</label>");
        lineWriter.writeln(" <label for='showConstNames'><input type=checkbox id='showConstNames'>Constraints</label>");
        lineWriter.writeln(" <label for='showComments'><input type=checkbox " + (bl2 ? "checked " : "") + "id='showComments'>Comments</label>");
        lineWriter.writeln(" <label for='showLegend'><input type=checkbox checked id='showLegend'>Legend</label>");
        lineWriter.writeln("</form>");
    }

    public void writeMainTable(Table table, LineWriter lineWriter) throws IOException {
        HtmlColumnsPage.getInstance().writeMainTableHeader(table.getId() != null, null, lineWriter);
        lineWriter.writeln("<tbody valign='top'>");
        HashSet<TableColumn> hashSet = new HashSet<TableColumn>(table.getPrimaryColumns());
        HashSet<TableColumn> hashSet2 = new HashSet<TableColumn>();
        for (TableIndex object : table.getIndexes()) {
            hashSet2.addAll(object.getColumns());
        }
        boolean bl = table.getId() != null;
        for (TableColumn tableColumn : table.getColumns()) {
            this.writeColumn(tableColumn, null, hashSet, hashSet2, false, bl, lineWriter);
        }
        lineWriter.writeln("</tbody>");
        lineWriter.writeln("</table>");
    }

    public void writeColumn(TableColumn tableColumn, String string, Set<TableColumn> set, Set<TableColumn> set2, boolean bl, boolean bl2, LineWriter lineWriter) throws IOException {
        String string2;
        boolean bl3;
        boolean bl4 = bl3 = this.columnCounter++ % 2 == 0;
        if (bl3) {
            lineWriter.writeln("<tr class='even'>");
        } else {
            lineWriter.writeln("<tr class='odd'>");
        }
        if (bl2) {
            lineWriter.write(" <td class='detail' align='right'>");
            lineWriter.write(String.valueOf(tableColumn.getId()));
            lineWriter.writeln("</td>");
        }
        if (string != null) {
            lineWriter.write(" <td class='detail'><a href='tables/");
            lineWriter.write(HtmlTablePage.urlEncode(string));
            lineWriter.write(".html'>");
            lineWriter.write(string);
            lineWriter.writeln("</a></td>");
        }
        if (set.contains(tableColumn)) {
            lineWriter.write(" <td class='primaryKey' title='Primary Key'>");
        } else if (set2.contains(tableColumn)) {
            lineWriter.write(" <td class='indexedColumn' title='Indexed'>");
        } else {
            lineWriter.write(" <td class='detail'>");
        }
        lineWriter.write(tableColumn.getName());
        lineWriter.writeln("</td>");
        lineWriter.write(" <td class='detail'>");
        lineWriter.write(tableColumn.getTypeName().toLowerCase());
        lineWriter.writeln("</td>");
        lineWriter.write(" <td class='detail' align='right'>");
        lineWriter.write(tableColumn.getDetailedSize());
        lineWriter.writeln("</td>");
        lineWriter.write(" <td class='detail' align='center'");
        if (tableColumn.isNullable()) {
            lineWriter.write(" title='nullable'>&nbsp;&radic;&nbsp;");
        } else {
            lineWriter.write(">");
        }
        lineWriter.writeln("</td>");
        lineWriter.write(" <td class='detail' align='center'");
        if (tableColumn.isAutoUpdated()) {
            lineWriter.write(" title='Automatically updated by the database'>&nbsp;&radic;&nbsp;");
        } else {
            lineWriter.write(">");
        }
        lineWriter.writeln("</td>");
        Object object = tableColumn.getDefaultValue();
        if (object != null || tableColumn.isNullable()) {
            string2 = this.defaultValueAliases.get(String.valueOf(object).trim());
            if (string2 != null) {
                lineWriter.write(" <td class='detail' align='right' title='");
                lineWriter.write(String.valueOf(object));
                lineWriter.write("'><i>");
                lineWriter.write(string2.toString());
                lineWriter.writeln("</i></td>");
            } else {
                lineWriter.write(" <td class='detail' align='right'>");
                lineWriter.write(String.valueOf(object));
                lineWriter.writeln("</td>");
            }
        } else {
            lineWriter.writeln(" <td class='detail'></td>");
        }
        if (!bl) {
            lineWriter.write(" <td class='detail'>");
            string2 = string == null ? "" : "tables/";
            this.writeRelatives(tableColumn, false, string2, bl3, lineWriter);
            lineWriter.writeln("</td>");
            lineWriter.write(" <td class='detail'>");
            this.writeRelatives(tableColumn, true, string2, bl3, lineWriter);
            lineWriter.writeln(" </td>");
        }
        lineWriter.write(" <td class='comment detail'>");
        string2 = tableColumn.getComments();
        if (string2 != null) {
            if (this.encodeComments) {
                for (int i = 0; i < string2.length(); ++i) {
                    lineWriter.write(HtmlEncoder.encodeToken(string2.charAt(i)));
                }
            } else {
                lineWriter.write(string2);
            }
        }
        lineWriter.writeln("</td>");
        lineWriter.writeln("</tr>");
    }

    private void writeRelatives(TableColumn tableColumn, boolean bl, String string, boolean bl2, LineWriter lineWriter) throws IOException {
        String string2;
        Set<TableColumn> set = bl ? tableColumn.getParents() : tableColumn.getChildren();
        int n = set.size();
        String string3 = string2 = bl2 ? "even" : "odd";
        if (n > 0) {
            lineWriter.newLine();
            lineWriter.writeln("  <table border='0' width='100%' cellspacing='0' cellpadding='0'>");
        }
        for (TableColumn tableColumn2 : set) {
            ForeignKeyConstraint foreignKeyConstraint;
            Table table = tableColumn2.getTable();
            String string4 = table.getName();
            ForeignKeyConstraint foreignKeyConstraint2 = foreignKeyConstraint = bl ? tableColumn2.getChildConstraint(tableColumn) : tableColumn2.getParentConstraint(tableColumn);
            if (foreignKeyConstraint.isImplied()) {
                lineWriter.writeln("   <tr class='impliedRelationship relative " + string2 + "' valign='top'>");
            } else {
                lineWriter.writeln("   <tr class='relative " + string2 + "' valign='top'>");
            }
            lineWriter.write("    <td class='relatedTable detail' title=\"");
            lineWriter.write(foreignKeyConstraint.toString());
            lineWriter.write("\">");
            if (table.isRemote() && !Config.getInstance().isOneOfMultipleSchemas()) {
                lineWriter.write(table.getContainer());
                lineWriter.write(46);
                lineWriter.write(string4);
            } else {
                if (table.isRemote()) {
                    lineWriter.write("<a href='");
                    lineWriter.write(string);
                    lineWriter.write("../../" + HtmlTablePage.urlEncode(table.getContainer()) + "/index.html'>");
                    lineWriter.write(table.getContainer());
                    lineWriter.write("</a>.");
                }
                lineWriter.write("<a href='");
                lineWriter.write(string);
                if (table.isRemote()) {
                    lineWriter.write("../../" + HtmlTablePage.urlEncode(table.getContainer()) + "/tables/");
                }
                lineWriter.write(HtmlTablePage.urlEncode(string4));
                lineWriter.write(".html'>");
                lineWriter.write(string4);
                lineWriter.write("</a>");
            }
            lineWriter.write("<span class='relatedKey'>.");
            lineWriter.write(tableColumn2.getName());
            lineWriter.writeln("</span>");
            lineWriter.writeln("    </td>");
            lineWriter.write("    <td class='constraint detail'>");
            lineWriter.write(foreignKeyConstraint.getName());
            String string5 = foreignKeyConstraint.getDeleteRuleDescription();
            if (string5.length() > 0) {
                String string6 = foreignKeyConstraint.getDeleteRuleAlias();
                lineWriter.write("<span title='" + string5 + "'>&nbsp;" + string6 + "</span>");
            }
            lineWriter.writeln("</td>");
            lineWriter.writeln("   </tr>");
        }
        if (n > 0) {
            lineWriter.writeln("  </table>");
        }
    }

    private void writeNumRows(Database database, Table table, LineWriter lineWriter) throws IOException {
        lineWriter.write("<p title='" + table.getColumns().size() + " columns'>");
        if (this.displayNumRows && table.getNumRows() >= 0L) {
            lineWriter.write("Table contained " + NumberFormat.getIntegerInstance().format(table.getNumRows()) + " rows at ");
        } else {
            lineWriter.write("Analyzed at ");
        }
        lineWriter.write(database.getConnectTime());
        lineWriter.writeln("<p/>");
    }

    private void writeCheckConstraints(Table table, LineWriter lineWriter) throws IOException {
        Map<String, String> map = table.getCheckConstraints();
        if (map != null && !map.isEmpty()) {
            lineWriter.writeln("<div class='indent'>");
            lineWriter.writeln("<b>Requirements (check constraints):</b>");
            lineWriter.writeln("<table class='dataTable' border='1' rules='groups'><colgroup><colgroup>");
            lineWriter.writeln("<thead>");
            lineWriter.writeln(" <tr>");
            lineWriter.writeln("  <th>Constraint</th>");
            lineWriter.writeln("  <th class='constraint' style='text-align:left;'>Constraint Name</th>");
            lineWriter.writeln(" </tr>");
            lineWriter.writeln("</thead>");
            lineWriter.writeln("<tbody>");
            for (String string : map.keySet()) {
                lineWriter.writeln(" <tr>");
                lineWriter.write("  <td class='detail'>");
                lineWriter.write(HtmlEncoder.encodeString(map.get(string).toString()));
                lineWriter.writeln("</td>");
                lineWriter.write("  <td class='constraint' style='text-align:left;'>");
                lineWriter.write(string);
                lineWriter.writeln("</td>");
                lineWriter.writeln(" </tr>");
            }
            lineWriter.writeln("</tbody>");
            lineWriter.writeln("</table></div><p>");
        }
    }

    private void writeIndexes(Table table, LineWriter lineWriter) throws IOException {
        boolean bl = table.getId() != null;
        Set<TableIndex> set = table.getIndexes();
        if (set != null && !set.isEmpty()) {
            lineWriter.writeln("<div class='indent'>");
            lineWriter.writeln("<b>Indexes:</b>");
            lineWriter.writeln("<table class='dataTable' border='1' rules='groups'><colgroup><colgroup><colgroup><colgroup>" + (bl ? "<colgroup>" : ""));
            lineWriter.writeln("<thead>");
            lineWriter.writeln(" <tr>");
            if (bl) {
                lineWriter.writeln("  <th>ID</th>");
            }
            lineWriter.writeln("  <th>Column(s)</th>");
            lineWriter.writeln("  <th>Type</th>");
            lineWriter.writeln("  <th>Sort</th>");
            lineWriter.writeln("  <th class='constraint' style='text-align:left;'>Constraint Name</th>");
            lineWriter.writeln(" </tr>");
            lineWriter.writeln("</thead>");
            lineWriter.writeln("<tbody>");
            set = new TreeSet<TableIndex>(set);
            for (TableIndex tableIndex : set) {
                lineWriter.writeln(" <tr>");
                if (bl) {
                    lineWriter.write("  <td class='detail' align='right'>");
                    lineWriter.write(String.valueOf(tableIndex.getId()));
                    lineWriter.writeln("</td>");
                }
                if (tableIndex.isPrimaryKey()) {
                    lineWriter.write("  <td class='primaryKey'>");
                } else {
                    lineWriter.write("  <td class='indexedColumn'>");
                }
                String string = tableIndex.getColumnsAsString();
                if (string.startsWith("+")) {
                    string = string.substring(1);
                }
                lineWriter.write(string);
                lineWriter.writeln("</td>");
                lineWriter.write("  <td class='detail'>");
                lineWriter.write(tableIndex.getType());
                lineWriter.writeln("</td>");
                lineWriter.write("  <td class='detail' style='text-align:left;'>");
                Iterator<TableColumn> iterator = tableIndex.getColumns().iterator();
                while (iterator.hasNext()) {
                    TableColumn tableColumn = iterator.next();
                    if (tableIndex.isAscending(tableColumn)) {
                        lineWriter.write("<span title='Ascending'>Asc</span>");
                    } else {
                        lineWriter.write("<span title='Descending'>Desc</span>");
                    }
                    if (!iterator.hasNext()) continue;
                    lineWriter.write("/");
                }
                lineWriter.writeln("</td>");
                lineWriter.write("  <td class='constraint' style='text-align:left;'>");
                lineWriter.write(tableIndex.getName());
                lineWriter.writeln("</td>");
                lineWriter.writeln(" </tr>");
            }
            lineWriter.writeln("</tbody>");
            lineWriter.writeln("</table>");
            lineWriter.writeln("</div>");
        }
    }

    private void writeView(Table table, Database database, LineWriter lineWriter) throws IOException {
        String string;
        if (table.isView() && (string = table.getViewSql()) != null) {
            CaseInsensitiveMap<Table> caseInsensitiveMap = new CaseInsensitiveMap<Table>();
            for (Table object2 : database.getTables()) {
                caseInsensitiveMap.put(object2.getName(), object2);
            }
            for (View view : database.getViews()) {
                caseInsensitiveMap.put(view.getName(), (Table)view);
            }
            TreeSet treeSet = new TreeSet();
            String string2 = Config.getInstance().getSqlFormatter().format(string, database, treeSet);
            lineWriter.writeln("<div class='indent spacer'>");
            lineWriter.writeln("  <b>View Definition:</b><br/>");
            lineWriter.writeln(string2);
            lineWriter.writeln("</div>");
            lineWriter.writeln("<div class='spacer'>&nbsp;</div>");
            if (!treeSet.isEmpty()) {
                lineWriter.writeln("<div class='indent'>");
                lineWriter.writeln("  Possibly Referenced Tables/Views:");
                lineWriter.writeln("  <div class='viewReferences'>");
                lineWriter.write("  ");
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    Table table2 = (Table)iterator.next();
                    lineWriter.write("<a href='");
                    lineWriter.write(HtmlTablePage.urlEncode(table2.getName()));
                    lineWriter.write(".html'>");
                    lineWriter.write(table2.getName());
                    lineWriter.write("</a>&nbsp;");
                }
                lineWriter.writeln("  </div>");
                lineWriter.writeln("</div><p/>");
            }
        }
    }

    private boolean generateDots(Table table, File file, WriteStats writeStats) throws IOException {
        Dot dot = Dot.getInstance();
        String string = dot == null ? "png" : dot.getFormat();
        File file2 = new File(file, table.getName() + ".1degree.dot");
        File file3 = new File(file, table.getName() + ".1degree." + string);
        File file4 = new File(file, table.getName() + ".2degrees.dot");
        File file5 = new File(file, table.getName() + ".2degrees." + string);
        File file6 = new File(file, table.getName() + ".implied2degrees.dot");
        File file7 = new File(file, table.getName() + ".implied2degrees." + string);
        file2.delete();
        file3.delete();
        file4.delete();
        file5.delete();
        file6.delete();
        file7.delete();
        if (table.getMaxChildren() + table.getMaxParents() > 0) {
            DotFormatter dotFormatter = DotFormatter.getInstance();
            LineWriter lineWriter = new LineWriter(file2, "UTF-8");
            WriteStats writeStats2 = new WriteStats(writeStats);
            dotFormatter.writeRealRelationships(table, false, writeStats2, lineWriter);
            lineWriter.close();
            lineWriter = new LineWriter(file4, "UTF-8");
            WriteStats writeStats3 = new WriteStats(writeStats);
            Set<ForeignKeyConstraint> set = dotFormatter.writeRealRelationships(table, true, writeStats3, lineWriter);
            lineWriter.close();
            if (writeStats2.getNumTablesWritten() + writeStats2.getNumViewsWritten() == writeStats3.getNumTablesWritten() + writeStats3.getNumViewsWritten()) {
                file4.delete();
            }
            if (!set.isEmpty()) {
                lineWriter = new LineWriter(file6, "UTF-8");
                dotFormatter.writeAllRelationships(table, true, writeStats, lineWriter);
                lineWriter.close();
                return true;
            }
        }
        return false;
    }

    private void writeDiagram(Table table, WriteStats writeStats, File file, LineWriter lineWriter) throws IOException {
        if (table.getMaxChildren() + table.getMaxParents() > 0) {
            lineWriter.writeln("<table width='100%' border='0'><tr><td class='container'>");
            if (HtmlTableDiagrammer.getInstance().write(table, file, lineWriter)) {
                lineWriter.writeln("</td></tr></table>");
                this.writeExcludedColumns(writeStats.getExcludedColumns(), table, lineWriter);
            } else {
                lineWriter.writeln("</td></tr></table><p>");
                this.writeInvalidGraphvizInstallation(lineWriter);
            }
        }
    }

    @Override
    protected String getPathToRoot() {
        return "../";
    }
}

