/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.config.property;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.core.framework.config.property.AbstractBaseConfig;
import org.kuali.rice.core.impl.config.property.Config;
import org.kuali.rice.core.impl.config.property.ConfigLogger;
import org.kuali.rice.core.impl.config.property.Param;
import org.kuali.rice.core.util.ImmutableProperties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public final class JAXBConfigImpl
extends AbstractBaseConfig {
    private static final Logger LOG = LogManager.getLogger(JAXBConfigImpl.class);
    private static final String IMPORT_NAME = "config.location";
    private static final String INDENT = "  ";
    private static final String PLACEHOLDER_REGEX = "\\$\\{([^{}]+)\\}";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([^{}]+)\\}");
    private static final Random RANDOM = new Random();
    private final List<String> fileLocs = new ArrayList<String>();
    private final Map<String, Object> objects = new LinkedHashMap<String, Object>();
    private final Properties rawProperties = new Properties();
    private final Properties resolvedProperties = new Properties();
    private boolean systemOverride;

    public JAXBConfigImpl() {
    }

    public JAXBConfigImpl(org.kuali.rice.core.api.config.property.Config config) {
        this.copyConfig(config);
    }

    public JAXBConfigImpl(String fileLoc, org.kuali.rice.core.api.config.property.Config config) {
        this.copyConfig(config);
        this.fileLocs.add(fileLoc);
    }

    public JAXBConfigImpl(List<String> fileLocs, org.kuali.rice.core.api.config.property.Config config) {
        this.copyConfig(config);
        this.fileLocs.addAll(fileLocs);
    }

    public JAXBConfigImpl(String fileLoc) {
        this.fileLocs.add(fileLoc);
    }

    public JAXBConfigImpl(List<String> fileLocs) {
        this.fileLocs.addAll(fileLocs);
    }

    public JAXBConfigImpl(Properties properties) {
        this.putProperties(properties);
    }

    public JAXBConfigImpl(String fileLoc, Properties properties) {
        this.fileLocs.add(fileLoc);
        this.putProperties(properties);
    }

    public JAXBConfigImpl(List<String> fileLocs, Properties properties) {
        this.fileLocs.addAll(fileLocs);
        this.putProperties(properties);
    }

    private void copyConfig(org.kuali.rice.core.api.config.property.Config config) {
        if (config == null) {
            return;
        }
        this.putProperties(config.getProperties());
        if (config.getObjects() != null) {
            this.objects.putAll(config.getObjects());
        }
    }

    public Object getObject(String key) {
        return this.objects.get(key);
    }

    public Map<String, Object> getObjects() {
        return Collections.unmodifiableMap(this.objects);
    }

    public Properties getProperties() {
        return new ImmutableProperties(this.resolvedProperties);
    }

    public String getProperty(String key) {
        return this.resolvedProperties.getProperty(key);
    }

    Properties getRawProperties() {
        return new ImmutableProperties(this.rawProperties);
    }

    public void putProperty(String key, String value) {
        this.setProperty(key, this.replaceVariable(key, value));
        this.resolveRawToCache();
    }

    public void putProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        this.replaceVariables(properties);
        this.resolveRawToCache();
    }

    private void replaceVariables(Properties properties) {
        this.replaceVariables("", properties);
    }

    private void replaceVariables(String prefix, Properties properties) {
        TreeSet<String> keys = new TreeSet<String>(properties.stringPropertyNames());
        for (String key : keys) {
            String originalValue = properties.getProperty(key);
            String replacedValue = this.replaceVariable(key, originalValue);
            this.logPropertyChange("", key, null, originalValue, replacedValue);
            this.setProperty(prefix, key, replacedValue);
        }
    }

    Unmarshaller getUnmarshaller() {
        try {
            Class<Config> c = Config.class;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{c});
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new ConfigurationException("Error initializing JAXB for config", (Throwable)e);
        }
    }

    public void parseConfig() throws IOException {
        LOG.info("----------------Loading Rice Configuration----------------");
        if (this.fileLocs.isEmpty()) {
            LOG.info("No config files specified");
            return;
        }
        Unmarshaller unmarshaller = this.getUnmarshaller();
        this.configureBuiltIns();
        for (String s : this.fileLocs) {
            this.parseConfig(s, unmarshaller, 0);
        }
        this.resolveRawToCache();
        LOG.info("----------------Rice Configuration Loaded-----------------");
        this.logPropertyValues(this.resolvedProperties);
    }

    private void logPropertyValues(Properties p) {
        LOG.info("Loaded " + p.size() + " properties");
        if (LOG.isDebugEnabled()) {
            String s = this.getPropertyValuesAsString(p);
            LOG.debug("Displaying " + p.size() + " properties\n\n" + s + "\n");
        }
    }

    String getPropertyValuesAsString(Properties p) {
        StringBuilder sb = new StringBuilder();
        TreeSet<String> keys = new TreeSet<String>(p.stringPropertyNames());
        for (String key : keys) {
            String rawValue = p.getProperty(key);
            String logValue = this.flatten(ConfigLogger.getDisplaySafeValue(key, rawValue));
            sb.append(key);
            sb.append("=");
            sb.append("[");
            sb.append(logValue);
            sb.append("]\n");
        }
        return sb.toString();
    }

    String flatten(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\n", " ").replace("\r", " ");
    }

    protected InputStream getInputStream(String filename) throws IOException {
        if (StringUtils.isNotEmpty((String)filename)) {
            return RiceUtilities.getResourceAsStream((String)filename);
        }
        return null;
    }

    void parseConfig(String filename, Unmarshaller unmarshaller, int depth) throws IOException {
        InputStream in = this.getInputStream(filename);
        String prefix = StringUtils.repeat((String)INDENT, (int)depth);
        if (in == null) {
            LOG.warn(prefix + "+ Skipping non-existent location [" + filename + "]");
            return;
        }
        if (this.isPropertiesFile(filename)) {
            this.loadProperties(in, prefix, filename);
        } else {
            this.loadRiceXML(in, prefix, filename, depth, unmarshaller);
        }
    }

    private void loadRiceXML(InputStream in, String prefix, String filename, int depth, Unmarshaller unmarshaller) throws IOException {
        LOG.info(prefix + "+ Parsing config: [" + filename + "]");
        Config config = this.unmarshalQuietly(unmarshaller, in);
        for (Param p : config.getParamList()) {
            if (p.getName().equals(IMPORT_NAME)) {
                this.doImport(p, unmarshaller, depth);
                continue;
            }
            if (p.isSystem().booleanValue()) {
                this.doSystem(p);
                continue;
            }
            if (!p.isOverride().booleanValue() && this.rawProperties.containsKey(p.getName())) continue;
            this.doSetProperty(prefix + "  --- ", p);
        }
        LOG.info(prefix + "- Parsed  config: [" + filename + "]");
    }

    private void loadProperties(InputStream in, String prefix, String filename) throws IOException {
        LOG.info(prefix + "+ Loading properties: [" + filename + "]");
        Properties properties = new Properties();
        properties.load(in);
        this.replaceVariables(prefix + "  --- ", properties);
        LOG.info(prefix + "- Loaded  properties: [" + filename + "]");
    }

    private boolean isPropertiesFile(String filename) {
        String lower = StringUtils.lowerCase((String)filename);
        return StringUtils.endsWith((String)lower, (String)".properties");
    }

    private void doSetProperty(String prefix, Param p) {
        String name = p.getName();
        if (p.isRandom().booleanValue()) {
            String randStr = String.valueOf(this.generateRandomInteger(p.getValue()));
            this.setProperty(prefix, p.getName(), randStr);
            LOG.info(prefix + "generating random string " + randStr + " for property " + p.getName());
        } else {
            String value = this.replaceVariable(name, p.getValue());
            this.setProperty(prefix, name, value);
        }
    }

    void doSystem(Param p) {
        this.doSystem("", p);
    }

    private void doSystem(String prefix, Param p) {
        boolean skip;
        boolean bl = skip = p.isOverride() == false && System.getProperty(p.getName()) != null;
        if (skip) {
            return;
        }
        String name = p.getName();
        if (p.isRandom().booleanValue()) {
            String randStr = String.valueOf(this.generateRandomInteger(p.getValue()));
            System.setProperty(name, randStr);
            this.setProperty(prefix + INDENT, p.getName(), randStr);
            LOG.info(prefix + "  --- generating random string " + randStr + " for system property " + p.getName());
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(p.getName());
            String value = this.parseValue(p.getValue(), set);
            System.setProperty(name, value);
            this.setProperty(prefix + INDENT, name, value);
        }
    }

    private void doImport(Param p, Unmarshaller unmarshaller, int depth) throws IOException {
        String configLocation = StringUtils.trim((String)this.parseValue(p.getValue(), new HashSet<String>()));
        this.parseConfig(configLocation, unmarshaller, depth + 1);
    }

    protected void setProperty(String name, String value) {
        this.setProperty("", name, value);
    }

    protected void setProperty(String prefix, String name, String value) {
        String oldValue = this.rawProperties.getProperty(name);
        Object msg = prefix == null ? "Raw Config Override: " : prefix + "Raw Config Override: ";
        this.logPropertyChange((String)msg, name, null, oldValue, value);
        this.rawProperties.setProperty(name, value);
    }

    protected String resolve(String key) {
        return this.resolve(key, null);
    }

    protected String resolve(String key, Set<String> keySet) {
        if (keySet != null && keySet.contains(key)) {
            throw new ConfigurationException("Circular reference in config: " + key);
        }
        String value = this.rawProperties.getProperty(key);
        if ((value == null || this.systemOverride) && System.getProperties().containsKey(key)) {
            value = System.getProperty(key);
        }
        if (value != null && value.contains("${")) {
            if (keySet == null) {
                keySet = new HashSet<String>();
            }
            keySet.add(key);
            value = this.parseValue(value, keySet);
            keySet.remove(key);
        }
        if (value == null) {
            value = "";
            LOG.debug("Property key: '" + key + "' is not available and hence set to empty");
        }
        return value;
    }

    private String parseValue(String value, Set<String> keySet) {
        String result = value;
        Matcher matcher = PATTERN.matcher(value);
        while (matcher.find()) {
            String key = matcher.group(1);
            String resolved = this.resolve(key, keySet);
            result = matcher.replaceFirst(Matcher.quoteReplacement(resolved));
            matcher = matcher.reset(result);
        }
        return result;
    }

    String replaceVariable(String name, String value) {
        String regex = "(?:\\$\\{" + name + "\\})";
        if (value.contains("${" + name + "}")) {
            String temporary = this.rawProperties.getProperty(name);
            if (temporary == null) {
                temporary = System.getProperty(name);
            }
            if (temporary != null) {
                return value.replaceAll(regex, Matcher.quoteReplacement(temporary));
            }
        }
        return value;
    }

    void resolveRawToCache() {
        if (this.rawProperties.size() == 0) {
            return;
        }
        Properties oldProps = new Properties(new ImmutableProperties(this.resolvedProperties));
        this.resolvedProperties.clear();
        TreeSet<String> keys = new TreeSet<String>(this.rawProperties.stringPropertyNames());
        for (String key : keys) {
            String newValue = this.resolve(key);
            String oldValue = oldProps.getProperty(key);
            String rawValue = this.rawProperties.getProperty(key);
            this.logPropertyChange("Resolved Config Override: ", key, rawValue, oldValue, newValue);
            this.resolvedProperties.setProperty(key, newValue);
        }
    }

    void logPropertyChange(String msg, String key, String rawValue, String oldValue, String newValue) {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        if (oldValue == null) {
            return;
        }
        if (StringUtils.equals((String)oldValue, (String)newValue)) {
            return;
        }
        String displayOld = this.flatten(ConfigLogger.getDisplaySafeValue(key, oldValue));
        String displayNew = this.flatten(ConfigLogger.getDisplaySafeValue(key, newValue));
        String displayRaw = this.flatten(rawValue);
        if (StringUtils.contains((String)rawValue, (String)"$")) {
            LOG.info(msg + key + "(" + displayRaw + ")=[" + displayOld + "]->[" + displayNew + "]");
        } else {
            LOG.info(msg + key + "=[" + displayOld + "]->[" + displayNew + "]");
        }
    }

    private void configureBuiltIns() {
        this.setProperty("host.ip", RiceUtilities.getIpNumber());
        this.setProperty("host.name", RiceUtilities.getHostName());
    }

    int generateRandomInteger(String rangeSpec) {
        return this.generateRandomInteger("", rangeSpec);
    }

    private int generateRandomInteger(String prefix, String rangeSpec) {
        int num;
        int to;
        String[] range = rangeSpec.split("-");
        if (range.length != 2) {
            throw new IllegalArgumentException("Invalid range specifier: " + rangeSpec);
        }
        int from = Integer.parseInt(range[0].trim());
        if (from > (to = Integer.parseInt(range[1].trim()))) {
            int tmp = from;
            from = to;
            to = tmp;
        }
        if (from == to) {
            num = from;
            LOG.info(prefix + "  --- from==to, so not generating random value for property.");
        } else {
            num = from + RANDOM.nextInt(to - from + 1);
        }
        return num;
    }

    boolean isSystemOverride() {
        return this.systemOverride;
    }

    void setSystemOverride(boolean systemOverride) {
        this.systemOverride = systemOverride;
    }

    private Config unmarshal(Unmarshaller unmarshaller, InputStream in) throws SAXException, ParserConfigurationException, IOException, IllegalStateException, JAXBException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        ConfigNamespaceURIFilter filter = new ConfigNamespaceURIFilter();
        filter.setParent(spf.newSAXParser().getXMLReader());
        UnmarshallerHandler handler = unmarshaller.getUnmarshallerHandler();
        filter.setContentHandler((ContentHandler)handler);
        filter.parse(new InputSource(in));
        return (Config)handler.getResult();
    }

    Config unmarshalQuietly(Unmarshaller unmarshaller, InputStream in) {
        try {
            return this.unmarshal(unmarshaller, in);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void putObject(String key, Object value) {
        this.objects.put(key, value);
    }

    public void putObjects(Map<String, Object> objects) {
        this.objects.putAll(objects);
    }

    public void removeObject(String key) {
        this.objects.remove(key);
    }

    public void removeProperty(String key) {
        this.rawProperties.remove(key);
        this.resolveRawToCache();
    }

    public void putConfig(org.kuali.rice.core.api.config.property.Config config) {
        this.copyConfig(config);
    }

    public String toString() {
        return String.valueOf(this.resolvedProperties);
    }

    public class ConfigNamespaceURIFilter
    extends XMLFilterImpl {
        static final String CONFIG_URI = "http://rice.kuali.org/core/impl/config";

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (StringUtils.isBlank((String)uri)) {
                uri = CONFIG_URI;
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (StringUtils.isBlank((String)uri)) {
                uri = CONFIG_URI;
            }
            super.endElement(uri, localName, qName);
        }
    }
}

