/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.api.country;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.location.api.country.Country;
import org.w3c.dom.Element;

@XmlRootElement(name="CountryQueryResults")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CountryQueryResultsType", propOrder={"results", "totalRowCount", "moreResultsAvailable", "_futureElements"})
public class CountryQueryResults
extends AbstractDataTransferObject
implements QueryResults<Country> {
    @XmlElementWrapper(name="results", required=false)
    @XmlElement(name="Country", required=false)
    private final List<Country> results;
    @XmlElement(name="totalRowCount", required=false)
    private final Integer totalRowCount;
    @XmlElement(name="moreResultsAvailable", required=true)
    private final boolean moreResultsAvailable;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private CountryQueryResults() {
        this.results = null;
        this.totalRowCount = null;
        this.moreResultsAvailable = false;
    }

    private CountryQueryResults(Builder builder) {
        ArrayList<Country> temp = new ArrayList<Country>();
        for (Country.Builder b : builder.getResults()) {
            if (b == null) continue;
            temp.add(b.build());
        }
        this.results = Collections.unmodifiableList(temp);
        this.totalRowCount = builder.getTotalRowCount();
        this.moreResultsAvailable = builder.isMoreResultsAvailable();
    }

    public List<Country> getResults() {
        return this.results;
    }

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    public boolean isMoreResultsAvailable() {
        return this.moreResultsAvailable;
    }

    public static class Elements {
        public static final String RESULTS = "results";
        public static final String RESULT_ELEM = "Country";
        public static final String TOTAL_ROW_COUNT = "totalRowCount";
        public static final String MORE_RESULTS_AVAILALBE = "moreResultsAvailable";
    }

    public static class Constants {
        public static final String ROOT_ELEMENT_NAME = "CountryQueryResults";
        public static final String TYPE_NAME = "CountryQueryResultsType";
    }

    public static class Builder
    implements ModelBuilder,
    QueryResults<Country.Builder> {
        private List<Country.Builder> results = new ArrayList<Country.Builder>();
        private Integer totalRowCount;
        private boolean moreResultsAvailable = false;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public CountryQueryResults build() {
            return new CountryQueryResults(this);
        }

        public List<Country.Builder> getResults() {
            return Collections.unmodifiableList(this.results);
        }

        public void setResults(List<Country.Builder> results) {
            this.results = new ArrayList<Country.Builder>(results);
        }

        public Integer getTotalRowCount() {
            return this.totalRowCount;
        }

        public void setTotalRowCount(Integer totalRowCount) {
            this.totalRowCount = totalRowCount;
        }

        public boolean isMoreResultsAvailable() {
            return this.moreResultsAvailable;
        }

        public void setMoreResultsAvailable(boolean moreResultsAvailable) {
            this.moreResultsAvailable = moreResultsAvailable;
        }
    }
}

