/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.engine;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.ModelObjectComplete;
import org.kuali.rice.krms.api.engine.Term;

public final class Facts
implements ModelObjectComplete,
Serializable {
    private static final long serialVersionUID = -1448089944850300846L;
    public static final Facts EMPTY_FACTS = new Facts(Builder.create());
    private Map<Term, Object> factMap;

    private Facts() {
    }

    private Facts(Builder b) {
        this.factMap = new HashMap<Term, Object>(b.factMap);
    }

    public Map<Term, Object> getFactMap() {
        return Collections.unmodifiableMap(this.factMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Facts facts = (Facts)o;
        return !(this.factMap != null ? !this.factMap.equals(facts.factMap) : facts.factMap != null);
    }

    public int hashCode() {
        return this.factMap != null ? this.factMap.hashCode() : 0;
    }

    public String toString() {
        return "Facts{factMap=" + this.factMap + "}";
    }

    public static class Builder {
        private Map<Term, Object> factMap = new HashMap<Term, Object>();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder addFact(String termName, Map<String, String> termParameters, Object factValue) {
            if (StringUtils.isEmpty((String)termName)) {
                throw new IllegalArgumentException("termName must not be null or empty");
            }
            this.factMap.put(new Term(termName, termParameters), factValue);
            return this;
        }

        public Builder addFact(String termName, Object factValue) {
            this.addFact(termName, null, factValue);
            return this;
        }

        public Builder addFact(Term term, Object factValue) {
            if (term == null) {
                throw new IllegalArgumentException("term must not be null");
            }
            this.factMap.put(term, factValue);
            return this;
        }

        public Builder addFactsByTerm(Map<Term, Object> facts) {
            if (facts != null) {
                this.factMap.putAll(facts);
            }
            return this;
        }

        public Builder addFactsByName(Map<String, Object> facts) {
            if (facts != null) {
                for (Map.Entry<String, Object> entry : facts.entrySet()) {
                    this.factMap.put(new Term(entry.getKey()), entry.getValue());
                }
            }
            return this;
        }

        public Facts build() {
            if (this.factMap.isEmpty()) {
                return EMPTY_FACTS;
            }
            return new Facts(this);
        }
    }
}

