/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceproxies;

import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.serviceproxies.MessageSendingTransactionSynchronization;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MessageSender {
    public static void sendMessage(PersistedMessageBO message) throws Exception {
        if (!Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("message.off")).booleanValue()) {
            if (ConfigContext.getCurrentContextConfig().getObject("SPRING_TRANSACTION_MANAGER") != null || ConfigContext.getCurrentContextConfig().getObject("transactionManager") != null) {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new MessageSendingTransactionSynchronization(message));
                } else {
                    KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(message));
                }
            } else {
                KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(message));
            }
        }
    }
}

