/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.service.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.security.admin.service.JavaSecurityManagementService;
import org.kuali.rice.ksb.security.service.DigitalSignatureService;

public class DigitalSignatureServiceImpl
implements DigitalSignatureService {
    @Override
    public Signature getSignatureForSigning() throws IOException, GeneralSecurityException {
        Signature signature = this.getSignature();
        signature.initSign(this.getJavaSecurityManagementService().getModulePrivateKey());
        return signature;
    }

    @Override
    public Signature getSignatureForVerification(String verificationAlias) throws IOException, GeneralSecurityException {
        Certificate cert = this.getJavaSecurityManagementService().getCertificate(verificationAlias);
        return this.getSignatureForVerification(cert);
    }

    @Override
    public Signature getSignatureForVerification(Certificate certificate) throws IOException, GeneralSecurityException {
        if (certificate == null) {
            throw new CertificateException("Could not find certificate");
        }
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey == null) {
            throw new KeyException("Could not find the public key from valid certificate");
        }
        Signature signature = this.getSignature();
        signature.initVerify(publicKey);
        return signature;
    }

    protected Signature getSignature() throws GeneralSecurityException {
        return Signature.getInstance(this.getJavaSecurityManagementService().getModuleSignatureAlgorithm());
    }

    protected JavaSecurityManagementService getJavaSecurityManagementService() {
        return (JavaSecurityManagementService)GlobalResourceLoader.getService((String)"rice.ksb.javaSecurityManagementService");
    }
}

