/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.web;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;

public abstract class KSBAction
extends DispatchAction {
    private static final Logger LOG = LogManager.getLogger(KSBAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.checkAuthorization(form, "");
        if (this.isModuleLocked(form, this.findMethodToCall(form, request), request)) {
            return mapping.findForward("moduleLocked");
        }
        try {
            ActionMessages messages = null;
            messages = this.establishRequiredState(request, form);
            if (messages != null && !messages.isEmpty()) {
                if (messages instanceof ActionErrors) {
                    this.saveErrors(request, messages);
                } else {
                    this.saveMessages(request, messages);
                }
                return mapping.findForward("requiredStateError");
            }
            LOG.info(request.getQueryString());
            ActionForward returnForward = null;
            if (request.getParameterMap() != null) {
                Iterator iter = request.getParameterMap().entrySet().iterator();
                while (iter.hasNext()) {
                    String methodToCall;
                    String parameterName = (String)iter.next().getKey();
                    if (!parameterName.startsWith("methodToCall.") || !parameterName.endsWith(".x") || (methodToCall = parameterName.substring(parameterName.indexOf("methodToCall.") + 13, parameterName.lastIndexOf(".x"))) == null || methodToCall.length() <= 0) continue;
                    returnForward = this.dispatchMethod(mapping, form, request, response, methodToCall);
                }
            }
            if (returnForward == null) {
                if (request.getParameter("methodToCall") != null && !"".equals(request.getParameter("methodToCall")) && !"execute".equals(request.getParameter("methodToCall"))) {
                    LOG.info("dispatch to methodToCall " + request.getParameter("methodToCall") + " called");
                    returnForward = super.execute(mapping, form, request, response);
                } else {
                    LOG.info("dispatch to default start methodToCall");
                    returnForward = this.start(mapping, form, request, response);
                }
            }
            if ((messages = this.establishFinalState(request, form)) != null && !messages.isEmpty()) {
                this.saveMessages(request, messages);
                return mapping.findForward("finalStateError");
            }
            return returnForward;
        }
        catch (Exception e) {
            LOG.error("Error processing action " + mapping.getPath(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        HashMap<String, String> roleQualifier = new HashMap<String, String>(this.getRoleQualification(form, methodToCall));
        Map permissionDetails = KRADUtils.getNamespaceAndActionClass(((Object)((Object)this)).getClass());
        if (!KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(principalId, "KR-NS", "Use Screen", permissionDetails, roleQualifier)) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalName(), methodToCall, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    protected Map<String, String> getRoleQualification(ActionForm form, String methodToCall) {
        return new HashMap<String, String>();
    }

    public abstract ActionForward start(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.start(mapping, form, request, response);
    }

    public abstract ActionMessages establishRequiredState(HttpServletRequest var1, ActionForm var2) throws Exception;

    public ActionMessages establishFinalState(HttpServletRequest request, ActionForm form) throws Exception {
        return null;
    }

    public ActionForward noOp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    protected static KualiModuleService getKualiModuleService() {
        return KRADServiceLocatorWeb.getKualiModuleService();
    }

    protected String findMethodToCall(ActionForm form, HttpServletRequest request) throws Exception {
        String methodToCall = form instanceof KualiForm && StringUtils.isNotEmpty((String)((KualiForm)form).getMethodToCall()) ? ((KualiForm)form).getMethodToCall() : WebUtils.parseMethodToCall((ActionForm)form, (HttpServletRequest)request);
        return methodToCall;
    }

    protected boolean isModuleLocked(ActionForm form, String methodToCall, HttpServletRequest request) {
        String boClass = request.getParameter("businessObjectClassName");
        ModuleService moduleService = null;
        if (StringUtils.isNotBlank((String)boClass)) {
            try {
                moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(Class.forName(boClass));
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Module locking mechanism experienced a class not found exception while trying to load " + boClass, (Throwable)e);
            }
        } else {
            moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(((Object)((Object)this)).getClass());
        }
        if (moduleService != null && moduleService.isLocked()) {
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            String namespaceCode = "KR-SYS";
            String permissionName = "Access Locked Module";
            HashMap permissionDetails = new HashMap();
            HashMap<String, String> qualification = new HashMap<String, String>(this.getRoleQualification(form, methodToCall));
            if (!KimApiServiceLocator.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, qualification)) {
                String messageParamName;
                String messageParamComponentCode;
                String messageParamNamespaceCode;
                ParameterService parameterSerivce = CoreFrameworkServiceLocator.getParameterService();
                String lockoutMessage = parameterSerivce.getParameterValueAsString(messageParamNamespaceCode = moduleService.getModuleConfiguration().getNamespaceCode(), messageParamComponentCode = "All", messageParamName = "OLTP_LOCKOUT_MESSAGE");
                if (StringUtils.isBlank((String)lockoutMessage)) {
                    String defaultMessageParamName = "OLTP_LOCKOUT_DEFAULT_MESSAGE";
                    lockoutMessage = parameterSerivce.getParameterValueAsString("KR-NS", messageParamComponentCode, defaultMessageParamName);
                }
                request.setAttribute("moduleLockedMessage", (Object)lockoutMessage);
                return true;
            }
        }
        return false;
    }
}

