/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.common.attribute;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.CompositePredicate;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.criteria.MultiValuedPredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.PropertyPathPredicate;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.SingleValuedPredicate;
import org.kuali.rice.core.api.criteria.Transform;

public final class AttributeTransform
implements Transform<QueryByCriteria, QueryByCriteria> {
    private static final Transform<QueryByCriteria, QueryByCriteria> INSTANCE = new AttributeTransform();
    private static final String ATTRIBUTE_DETAILS_ATTRIBUTE_VALUE = "attributeDetails.attributeValue";
    private static final String ATTRIBUTE_DETAILS_ATTRIBUTE_NAME = "attributeDetails.kimAttribute.attributeName";
    private static final String ATTRIBUTES_REGEX = "^attributes\\[\\w*\\]$";
    private static final Pattern ATTRIBUTES_PATTERN = Pattern.compile("^attributes\\[\\w*\\]$");

    private AttributeTransform() {
    }

    public QueryByCriteria apply(QueryByCriteria input) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create((QueryByCriteria)input);
        builder.setPredicates(new Predicate[]{this.applyPredicate(input.getPredicate())});
        return builder.build();
    }

    private Predicate applyPredicate(Predicate input) {
        if (input instanceof PropertyPathPredicate) {
            String pp = ((PropertyPathPredicate)input).getPropertyPath();
            if (this.isAttributesPredicate(pp)) {
                Predicate attrValue;
                String attributeName = pp.substring(pp.indexOf(91) + 1, pp.indexOf(93));
                if (input instanceof SingleValuedPredicate) {
                    CriteriaValue value = ((SingleValuedPredicate)input).getValue();
                    attrValue = PredicateFactory.dynConstruct((String)input.getClass().getSimpleName(), (Object[])new Object[]{ATTRIBUTE_DETAILS_ATTRIBUTE_VALUE, value.getValue()});
                } else if (input instanceof MultiValuedPredicate) {
                    Set values = ((MultiValuedPredicate)input).getValues();
                    ArrayList<Object> l = new ArrayList<Object>();
                    for (CriteriaValue v : values) {
                        l.add(v.getValue());
                    }
                    attrValue = PredicateFactory.dynConstruct((String)input.getClass().getSimpleName(), (Object[])new Object[]{ATTRIBUTE_DETAILS_ATTRIBUTE_VALUE, l.toArray()});
                } else {
                    attrValue = PredicateFactory.dynConstruct((String)input.getClass().getSimpleName(), (Object[])new Object[]{ATTRIBUTE_DETAILS_ATTRIBUTE_VALUE});
                }
                return PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)ATTRIBUTE_DETAILS_ATTRIBUTE_NAME, (Object)attributeName), attrValue});
            }
        } else if (input instanceof CompositePredicate) {
            return this.applyCompositePredicate((CompositePredicate)input);
        }
        return input;
    }

    private Predicate applyCompositePredicate(CompositePredicate input) {
        HashSet<Predicate> appliedPredicates = new HashSet<Predicate>();
        for (Predicate predicate : input.getPredicates()) {
            appliedPredicates.add(this.applyPredicate(predicate));
        }
        Predicate[] appliedPredicatesArray = (Predicate[])Iterables.toArray(appliedPredicates, Predicate.class);
        if (input instanceof AndPredicate) {
            return PredicateFactory.and((Predicate[])appliedPredicatesArray);
        }
        if (input instanceof OrPredicate) {
            return PredicateFactory.or((Predicate[])appliedPredicatesArray);
        }
        return input;
    }

    private boolean isAttributesPredicate(String pp) {
        Matcher matcher = ATTRIBUTES_PATTERN.matcher(pp);
        return matcher.matches();
    }

    public static Transform<QueryByCriteria, QueryByCriteria> getInstance() {
        return INSTANCE;
    }
}

