/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.group.GroupMember;
import org.kuali.rice.kim.api.group.GroupMemberContract;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.group.GroupMemberBo;
import org.kuali.rice.kim.impl.role.RoleInternalService;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RoleServiceBase;
import org.kuali.rice.krad.data.PersistenceOption;

public class RoleInternalServiceImpl
extends RoleServiceBase
implements RoleInternalService {
    @Override
    public void principalInactivated(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("principalId is null or blank");
        }
        long oneDayInMillis = TimeUnit.DAYS.toMillis(1L);
        Timestamp yesterday = new Timestamp(System.currentTimeMillis() - oneDayInMillis);
        this.inactivatePrincipalRoleMemberships(principalId, yesterday);
        this.inactivatePrincipalGroupMemberships(principalId, yesterday);
        this.inactivatePrincipalDelegations(principalId, yesterday);
        this.inactivateApplicationRoleMemberships(principalId, yesterday);
    }

    @Override
    public void roleInactivated(String roleId) {
        if (StringUtils.isBlank((String)roleId)) {
            throw new IllegalArgumentException("roleId is null or blank");
        }
        long oneDayInMillis = TimeUnit.DAYS.toMillis(1L);
        Timestamp yesterday = new Timestamp(System.currentTimeMillis() - oneDayInMillis);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId);
        this.inactivateRoleMemberships(roleIds, yesterday);
        this.inactivateRoleDelegations(roleIds, yesterday);
        this.inactivateMembershipsForRoleAsMember(roleIds, yesterday);
    }

    private void inactivateRoleMemberships(List<String> roleIds, Timestamp yesterday) {
        List<RoleMemberBo> roleMemberBoList = this.getStoredRoleMembersForRoleIds(roleIds, null, null);
        for (RoleMemberBo roleMemberBo : roleMemberBoList) {
            roleMemberBo.setActiveToDateValue(yesterday);
            this.notifyOnMemberRemoval(RoleMemberBo.to(roleMemberBo));
            this.getDataObjectService().save((Object)roleMemberBo, new PersistenceOption[0]);
        }
    }

    private void inactivateRoleDelegations(List<String> roleIds, Timestamp yesterday) {
        List<DelegateTypeBo> delegations = this.getStoredDelegationImplsForRoleIds(roleIds);
        for (DelegateTypeBo delegation : delegations) {
            delegation.setActive(false);
            for (DelegateMemberBo delegationMember : delegation.getMembers()) {
                delegationMember.setActiveToDateValue(yesterday);
                this.getDataObjectService().save((Object)delegationMember, new PersistenceOption[0]);
            }
        }
    }

    private void inactivateMembershipsForRoleAsMember(List<String> roleIds, Timestamp yesterday) {
        List<RoleMemberBo> roleMemberBoList = this.getStoredRoleMembershipsForRoleIdsAsMembers(roleIds, null);
        for (RoleMemberBo roleMemberBo : roleMemberBoList) {
            roleMemberBo.setActiveToDateValue(yesterday);
            this.notifyOnMemberRemoval(RoleMemberBo.to(roleMemberBo));
            this.getDataObjectService().save((Object)roleMemberBo, new PersistenceOption[0]);
        }
    }

    @Override
    public void groupInactivated(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("groupId is null or blank");
        }
        long oneDayInMillis = TimeUnit.DAYS.toMillis(1L);
        Timestamp yesterday = new Timestamp(System.currentTimeMillis() - oneDayInMillis);
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add(groupId);
        this.inactivatePrincipalGroupMemberships(groupIds, yesterday);
        this.inactivateGroupRoleMemberships(groupIds, yesterday);
    }

    protected void inactivateApplicationRoleMemberships(String principalId, Timestamp yesterday) {
    }

    protected void inactivatePrincipalRoleMemberships(String principalId, Timestamp yesterday) {
        List<RoleMemberBo> roleMembers = this.getStoredRolePrincipalsForPrincipalIdAndRoleIds(null, principalId, null);
        HashSet<String> roleIds = new HashSet<String>(roleMembers.size());
        for (RoleMemberBo roleMemberBo : roleMembers) {
            roleMemberBo.setActiveToDateValue(yesterday);
            roleIds.add(roleMemberBo.getRoleId());
            this.notifyOnMemberRemoval(RoleMemberBo.to(roleMemberBo));
            this.getDataObjectService().save((Object)roleMemberBo, new PersistenceOption[0]);
        }
    }

    protected void inactivateGroupRoleMemberships(List<String> groupIds, Timestamp yesterday) {
        List<RoleMemberBo> roleMemberBosOfGroupType = this.getStoredRoleGroupsForGroupIdsAndRoleIds(null, groupIds, null);
        for (RoleMemberBo roleMemberBo : roleMemberBosOfGroupType) {
            roleMemberBo.setActiveToDateValue(yesterday);
            this.notifyOnMemberRemoval(RoleMemberBo.to(roleMemberBo));
            this.getDataObjectService().save((Object)roleMemberBo, new PersistenceOption[0]);
        }
    }

    protected void inactivatePrincipalGroupMemberships(String principalId, Timestamp yesterday) {
        if (StringUtils.isBlank((String)principalId)) {
            return;
        }
        List groupIds = this.getGroupService().getGroupIdsByPrincipalId(principalId);
        if (groupIds.isEmpty()) {
            return;
        }
        List groupMembers = this.getGroupService().getMembers(groupIds);
        ArrayList<GroupMember> groupPrincipals = new ArrayList<GroupMember>(groupMembers.size());
        for (GroupMember groupMembershipInfo : groupMembers) {
            if (!MemberType.PRINCIPAL.equals((Object)groupMembershipInfo.getType()) || !StringUtils.equals((String)principalId, (String)groupMembershipInfo.getMemberId()) || !groupMembershipInfo.isActive(new DateTime())) continue;
            groupPrincipals.add(groupMembershipInfo);
        }
        for (GroupMember gm : groupPrincipals) {
            GroupMember.Builder builder = GroupMember.Builder.create((GroupMemberContract)gm);
            builder.setActiveToDate(new DateTime(yesterday.getTime()));
            this.getDataObjectService().save((Object)GroupMemberBo.from(builder.build()), new PersistenceOption[0]);
        }
    }

    protected void inactivatePrincipalGroupMemberships(List<String> groupIds, Timestamp yesterday) {
        if (groupIds == null || groupIds.isEmpty()) {
            return;
        }
        List groupMemberships = this.getGroupService().getMembers(groupIds);
        if (groupMemberships.isEmpty()) {
            return;
        }
        ArrayList<GroupMember> groupMembers = new ArrayList<GroupMember>();
        for (GroupMember groupMembershipInfo : groupMemberships) {
            if (!MemberType.GROUP.equals((Object)groupMembershipInfo.getType()) || !groupMembershipInfo.isActive(new DateTime())) continue;
            groupMembers.add(groupMembershipInfo);
        }
        for (GroupMember groupMember : groupMembers) {
            GroupMember.Builder builder = GroupMember.Builder.create((GroupMemberContract)groupMember);
            builder.setActiveToDate(new DateTime(yesterday.getTime()));
            this.getDataObjectService().save((Object)GroupMemberBo.from(builder.build()), new PersistenceOption[0]);
        }
    }

    protected void inactivatePrincipalDelegations(String principalId, Timestamp yesterday) {
        List<DelegateMemberBo> delegationMembers = this.getStoredDelegationPrincipalsForPrincipalIdAndDelegationIds(null, principalId);
        for (DelegateMemberBo delegateMemberBo : delegationMembers) {
            delegateMemberBo.setActiveToDateValue(yesterday);
            this.getDataObjectService().save((Object)delegateMemberBo, new PersistenceOption[0]);
        }
    }
}

