/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.config.property;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClasspathOrFileResourceLoader;
import org.kuali.rice.core.api.util.Truth;

public abstract class AbstractBaseConfig
implements Config {
    public abstract Object getObject(String var1);

    public abstract Map<String, Object> getObjects();

    public abstract Properties getProperties();

    public abstract String getProperty(String var1);

    public abstract void parseConfig() throws IOException;

    public Map<String, String> getPropertiesWithPrefix(String prefix, boolean stripPrefix) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!StringUtils.isNotBlank((String)key) || !key.trim().startsWith(prefix)) continue;
            props.put(stripPrefix ? key.substring(prefix.length()) : key, (String)entry.getValue());
        }
        return props;
    }

    public String getAlternateOJBFile() {
        return this.getProperty("config.obj.file");
    }

    public String getAlternateSpringFile() {
        return this.getProperty("config.spring.file");
    }

    public String getBaseWebServiceURL() {
        return this.getProperty("webservices.settings.url");
    }

    public String getBaseWebServiceWsdlPath() {
        return this.getProperty("webservices.settings.wsdl.path");
    }

    public Boolean getBatchMode() {
        return Boolean.valueOf(this.getProperty("rice.ksb.batch.mode"));
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return Truth.strToBooleanIgnoreCase((String)this.getProperty(key), (Boolean)defaultValue);
    }

    public Boolean getBooleanProperty(String key) {
        return Truth.strToBooleanIgnoreCase((String)this.getProperty(key));
    }

    public long getNumericProperty(String key, long defaultValue) {
        Long propertyValue = this.getNumericProperty(key);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    public Long getNumericProperty(String key) {
        String propertyValue = this.getProperty(key);
        if (StringUtils.isBlank((String)propertyValue)) {
            return null;
        }
        return new Long(propertyValue);
    }

    public String getClientWSDLFullPathAndFileName() {
        return this.getProperty("webservices.settings.wsdd.path");
    }

    public String getDailyEmailFirstDeliveryDate() {
        return this.getProperty("email.daily.firstDeliveryDate");
    }

    public String getDefaultKewNoteClass() {
        return this.getProperty("default.kew.note.class");
    }

    public Boolean getDevMode() {
        return Boolean.valueOf(this.getProperty("dev.mode"));
    }

    public String getDocumentLockTimeout() {
        return this.getProperty("document.lock.timeout");
    }

    public String getEmailConfigurationPath() {
        return this.getProperty("email.security.path");
    }

    public Boolean getEmailReminderLifecycleEnabled() {
        return Boolean.valueOf(this.getProperty("email.reminder.lifecycle.enabled"));
    }

    public String getEndPointUrl() {
        return this.getProperty("serviceServletUrl");
    }

    public String getEnvironment() {
        return this.getProperty("environment");
    }

    public String getProductionEnvironmentCode() {
        return this.getProperty("production.environment.code");
    }

    public boolean isProductionEnvironment() {
        String env = this.getEnvironment();
        String prod = this.getProductionEnvironmentCode();
        return env != null && prod != null && StringUtils.equalsIgnoreCase((String)env, (String)prod);
    }

    public String getRiceVersion() {
        return this.getProperty("rice.version");
    }

    public String getApplicationName() {
        String val = this.getProperty("application.name");
        if (val == null) {
            val = this.getProperty("module.name");
        }
        return val;
    }

    public String getApplicationVersion() {
        String val = this.getProperty("application.version");
        if (val == null) {
            val = this.getProperty("version");
        }
        return val;
    }

    public String getKENBaseURL() {
        return this.getProperty("ken.url");
    }

    public String getKEWBaseURL() {
        return this.getProperty("kew.url");
    }

    public String getKIMBaseURL() {
        return this.getProperty("kim.url");
    }

    public String getKRBaseURL() {
        return this.getProperty("kr.url");
    }

    public String getKeystoreAlias() {
        return this.getProperty("keystore.alias");
    }

    public String getKeystoreFile() throws IOException {
        String keyStoreFile = this.getProperty("keystore.file");
        return new ClasspathOrFileResourceLoader().getResource(keyStoreFile).getURL().getPath();
    }

    public String getKeystorePassword() {
        return this.getProperty("keystore.password");
    }

    public String getLog4jFileLocation() {
        return this.getProperty("log4j.settings.path");
    }

    public String getLog4jReloadInterval() {
        return this.getProperty("log4j.settings.reloadInterval");
    }

    public Boolean getOutBoxOn() {
        return Boolean.valueOf(this.getProperty("actionlist.outbox"));
    }

    public Integer getRefreshRate() {
        return new Integer(ConfigContext.getCurrentContextConfig().getProperty("bus.refresh.rate"));
    }

    public String getTransactionTimeout() {
        return this.getProperty("transaction.timeout");
    }

    public String getWebServicesConnectRetry() {
        return this.getProperty("webservices.settings.connect.retry");
    }

    public String getWeeklyEmailFirstDeliveryDate() {
        return this.getProperty("email.weekly.firstDeliveryDate");
    }

    public Boolean getXmlPipelineLifeCycleEnabled() {
        return Boolean.valueOf(this.getProperty("xml.pipeline.lifecycle.enabled"));
    }
}

