/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment;

import java.util.Collections;
import java.util.List;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.propdev.impl.attachment.NarrativeAuthZService;
import org.kuali.coeus.propdev.impl.attachment.NarrativeRight;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="narrativeAuthZService")
public class NarrativeAuthZServiceImpl
implements NarrativeAuthZService {
    @Autowired
    @Qualifier(value="systemAuthorizationService")
    private SystemAuthorizationService systemAuthorizationService;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kcAuthorizationService;

    @Override
    public NarrativeRight getDefaultNarrativeRight(String userId, ProposalDevelopmentDocument doc) {
        NarrativeRight right = this.getKcAuthorizationService().hasPermission(userId, doc, "Modify Narrative") ? NarrativeRight.MODIFY_NARRATIVE_RIGHT : (this.getKcAuthorizationService().hasPermission(userId, doc, "View Narratives") ? NarrativeRight.VIEW_NARRATIVE_RIGHT : NarrativeRight.NO_NARRATIVE_RIGHT);
        return right;
    }

    @Override
    public NarrativeRight getDefaultNarrativeRight(String roleName) {
        return this.getDefaultNarrativeRight(Collections.singletonList(roleName));
    }

    protected NarrativeRight getDefaultNarrativeRight(List<String> roleNames) {
        List<String> matchingRoleNames = this.getSystemAuthorizationService().getRoleNamesForPermission("Modify Narrative", "KC-PD");
        for (String role : roleNames) {
            if (!matchingRoleNames.contains(role)) continue;
            return NarrativeRight.MODIFY_NARRATIVE_RIGHT;
        }
        matchingRoleNames.clear();
        matchingRoleNames = this.getSystemAuthorizationService().getRoleNamesForPermission("View Narratives", "KC-PD");
        for (String role : roleNames) {
            if (!matchingRoleNames.contains(role)) continue;
            return NarrativeRight.VIEW_NARRATIVE_RIGHT;
        }
        return NarrativeRight.NO_NARRATIVE_RIGHT;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    protected SystemAuthorizationService getSystemAuthorizationService() {
        return this.systemAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kcAuthorizationService = kraAuthorizationService;
    }

    protected KcAuthorizationService getKcAuthorizationService() {
        return this.kcAuthorizationService;
    }
}

